/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.genstar;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine1;
import com.denfop.integration.jei.genstar.GenStarRecipeManager;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GenStarCategory
extends Gui
implements IRecipeCategory<GenStarRecipeManager> {
    private final IDrawableStatic bg;
    private int progress = 0;
    private int energy = 0;

    public GenStarCategory(IGuiHelper guiHelper) {
        this.bg = guiHelper.createDrawable(new ResourceLocation("industrialupgrade", "textures/gui/GuiWitherMaker.png"), 3, 3, 147, 75);
    }

    @Nonnull
    public String getUid() {
        return BlockBaseMachine1.gen_wither.func_176610_l();
    }

    @Nonnull
    public String getTitle() {
        return Localization.translate(new ItemStack((Block)IUItem.basemachine, 1, 13).func_77977_a());
    }

    @Nonnull
    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void drawExtras(@Nonnull Minecraft mc) {
        ++this.progress;
        ++this.energy;
        int energylevel = (int)Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        int xScale = 40 * this.progress / 100;
        if (xScale > 40) {
            this.progress = 0;
        }
        mc.func_110434_K().func_110577_a(this.getTexture());
        this.func_73729_b(76, 62 - energylevel, 176, 14 - energylevel, 14, energylevel);
        this.func_73729_b(78, 13, 177, 19, xScale + 1, 18);
    }

    public void setRecipe(IRecipeLayout layout, GenStarRecipeManager recipes, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup isg = layout.getItemStacks();
        isg.init(0, true, 7, 4);
        isg.set(0, recipes.getInput());
        isg.init(1, true, 25, 4);
        isg.set(1, recipes.getInput1());
        isg.init(2, true, 43, 4);
        isg.set(2, recipes.getInput2());
        isg.init(3, true, 7, 22);
        isg.set(3, recipes.getInput3());
        isg.init(4, true, 25, 22);
        isg.set(4, recipes.getInput4());
        isg.init(5, true, 43, 22);
        isg.set(5, recipes.getInput5());
        isg.init(6, true, 25, 40);
        isg.set(6, recipes.getInput6());
        isg.init(7, false, 127, 9);
        isg.set(7, recipes.getOutput());
    }

    protected ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/GuiWitherMaker.png");
    }
}

