/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.compressor;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class CompressorHandler {
    private static final List<CompressorHandler> recipes = new ArrayList<CompressorHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public CompressorHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<CompressorHandler> getRecipes() {
        if (recipes.isEmpty()) {
            CompressorHandler.initRecipes();
        }
        return recipes;
    }

    public static CompressorHandler addRecipe(ItemStack input, ItemStack output) {
        CompressorHandler recipe = new CompressorHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static CompressorHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        for (CompressorHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("compressor")) {
            try {
                CompressorHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
            }
            catch (Exception e) {
                throw new RuntimeException();
            }
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public boolean matchesInput(ItemStack is) {
        return is.func_77973_b() == this.input.func_77973_b();
    }
}

