/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.combmac;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class CombMacHandler {
    private static final List<CombMacHandler> recipes = new ArrayList<CombMacHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public CombMacHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
        this.output.func_190920_e(3);
    }

    public static List<CombMacHandler> getRecipes() {
        if (recipes.isEmpty()) {
            CombMacHandler.initRecipes();
        }
        return recipes;
    }

    public static CombMacHandler addRecipe(ItemStack input, ItemStack output) {
        CombMacHandler recipe = new CombMacHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static CombMacHandler getRecipe(ItemStack is) {
        if (is == null || is.func_190926_b()) {
            return null;
        }
        for (CombMacHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("comb_macerator")) {
            CombMacHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.func_77946_l();
    }

    public boolean matchesInput(ItemStack is) {
        return is.func_77973_b() == this.input.func_77973_b();
    }
}

