/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.anvil;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class AnvilHandler {
    private static final List<AnvilHandler> recipes = new ArrayList<AnvilHandler>();
    private final ItemStack input;
    private final ItemStack output;

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public AnvilHandler(ItemStack input, ItemStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<AnvilHandler> getRecipes() {
        if (recipes.isEmpty()) {
            AnvilHandler.initRecipes();
        }
        return recipes;
    }

    public static AnvilHandler addRecipe(ItemStack input, ItemStack output) {
        AnvilHandler recipe = new AnvilHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("anvil")) {
            AnvilHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0));
        }
    }
}

