/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.crafttweaker;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.integration.crafttweaker.BaseAction;
import com.denfop.integration.crafttweaker.IC2InputItemStack;
import com.denfop.items.resource.ItemIngots;
import com.denfop.recipe.IInputHandler;
import com.denfop.recipe.IInputItemStack;
import com.denfop.utils.ModUtils;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.industrialupgrade.MineralSeparator")
@ModOnly(value="industrialupgrade")
@ZenRegister
public class CTMineralSeparator {
    @ZenMethod
    public static void addRecipe(IItemStack[] output, IIngredient input, short temperature, int ... col) {
        CraftTweakerAPI.apply((IAction)new AddMineralSeparatorIngredientAction(output, input, temperature, col));
    }

    @ZenMethod
    public static void removeRecipe(IItemStack output) {
        CraftTweakerAPI.apply((IAction)new RemoveMineralSeparatorIngredientAction(output));
    }

    private static class RemoveMineralSeparatorIngredientAction
    extends BaseAction {
        private final IItemStack input;

        public RemoveMineralSeparatorIngredientAction(IItemStack input) {
            super("handlerho");
            this.input = input;
        }

        public static ItemStack getItemStack(IItemStack item) {
            if (item == null) {
                return null;
            }
            Object internal = item.getInternal();
            if (!(internal instanceof ItemStack)) {
                CraftTweakerAPI.logError((String)("Not a valid item stack: " + item));
            }
            assert (internal instanceof ItemStack);
            return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
        }

        public void apply() {
            Recipes.recipes.addRemoveRecipe("converter", Recipes.recipes.getRecipeOutput((String)"handlerho", (boolean)false, (ItemStack[])new ItemStack[]{RemoveMineralSeparatorIngredientAction.getItemStack((IItemStack)this.input)}).getOutput().items.get(0));
        }

        @Override
        public String describe() {
            return "removing mineral separator recipe " + this.input;
        }

        public Object getOverrideKey() {
            return null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RemoveMineralSeparatorIngredientAction that = (RemoveMineralSeparatorIngredientAction)o;
            return Objects.equals(this.input, that.input);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.input);
        }
    }

    private static class AddMineralSeparatorIngredientAction
    extends BaseAction {
        private final IItemStack[] output;
        private final IIngredient input;
        private final short temperature;
        private final int[] col;

        public AddMineralSeparatorIngredientAction(IItemStack[] output, IIngredient input, short temperature, int[] col) {
            super("handlerho");
            this.output = output;
            this.input = input;
            this.temperature = temperature;
            this.col = col;
        }

        public static ItemStack getItemStack(IItemStack item) {
            if (item == null) {
                return null;
            }
            Object internal = item.getInternal();
            if (!(internal instanceof ItemStack)) {
                CraftTweakerAPI.logError((String)("Not a valid item stack: " + item));
            }
            assert (internal instanceof ItemStack);
            return new ItemStack(((ItemStack)internal).func_77973_b(), item.getAmount(), item.getDamage());
        }

        public static ItemStack[] getItemStack(IItemStack[] item) {
            if (item == null) {
                return null;
            }
            Object internal = item[0].getInternal();
            if (!(internal instanceof ItemStack)) {
                CraftTweakerAPI.logError((String)("Not a valid item stack: " + item[0]));
            }
            ItemStack[] itemStacks = new ItemStack[item.length];
            assert (internal instanceof ItemStack);
            for (int i = 0; i < itemStacks.length; ++i) {
                itemStacks[i] = new ItemStack(((ItemStack)item[i].getInternal()).func_77973_b(), item[i].getAmount(), item[i].getDamage());
            }
            return itemStacks;
        }

        public void apply() {
            NBTTagCompound nbt = ModUtils.nbt();
            nbt.func_74777_a("temperature", this.temperature);
            for (int i = 0; i < this.col.length; ++i) {
                nbt.func_74768_a("input" + i, this.col[i]);
            }
            IInputHandler input = Recipes.inputFactory;
            ItemStack stack = new IC2InputItemStack(this.input).getInputs().get(0);
            IInputItemStack second1 = OreDictionary.getOreIDs((ItemStack)stack).length > 0 && !OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)stack)[0]).isEmpty() && stack.func_77973_b() instanceof ItemIngots ? input.getInput(OreDictionary.getOreName((int)OreDictionary.getOreIDs((ItemStack)stack)[0])) : input.getInput(stack);
            Recipes.recipes.addAdderRecipe("handlerho", new BaseMachineRecipe(new Input(second1), new RecipeOutput(nbt, AddMineralSeparatorIngredientAction.getItemStack(this.output))));
        }

        @Override
        public String describe() {
            return "";
        }

        public Object getOverrideKey() {
            return null;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AddMineralSeparatorIngredientAction that = (AddMineralSeparatorIngredientAction)o;
            return this.temperature == that.temperature && Arrays.equals(this.output, that.output) && Objects.equals(this.input, that.input) && Arrays.equals(this.col, that.col);
        }

        @Override
        public int hashCode() {
            int result = Objects.hash(super.hashCode(), this.input, this.temperature);
            result = 31 * result + Arrays.hashCode(this.output);
            result = 31 * result + Arrays.hashCode(this.col);
            return result;
        }
    }
}

