/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.heat;

import com.denfop.api.energy.SystemTick;
import com.denfop.api.heat.IHeatAcceptor;
import com.denfop.api.heat.IHeatConductor;
import com.denfop.api.heat.IHeatEmitter;
import com.denfop.api.heat.IHeatSink;
import com.denfop.api.heat.IHeatSource;
import com.denfop.api.heat.IHeatTile;
import com.denfop.api.sytem.InfoTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class HeatNetLocal {
    final List<SystemTick<IHeatSource, HeatPath>> senderPath = new ArrayList<SystemTick<IHeatSource, HeatPath>>();
    private final Map<BlockPos, IHeatTile> chunkCoordinatesIHeatTileMap;
    final List<IHeatSource> sourceToUpdateList = new ArrayList<IHeatSource>();

    HeatNetLocal() {
        this.chunkCoordinatesIHeatTileMap = new HashMap<BlockPos, IHeatTile>();
    }

    public void addTile(IHeatTile tile1) {
        this.addTileEntity(this.getTileFromIHeat(tile1).func_174877_v(), tile1);
    }

    public void addTile(IHeatTile tile, TileEntity tileentity) {
        BlockPos coords = tileentity.func_174877_v();
        if (this.chunkCoordinatesIHeatTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesIHeatTileMap.put(coords, tile);
        this.update(coords);
        if (tile instanceof IHeatAcceptor) {
            this.onTileEntityAdded((IHeatAcceptor)tile);
        }
        if (tile instanceof IHeatSource) {
            this.senderPath.add(new SystemTick((IHeatSource)tile, null));
        }
    }

    public List<HeatPath> getPaths(IHeatAcceptor par1) {
        ArrayList<HeatPath> paths = new ArrayList<HeatPath>();
        List<SystemTick<IHeatSource, HeatPath>> sources_list = this.getSources(par1);
        if (sources_list == null || sources_list.isEmpty()) {
            return paths;
        }
        for (SystemTick<IHeatSource, HeatPath> source : sources_list) {
            if (!this.containsKey(source)) continue;
            paths.addAll(source.getList());
        }
        return paths;
    }

    public BlockPos getPos(IHeatTile tile) {
        if (tile == null) {
            return null;
        }
        return tile.getBlockPos();
    }

    public void addTileEntity(BlockPos coords, IHeatTile tile) {
        if (this.chunkCoordinatesIHeatTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesIHeatTileMap.put(coords, tile);
        this.update(coords);
        if (tile instanceof IHeatAcceptor) {
            this.onTileEntityAdded((IHeatAcceptor)tile);
        }
        if (tile instanceof IHeatSource) {
            this.senderPath.add(new SystemTick((IHeatSource)tile, null));
        }
    }

    public void removeTile(IHeatTile tile1) {
        this.removeTileEntity(tile1);
    }

    public void removeTileEntity(IHeatTile tile) {
        if (!this.chunkCoordinatesIHeatTileMap.containsKey(tile.getBlockPos())) {
            return;
        }
        BlockPos coord = tile.getBlockPos();
        this.chunkCoordinatesIHeatTileMap.remove(coord, tile);
        this.update(coord);
        if (tile instanceof IHeatAcceptor) {
            this.removeAll(this.getSources((IHeatAcceptor)tile));
            this.onTileEntityRemoved((IHeatAcceptor)tile);
        }
        if (tile instanceof IHeatSource) {
            this.remove((IHeatSource)tile);
        }
    }

    public void emitHeatFrom(IHeatSource HeatSource, double amount, SystemTick<IHeatSource, HeatPath> tick) {
        List<HeatPath> HeatPaths = tick.getList();
        if (HeatPaths == null) {
            HeatPaths = this.discover(HeatSource);
            tick.setList(HeatPaths);
        }
        boolean allow = false;
        if (amount > 0.0) {
            for (HeatPath HeatPath2 : HeatPaths) {
                double adding;
                IHeatSink HeatSink = HeatPath2.target;
                double demandedHeat = HeatSink.getDemandedHeat();
                if (demandedHeat <= 0.0 || (adding = Math.min(amount, demandedHeat)) <= 0.0) continue;
                allow = allow || HeatSink.needTemperature();
                HeatSink.receivedHeat(adding);
                if (!(adding > HeatPath2.min)) continue;
                for (IHeatConductor HeatConductor : HeatPath2.conductors) {
                    if (!(HeatConductor.getConductorBreakdownHeat() < adding)) break;
                    HeatConductor.removeConductor();
                }
            }
        }
        if (!allow) {
            HeatSource.setAllowed(false);
        }
    }

    public TileEntity getTileFromIHeat(IHeatTile tile) {
        if (tile == null) {
            return null;
        }
        return tile.getTile();
    }

    public List<HeatPath> discover(IHeatSource emitter) {
        HashMap<IHeatConductor, EnumFacing> reachedTileEntities = new HashMap<IHeatConductor, EnumFacing>();
        ArrayList<IHeatSource> tileEntitiesToCheck = new ArrayList<IHeatSource>();
        ArrayList<HeatPath> HeatPaths = new ArrayList<HeatPath>();
        tileEntitiesToCheck.add(emitter);
        while (!tileEntitiesToCheck.isEmpty()) {
            IHeatTile currentTileEntity = (IHeatTile)tileEntitiesToCheck.remove(0);
            List<InfoTile<IHeatTile>> validReceivers = this.getValidReceivers(currentTileEntity, false);
            for (InfoTile<IHeatTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter) continue;
                if (validReceiver.tileEntity instanceof IHeatSink) {
                    HeatPaths.add(new HeatPath((IHeatSink)validReceiver.tileEntity, validReceiver.direction));
                    continue;
                }
                if (reachedTileEntities.containsKey((IHeatConductor)validReceiver.tileEntity)) continue;
                reachedTileEntities.put((IHeatConductor)validReceiver.tileEntity, validReceiver.direction);
                tileEntitiesToCheck.add((IHeatSource)validReceiver.tileEntity);
            }
        }
        block2: for (HeatPath HeatPath2 : HeatPaths) {
            IHeatTile tileEntity = HeatPath2.target;
            EnumFacing HeatBlockLink = HeatPath2.targetDirection;
            BlockPos te = tileEntity.getBlockPos();
            if (emitter == null) continue;
            while (tileEntity != emitter) {
                if (HeatBlockLink != null && te != null) {
                    tileEntity = this.getTileEntity(te.func_177972_a(HeatBlockLink));
                    te = te.func_177972_a(HeatBlockLink);
                }
                if (!(tileEntity instanceof IHeatConductor)) continue block2;
                IHeatConductor HeatConductor = (IHeatConductor)tileEntity;
                HeatPath2.conductors.add(HeatConductor);
                if (HeatConductor.getConductorBreakdownHeat() - 1.0 < HeatPath2.getMin()) {
                    HeatPath2.setMin(HeatConductor.getConductorBreakdownHeat() - 1.0);
                }
                if ((HeatBlockLink = (EnumFacing)reachedTileEntities.get(tileEntity)) == null) continue;
            }
        }
        return HeatPaths;
    }

    public IHeatTile getNeighbor(IHeatTile tile, EnumFacing dir) {
        if (tile == null) {
            return null;
        }
        return this.getTileEntity(tile.getBlockPos().func_177972_a(dir));
    }

    private List<InfoTile<IHeatTile>> getValidReceivers(IHeatTile emitter, boolean reverse) {
        LinkedList<InfoTile<IHeatTile>> validReceivers = new LinkedList<InfoTile<IHeatTile>>();
        for (EnumFacing direction : EnumFacing.values()) {
            IHeatAcceptor receiver2;
            IHeatEmitter sender2;
            IHeatTile target2 = this.getNeighbor(emitter, direction);
            if (target2 == null) continue;
            EnumFacing inverseDirection2 = direction.func_176734_d();
            if (reverse) {
                if (!(emitter instanceof IHeatAcceptor) || !(target2 instanceof IHeatEmitter) || !(sender2 = (IHeatEmitter)target2).emitsHeatTo(receiver2 = (IHeatAcceptor)emitter, inverseDirection2) || !receiver2.acceptsHeatFrom(sender2, direction)) continue;
                validReceivers.add(new InfoTile<IHeatTile>(target2, inverseDirection2));
                continue;
            }
            if (!(emitter instanceof IHeatEmitter) || !(target2 instanceof IHeatAcceptor) || !(sender2 = (IHeatEmitter)emitter).emitsHeatTo(receiver2 = (IHeatAcceptor)target2, direction) || !receiver2.acceptsHeatFrom(sender2, inverseDirection2)) continue;
            validReceivers.add(new InfoTile<IHeatTile>(target2, inverseDirection2));
        }
        return validReceivers;
    }

    public void onTickEnd() {
        if (this.sourceToUpdateList.size() > 0) {
            for (IHeatSource iHeatSource : this.sourceToUpdateList) {
                this.remove1(iHeatSource);
            }
            this.sourceToUpdateList.clear();
        }
        try {
            for (SystemTick systemTick : this.senderPath) {
                IHeatSource entry = (IHeatSource)systemTick.getSource();
                if (entry == null) continue;
                double offered = entry.getOfferedHeat();
                if (entry.isAllowed()) {
                    this.emitHeatFrom(entry, offered, systemTick);
                    continue;
                }
                this.emitHeatFromNotAllowed(entry, offered, systemTick);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void emitHeatFromNotAllowed(IHeatSource HeatSource, double amount, SystemTick<IHeatSource, HeatPath> tick) {
        List<HeatPath> HeatPaths = tick.getList();
        if (HeatPaths == null) {
            HeatPaths = this.discover(HeatSource);
            tick.setList(HeatPaths);
        }
        for (HeatPath HeatPath2 : HeatPaths) {
            double adding;
            IHeatSink HeatSink = HeatPath2.target;
            double demandedHeat = HeatSink.getDemandedHeat();
            if (HeatSink.needTemperature()) {
                HeatSource.setAllowed(true);
            }
            if (demandedHeat <= 0.0 || (adding = Math.min(amount, demandedHeat)) <= 0.0) continue;
            HeatSink.receivedHeat(adding);
            if (!(adding > HeatPath2.min)) continue;
            for (IHeatConductor HeatConductor : HeatPath2.conductors) {
                if (!(HeatConductor.getConductorBreakdownHeat() < adding)) break;
                HeatConductor.removeConductor();
            }
        }
    }

    public IHeatTile getTileEntity(BlockPos pos) {
        return this.chunkCoordinatesIHeatTileMap.get(pos);
    }

    public void update(BlockPos pos) {
        for (EnumFacing dir : EnumFacing.values()) {
            BlockPos pos1 = pos.func_177972_a(dir);
            IHeatTile tile = this.chunkCoordinatesIHeatTileMap.get(pos1);
            if (tile == null || !(tile instanceof IHeatConductor)) continue;
            ((IHeatConductor)tile).update_render();
        }
    }

    public void put(IHeatSource par1, List<HeatPath> par2) {
        this.senderPath.add(new SystemTick<IHeatSource, HeatPath>(par1, par2));
    }

    public boolean containsKey(SystemTick<IHeatSource, HeatPath> par1) {
        return this.senderPath.contains(par1);
    }

    public boolean containsKey(IHeatSource par1) {
        return this.senderPath.contains(new SystemTick(par1, null));
    }

    public void remove1(IHeatSource par1) {
        for (SystemTick<IHeatSource, HeatPath> ticks : this.senderPath) {
            if (ticks.getSource() != par1) continue;
            ticks.setList(null);
            break;
        }
    }

    public void remove(IHeatSource par1) {
        this.senderPath.remove(new SystemTick(par1, null));
    }

    public void remove(SystemTick<IHeatSource, HeatPath> par1) {
        this.senderPath.remove(par1);
    }

    public void removeAll(List<SystemTick<IHeatSource, HeatPath>> par1) {
        if (par1 == null) {
            return;
        }
        for (SystemTick<IHeatSource, HeatPath> iHeatSource : par1) {
            iHeatSource.setList(null);
        }
    }

    public List<SystemTick<IHeatSource, HeatPath>> getSources(IHeatAcceptor par1) {
        ArrayList<SystemTick<IHeatSource, HeatPath>> source = new ArrayList<SystemTick<IHeatSource, HeatPath>>();
        block0: for (SystemTick<IHeatSource, HeatPath> entry : this.senderPath) {
            if (entry.getList() == null) continue;
            for (HeatPath path : entry.getList()) {
                if (!(par1 instanceof IHeatConductor && path.conductors.contains(par1) || par1 instanceof IHeatSink && path.target == par1)) continue;
                source.add(entry);
                continue block0;
            }
        }
        return source;
    }

    public SystemTick<IHeatSource, HeatPath> get(IHeatSource tileEntity) {
        for (SystemTick<IHeatSource, HeatPath> entry : this.senderPath) {
            if (entry.getSource() != tileEntity) continue;
            return entry;
        }
        return null;
    }

    public void onUnload() {
        this.senderPath.clear();
        this.chunkCoordinatesIHeatTileMap.clear();
    }

    public void onTileEntityAdded(IHeatAcceptor tile) {
        ArrayList<IHeatTile> tileEntitiesToCheck = new ArrayList<IHeatTile>();
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        blockPosList.add(tile.getBlockPos());
        tileEntitiesToCheck.add(tile);
        while (!tileEntitiesToCheck.isEmpty()) {
            IHeatTile currentTileEntity = (IHeatTile)tileEntitiesToCheck.remove(0);
            for (EnumFacing direction : EnumFacing.values()) {
                IHeatTile target2 = this.getTileEntity(currentTileEntity.getBlockPos().func_177972_a(direction));
                if (target2 == null || blockPosList.contains(target2.getBlockPos())) continue;
                blockPosList.add(target2.getBlockPos());
                if (target2 instanceof IHeatSource) {
                    if (this.sourceToUpdateList.contains((IHeatSource)target2)) continue;
                    this.sourceToUpdateList.add((IHeatSource)target2);
                    continue;
                }
                if (!(target2 instanceof IHeatConductor)) continue;
                tileEntitiesToCheck.add(target2);
            }
        }
    }

    public void onTileEntityRemoved(IHeatAcceptor par1) {
        this.onTileEntityAdded(par1);
    }

    public static class HeatPath {
        final List<IHeatConductor> conductors;
        final IHeatSink target;
        final EnumFacing targetDirection;
        double min = Double.MAX_VALUE;

        HeatPath(IHeatSink sink, EnumFacing facing) {
            this.target = sink;
            this.conductors = new ArrayList<IHeatConductor>();
            this.targetDirection = facing;
        }

        public List<IHeatConductor> getConductors() {
            return this.conductors;
        }

        public double getMin() {
            return this.min;
        }

        public void setMin(double min) {
            this.min = min;
        }
    }
}

