/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.heat;

import com.denfop.api.heat.event.HeatTileLoadEvent;
import com.denfop.api.heat.event.HeatTileUnloadEvent;
import com.denfop.heat.HeatNetGlobal;
import com.denfop.heat.HeatNetLocal;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandler {
    public EventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergyTileLoad(HeatTileLoadEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        HeatNetLocal local = HeatNetGlobal.getForWorld(event.getWorld());
        if (local != null) {
            local.addTile(event.tile);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergyTileUnload(HeatTileUnloadEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        HeatNetLocal local = HeatNetGlobal.getForWorld(event.getWorld());
        if (local != null) {
            local.removeTile(event.tile);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            HeatNetGlobal.onTickEnd(event.world);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        HeatNetGlobal.onWorldUnload(event.getWorld());
    }
}

