/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.TankGauge;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.api.upgrades.UpgradeRegistry;
import com.denfop.componets.ComponentSoundButton;
import com.denfop.container.ContainerMultiMatter;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileMultiMatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiMultiMatter
extends GuiIU<ContainerMultiMatter> {
    public final ContainerMultiMatter container;
    public final String progressLabel;
    public final String amplifierLabel;

    public GuiMultiMatter(ContainerMultiMatter container1) {
        super(container1, ((TileMultiMatter)container1.base).getStyle());
        this.container = container1;
        this.progressLabel = Localization.translate("Matter.gui.info.progress");
        this.amplifierLabel = Localization.translate("Matter.gui.info.amplifier");
        this.addElement(TankGauge.createNormal(this, 96, 22, (IFluidTank)((TileMultiMatter)this.container.base).fluidTank));
        this.field_146999_f = 200;
        this.addComponent(new GuiComponent(this, 3, 14, EnumTypeComponent.SOUND_BUTTON, new Component<ComponentSoundButton>(new ComponentSoundButton((TileEntityBlock)((Object)this.container.base), 10, (IAudioFixer)((Object)this.container.base)))));
    }

    private static List<ItemStack> getCompatibleUpgrades(IUpgradableBlock block) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Set<UpgradableProperty> properties = block.getUpgradableProperties();
        for (ItemStack stack : UpgradeRegistry.getUpgrades()) {
            IUpgradeItem item = (IUpgradeItem)stack.func_77973_b();
            if (!item.isSuitableFor(stack, properties)) continue;
            ret.add(stack);
        }
        return ret;
    }

    @Override
    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        int xMin = (this.field_146294_l - this.field_146999_f) / 2;
        int yMin = (this.field_146295_m - this.field_147000_g) / 2;
        int x = i - xMin;
        int y = j - yMin;
        if (x >= 182 && x <= 190 && y >= 6 && y <= 14) {
            new PacketUpdateServerTile((TileEntity)this.container.base, 0.0);
        }
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 0 && mouseX <= 12 && mouseY >= 0 && mouseY <= 12) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.generic.text.upgrade"));
            for (ItemStack stack : GuiMultiMatter.getCompatibleUpgrades((IUpgradableBlock)((Object)this.container.base))) {
                text.add(stack.func_82833_r());
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(int par1, int par2) {
        FluidStack fluidstack;
        this.handleUpgradeTooltip(par1, par2);
        this.field_146289_q.func_78276_b(this.progressLabel, 8, 27, 0x404040);
        this.field_146289_q.func_78276_b(((TileMultiMatter)this.container.base).getProgressAsString(), 18, 36, 0x404040);
        if (((TileMultiMatter)this.container.base).scrap > 0) {
            this.field_146289_q.func_78276_b(this.amplifierLabel, 8, 46, 0x404040);
            this.field_146289_q.func_78276_b("" + ((TileMultiMatter)this.container.base).scrap, 8, 58, 0x404040);
        }
        if ((fluidstack = ((TileMultiMatter)this.container.base).fluidTank.getFluid()) != null) {
            String tooltip = Localization.translate("iu.fluiduu_matter") + ": " + fluidstack.amount + Localization.translate("iu.generic.text.mb");
            ((Area)new Area(this, 99, 25, 13, 48).withTooltip(tooltip)).drawForeground(par1, par2);
        }
        ((Area)new AdvArea(this, 182, 6, 190, 14).withTooltip(((TileMultiMatter)this.container.base).work ? Localization.translate("turn_off") : Localization.translate("turn_on"))).drawForeground(par1, par2);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (((TileMultiMatter)this.container.base).work) {
            this.func_73729_b(181, 5, 203, 5, 11, 11);
        }
        this.drawForeground(par1, par2);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        String name = Localization.translate(((TileMultiMatter)this.container.base).func_70005_c_());
        this.drawXCenteredString(this.field_146999_f / 2 - 15, 6, name, 0x404040, false);
    }

    @Override
    protected void drawBackgroundAndTitle(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        String name = Localization.translate(((TileMultiMatter)this.container.base).func_70005_c_());
        this.drawXCenteredString(this.field_146999_f / 2 - 15, 6, name, 0x404040, false);
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("industrialupgrade", "textures/gui/GUIMatter.png");
    }
}

