/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.componets.ComponentRenderInventory;
import com.denfop.componets.EnumTypeComponentSlot;
import com.denfop.componets.EnumTypeStyle;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlot;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;

public abstract class GuiIU<T extends ContainerBase<? extends IInventory>>
extends GuiCore<T> {
    private final EnumTypeStyle style;
    public boolean isBlack = false;
    protected GuiComponent inventory;
    protected GuiComponent slots;
    protected List<InvSlot> invSlotList = new ArrayList<InvSlot>();
    protected List<GuiComponent> componentList = new ArrayList<GuiComponent>();

    public GuiIU(T container) {
        super(container);
        this.style = EnumTypeStyle.DEFAULT;
        this.inventory = new GuiComponent(this, 7, 83, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.ALL)));
        this.slots = new GuiComponent(this, 0, 0, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.SLOTS_UPGRADE)));
        this.componentList.add(this.inventory);
        this.componentList.add(this.slots);
    }

    public GuiIU(T container, EnumTypeStyle style) {
        super(container);
        this.style = style;
        this.inventory = new GuiComponent(this, 7, 83, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.ALL)));
        this.slots = new GuiComponent(this, 0, 0, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.SLOTS_UPGRADE)));
        this.componentList.add(this.inventory);
        this.componentList.add(this.slots);
    }

    public GuiIU(T container, EnumTypeComponent style) {
        super(container);
        this.style = this.getStyle(style);
        this.inventory = new GuiComponent(this, 7, 83, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.ALL)));
        this.slots = new GuiComponent(this, 0, 0, this.getComponent(), new Component<ComponentRenderInventory>(new ComponentRenderInventory(EnumTypeComponentSlot.SLOTS_UPGRADE)));
        this.componentList.add(this.inventory);
        this.componentList.add(this.slots);
    }

    public EnumTypeComponent getComponent() {
        switch (this.style) {
            case ADVANCED: {
                return EnumTypeComponent.ADVANCED;
            }
            case IMPROVED: {
                return EnumTypeComponent.IMPROVED;
            }
            case PERFECT: {
                return EnumTypeComponent.PERFECT;
            }
        }
        return EnumTypeComponent.DEFAULT;
    }

    public EnumTypeStyle getStyle(EnumTypeComponent style) {
        switch (style) {
            case ADVANCED: {
                return EnumTypeStyle.ADVANCED;
            }
            case IMPROVED: {
                return EnumTypeStyle.IMPROVED;
            }
            case PERFECT: {
                return EnumTypeStyle.PERFECT;
            }
        }
        return EnumTypeStyle.DEFAULT;
    }

    public EnumTypeStyle getStyle() {
        return this.style;
    }

    public void addComponent(GuiComponent component) {
        this.componentList.add(component);
    }

    public void removeComponent(int index) {
        this.componentList.remove(index);
    }

    public void removeComponent(GuiComponent component) {
        this.componentList.remove(component);
    }

    public void drawForeground(int mouseX, int mouseY) {
        this.componentList.forEach(guiComponent -> guiComponent.drawForeground(mouseX, mouseY));
    }

    public void drawBackground() {
        int xoffset = (this.field_146294_l - this.field_146999_f) / 2;
        int yoffset = (this.field_146295_m - this.field_147000_g) / 2;
        this.componentList.forEach(guiComponent -> guiComponent.drawBackground(xoffset, yoffset));
    }

    @Override
    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        int xMin = (this.field_146294_l - this.field_146999_f) / 2;
        int yMin = (this.field_146295_m - this.field_147000_g) / 2;
        int x = i - xMin;
        int y = j - yMin;
        this.componentList.forEach(guiComponent -> guiComponent.buttonClicked(x, y));
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.drawBackground();
    }

    @Override
    protected void drawBackgroundAndTitle(float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        String name = Localization.translate(this.container.base.func_70005_c_());
        if (!this.isBlack) {
            this.drawXCenteredString(this.field_146999_f / 2, 6, name, 0x404040, false);
        } else {
            this.drawXCenteredString(this.field_146999_f / 2, 6, name, ModUtils.convertRGBcolorToInt(216, 216, 216), false);
        }
    }

    @Override
    protected void drawForegroundLayer(int par1, int par2) {
        super.drawForegroundLayer(par1, par2);
        this.drawForeground(par1, par2);
    }
}

