/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.water.upgrade.RotorUpgradeSystem;
import com.denfop.api.windsystem.EnumTypeWind;
import com.denfop.api.windsystem.IWindMechanism;
import com.denfop.api.windsystem.WindSystem;
import com.denfop.componets.AdvEnergy;
import com.denfop.container.ContainerBaseWaterGenerator;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.tiles.mechanism.water.TileBaseWaterGenerator;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class GuiBaseWaterGenerator
extends GuiIU<ContainerBaseWaterGenerator> {
    private final ResourceLocation background;

    public GuiBaseWaterGenerator(ContainerBaseWaterGenerator guiContainer) {
        super(guiContainer, ((TileBaseWaterGenerator)guiContainer.base).getStyle());
        this.field_147000_g = 236;
        this.field_146999_f = 211;
        this.background = new ResourceLocation("industrialupgrade", "textures/gui/guiwatergenerator.png");
        this.addComponent(new GuiComponent(this, 167, 98, EnumTypeComponent.ENERGY_WEIGHT, new Component<AdvEnergy>(((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).energy)));
        this.inventory.setY(153);
        this.inventory.setX(7);
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.water_generator.info_main"));
            List<String> compatibleUpgrades = ListInformationUtils.water_generator;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void func_73864_a(int i, int j, int k) throws IOException {
        super.func_73864_a(i, j, k);
        int xMin = (this.field_146294_l - this.field_146999_f) / 2;
        int yMin = (this.field_146295_m - this.field_147000_g) / 2;
        int x = i - xMin;
        int y = j - yMin;
        if (x >= 12 && x <= 25 && y >= 45 && y <= 68) {
            new PacketUpdateServerTile((TileEntity)((ContainerBaseWaterGenerator)this.container).base, 0.0);
        }
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture();
        int xoffset = (this.field_146294_l - this.field_146999_f) / 2;
        int yoffset = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("industrialupgrade", "textures/gui/infobutton.png"));
        this.func_73729_b(xoffset + 3, yoffset + 3, 0, 0, 10, 10);
        this.field_146297_k.func_110434_K().func_110577_a(this.getTexture());
        if (!((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).slot.isEmpty()) {
            List<ItemStack> list = RotorUpgradeSystem.instance.getListStack(((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).slot.get());
            int i = 0;
            for (ItemStack stack : list) {
                if (stack.func_190926_b()) {
                    ++i;
                    continue;
                }
                RenderHelper.func_74520_c();
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glEnable((int)32826);
                GlStateManager.func_179140_f();
                GlStateManager.func_179126_j();
                this.field_73735_i = 100.0f;
                this.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                this.field_146296_j.func_180450_b(stack, xoffset + 181, yoffset + 19 + i * 18);
                GL11.glEnable((int)2896);
                GlStateManager.func_179145_e();
                RenderHelper.func_74519_b();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
                ++i;
            }
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        super.drawForegroundLayer(mouseX, mouseY);
        this.handleUpgradeTooltip(mouseX, mouseY);
        if (((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).func_145831_w().field_73011_w.getDimension() == 0) {
            if (((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).getMinWind() != 0) {
                this.field_146289_q.func_78276_b(Localization.translate("iu.water_meter.info") + String.format("%.1f", Math.min(24.7 + (double)((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).mind_speed, WindSystem.windSystem.getSpeedFromWaterPower(((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).getBlockPos(), (IWindMechanism)((Object)((ContainerBaseWaterGenerator)this.container).base), ((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).generation) / ((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).getCoefficient())) + " m/s", 53, 48, ModUtils.convertRGBcolorToInt(13, 229, 34));
            } else {
                this.field_146289_q.func_78276_b(Localization.translate("iu.water_meter.info") + String.format("%.1f", ((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).wind_speed + (double)((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).mind_speed) + " m/s", 53, 48, ModUtils.convertRGBcolorToInt(13, 229, 34));
            }
        }
        String tooltip2 = Localization.translate("iu.wind_change_side");
        ((Area)new AdvArea(this, 12, 45, 25, 58).withTooltip(tooltip2)).drawForeground(mouseX, mouseY);
        if (!((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).slot.isEmpty()) {
            List<ItemStack> list = RotorUpgradeSystem.instance.getListStack(((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).slot.get());
            int i = 0;
            for (ItemStack stack : list) {
                if (stack.func_190926_b()) {
                    ++i;
                    continue;
                }
                ((Area)new AdvArea(this, 180, 18 + i * 18, 197, 35 + i * 18).withTooltip(stack.func_82833_r())).drawForeground(mouseX, mouseY);
                ++i;
            }
        }
        if (((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).getRotor() != null) {
            this.field_146289_q.func_78276_b(Localization.translate("iu.water_side") + Localization.translate("iu.wind." + ((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).wind_side.name().toLowerCase()), 33, 70, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.field_146289_q.func_78276_b(Localization.translate("iu.wind_mec_side") + Localization.translate("iu.wind." + ((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).getRotorSide().name().toLowerCase()), 33, 80, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.field_146289_q.func_78276_b(Localization.translate("iu.wind_gen") + ModUtils.getString(((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).generation) + " EF/t", 33, 90, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.field_146289_q.func_78276_b(Localization.translate("iu.water_coef") + String.format("%.2f", ((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).getCoefficient()), 33, 100, ModUtils.convertRGBcolorToInt(13, 229, 34));
            this.field_146289_q.func_78276_b(Localization.translate("iu.wind_tier") + String.format("%d", ((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).getRotor().getLevel()), 33, 110, ModUtils.convertRGBcolorToInt(13, 229, 34));
            int meta = Math.min(((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).enumTypeWind.ordinal() + ((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).getMinWind(), 9);
            WindSystem.windSystem.getEnumTypeWind();
            EnumTypeWind enumTypeWinds = EnumTypeWind.values()[meta];
            this.field_146289_q.func_78276_b(Localization.translate("iu.water_level_info") + String.format("%d", enumTypeWinds.ordinal() + 1), 33, 120, ModUtils.convertRGBcolorToInt(13, 229, 34));
            double hours = 0.0;
            double minutes = 0.0;
            double seconds = 0.0;
            List<Double> time = ModUtils.Time((double)((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).timers / 20.0);
            if (time.size() > 0) {
                hours = time.get(0);
                minutes = time.get(1);
                seconds = time.get(2);
            }
            String time1 = hours > 0.0 ? ModUtils.getString(hours) + Localization.translate("iu.hour") + "" : "";
            String time2 = minutes > 0.0 ? ModUtils.getString(minutes) + Localization.translate("iu.minutes") + "" : "";
            String time3 = seconds > 0.0 ? ModUtils.getString(seconds) + Localization.translate("iu.seconds") + "" : "";
            this.field_146289_q.func_78276_b(Localization.translate("iu.water_change_time") + time1 + time2 + time3, 33, 130, ModUtils.convertRGBcolorToInt(13, 229, 34));
            String tooltip3 = Localization.translate("iu.water_meter.info") + String.format("%.1f", enumTypeWinds.getMin() + (double)((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).getMinWindSpeed()) + "-" + String.format("%.1f", enumTypeWinds.getMax() + (double)((TileBaseWaterGenerator)((ContainerBaseWaterGenerator)this.container).base).getMinWindSpeed()) + " m/s";
            ((Area)new AdvArea(this, 33, 120, 123, 130).withTooltip(tooltip3)).drawForeground(mouseX, mouseY);
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return this.background;
    }
}

