/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.cool;

import com.denfop.api.cool.ICoolAcceptor;
import com.denfop.api.cool.ICoolConductor;
import com.denfop.api.cool.ICoolEmitter;
import com.denfop.api.cool.ICoolSink;
import com.denfop.api.cool.ICoolSource;
import com.denfop.api.cool.ICoolTile;
import com.denfop.api.energy.SystemTick;
import com.denfop.api.sytem.InfoTile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class CoolNetLocal {
    final List<SystemTick<ICoolSource, CoolPath>> senderPath = new ArrayList<SystemTick<ICoolSource, CoolPath>>();
    private final Map<BlockPos, ICoolTile> chunkCoordinatesICoolTileMap;
    final List<ICoolSource> sourceToUpdateList = new ArrayList<ICoolSource>();

    CoolNetLocal() {
        this.chunkCoordinatesICoolTileMap = new HashMap<BlockPos, ICoolTile>();
    }

    public void addTile(ICoolTile tile1) {
        this.addTileEntity(this.getTileFromICool(tile1).func_174877_v(), tile1);
    }

    public void addTile(ICoolTile tile, TileEntity tileentity) {
        BlockPos coords = tileentity.func_174877_v();
        if (this.chunkCoordinatesICoolTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesICoolTileMap.put(coords, tile);
        this.update(coords);
        if (tile instanceof ICoolAcceptor) {
            this.onTileEntityAdded((ICoolAcceptor)tile);
        }
        if (tile instanceof ICoolSource) {
            this.senderPath.add(new SystemTick((ICoolSource)tile, null));
        }
    }

    public BlockPos getPos(ICoolTile tile) {
        if (tile == null) {
            return null;
        }
        return tile.getBlockPos();
    }

    public void addTileEntity(BlockPos coords, ICoolTile tile) {
        if (this.chunkCoordinatesICoolTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesICoolTileMap.put(coords, tile);
        this.update(coords);
        if (tile instanceof ICoolAcceptor) {
            this.onTileEntityAdded((ICoolAcceptor)tile);
        }
        if (tile instanceof ICoolSource) {
            this.senderPath.add(new SystemTick((ICoolSource)tile, null));
        }
    }

    public void removeTile(ICoolTile tile1) {
        this.removeTileEntity(tile1);
    }

    public List<CoolPath> getPaths(ICoolAcceptor par1) {
        ArrayList<CoolPath> paths = new ArrayList<CoolPath>();
        List<SystemTick<ICoolSource, CoolPath>> sources_list = this.getSources(par1);
        if (sources_list == null || sources_list.isEmpty()) {
            return paths;
        }
        for (SystemTick<ICoolSource, CoolPath> source : sources_list) {
            if (!this.containsKey(source)) continue;
            paths.addAll(source.getList());
        }
        return paths;
    }

    public void removeTileEntity(ICoolTile tile) {
        if (!this.chunkCoordinatesICoolTileMap.containsKey(tile.getBlockPos())) {
            return;
        }
        BlockPos coord = tile.getBlockPos();
        this.chunkCoordinatesICoolTileMap.remove(coord, tile);
        this.update(coord);
        if (tile instanceof ICoolAcceptor) {
            this.removeAll(this.getSources((ICoolAcceptor)tile));
            this.onTileEntityRemoved((ICoolAcceptor)tile);
        }
        if (tile instanceof ICoolSource) {
            this.remove((ICoolSource)tile);
        }
    }

    public double emitCoolFrom(ICoolSource CoolSource, double amount, SystemTick<ICoolSource, CoolPath> tick) {
        List<CoolPath> CoolPaths = tick.getList();
        if (CoolPaths == null) {
            CoolPaths = this.discover(CoolSource);
            tick.setList(CoolPaths);
        }
        boolean transmit = false;
        if (amount > 0.0) {
            for (CoolPath CoolPath2 : CoolPaths) {
                double adding;
                ICoolSink CoolSink = CoolPath2.target;
                double demandedCool = CoolSink.getDemandedCool();
                if (demandedCool <= 0.0 || (adding = Math.min(amount, demandedCool)) <= 0.0) continue;
                CoolSink.receivedCold(adding);
                transmit = true;
                if (!(adding > CoolPath2.min)) continue;
                for (ICoolConductor CoolConductor : CoolPath2.conductors) {
                    if (!(CoolConductor.getConductorBreakdownCold() < adding)) break;
                    CoolConductor.removeConductor();
                }
            }
        }
        if (!transmit && CoolSource.isAllowed()) {
            CoolSource.setAllowed(false);
        }
        return amount;
    }

    public double emitCoolFromNotAllowed(ICoolSource CoolSource, double amount, SystemTick<ICoolSource, CoolPath> tick) {
        List<CoolPath> CoolPaths = tick.getList();
        if (CoolPaths == null) {
            CoolPaths = this.discover(CoolSource);
            tick.setList(CoolPaths);
        }
        for (CoolPath CoolPath2 : CoolPaths) {
            double adding;
            ICoolSink CoolSink = CoolPath2.target;
            double demandedCool = CoolSink.getDemandedCool();
            if (demandedCool <= 0.0) continue;
            if (CoolSink.needCooling()) {
                CoolSource.setAllowed(true);
            }
            if ((adding = Math.min(amount, demandedCool)) <= 0.0) continue;
            CoolSink.receivedCold(adding);
            if (!(adding > CoolPath2.min)) continue;
            for (ICoolConductor CoolConductor : CoolPath2.conductors) {
                if (!(CoolConductor.getConductorBreakdownCold() < adding)) break;
                CoolConductor.removeConductor();
            }
        }
        return amount;
    }

    public TileEntity getTileFromICool(ICoolTile tile) {
        if (tile instanceof TileEntity) {
            return (TileEntity)tile;
        }
        return tile.getTile();
    }

    public List<CoolPath> discover(ICoolSource emitter) {
        HashMap<ICoolConductor, EnumFacing> reachedTileEntities = new HashMap<ICoolConductor, EnumFacing>();
        ArrayList<ICoolSource> tileEntitiesToCheck = new ArrayList<ICoolSource>();
        ArrayList<CoolPath> CoolPaths = new ArrayList<CoolPath>();
        tileEntitiesToCheck.add(emitter);
        while (!tileEntitiesToCheck.isEmpty()) {
            ICoolTile currentTileEntity = (ICoolTile)tileEntitiesToCheck.remove(0);
            List<InfoTile<ICoolTile>> validReceivers = this.getValidReceivers(currentTileEntity, false);
            for (InfoTile<ICoolTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter) continue;
                if (validReceiver.tileEntity instanceof ICoolSink) {
                    CoolPaths.add(new CoolPath((ICoolSink)validReceiver.tileEntity, validReceiver.direction));
                    continue;
                }
                if (reachedTileEntities.containsKey((ICoolConductor)validReceiver.tileEntity)) continue;
                reachedTileEntities.put((ICoolConductor)validReceiver.tileEntity, validReceiver.direction);
                tileEntitiesToCheck.add((ICoolSource)validReceiver.tileEntity);
            }
        }
        block2: for (CoolPath CoolPath2 : CoolPaths) {
            ICoolTile tileEntity = CoolPath2.target;
            EnumFacing CoolBlockLink = CoolPath2.targetDirection;
            BlockPos te = tileEntity.getBlockPos();
            if (emitter == null) continue;
            while (tileEntity != emitter) {
                if (CoolBlockLink != null && te != null) {
                    tileEntity = this.getTileEntity(te.func_177972_a(CoolBlockLink));
                    te = te.func_177972_a(CoolBlockLink);
                }
                if (!(tileEntity instanceof ICoolConductor)) continue block2;
                ICoolConductor CoolConductor = (ICoolConductor)tileEntity;
                CoolPath2.conductors.add(CoolConductor);
                if (CoolConductor.getConductorBreakdownCold() - 1.0 < CoolPath2.getMin()) {
                    CoolPath2.setMin(CoolConductor.getConductorBreakdownCold() - 1.0);
                }
                if ((CoolBlockLink = (EnumFacing)reachedTileEntities.get(tileEntity)) == null) continue;
            }
        }
        return CoolPaths;
    }

    public ICoolTile getNeighbor(ICoolTile tile, EnumFacing dir) {
        if (tile == null) {
            return null;
        }
        return this.getTileEntity(tile.getBlockPos().func_177972_a(dir));
    }

    private List<InfoTile<ICoolTile>> getValidReceivers(ICoolTile emitter, boolean reverse) {
        LinkedList<InfoTile<ICoolTile>> validReceivers = new LinkedList<InfoTile<ICoolTile>>();
        for (EnumFacing direction : EnumFacing.values()) {
            ICoolAcceptor receiver2;
            ICoolEmitter sender2;
            ICoolTile target2 = this.getNeighbor(emitter, direction);
            if (target2 == null) continue;
            EnumFacing inverseDirection2 = direction.func_176734_d();
            if (reverse) {
                if (!(emitter instanceof ICoolAcceptor) || !(target2 instanceof ICoolEmitter) || !(sender2 = (ICoolEmitter)target2).emitsCoolTo(receiver2 = (ICoolAcceptor)emitter, inverseDirection2) || !receiver2.acceptsCoolFrom(sender2, direction)) continue;
                validReceivers.add(new InfoTile<ICoolTile>(target2, inverseDirection2));
                continue;
            }
            if (!(emitter instanceof ICoolEmitter) || !(target2 instanceof ICoolAcceptor) || !(sender2 = (ICoolEmitter)emitter).emitsCoolTo(receiver2 = (ICoolAcceptor)target2, direction) || !receiver2.acceptsCoolFrom(sender2, inverseDirection2)) continue;
            validReceivers.add(new InfoTile<ICoolTile>(target2, inverseDirection2));
        }
        return validReceivers;
    }

    public void onTickEnd() {
        if (this.sourceToUpdateList.size() > 0) {
            for (ICoolSource iCoolSource : this.sourceToUpdateList) {
                this.remove1(iCoolSource);
            }
            this.sourceToUpdateList.clear();
        }
        try {
            for (SystemTick systemTick : this.senderPath) {
                double removed;
                double i;
                ICoolSource entry = (ICoolSource)systemTick.getSource();
                if (entry == null) continue;
                double offered = entry.getOfferedCool();
                if (offered > 0.0 && entry.isAllowed()) {
                    for (i = 0.0; i < this.getPacketAmount() && !((removed = offered - this.emitCoolFrom(entry, offered, systemTick)) <= 0.0); i += 1.0) {
                    }
                    continue;
                }
                if (entry.isAllowed()) continue;
                for (i = 0.0; i < this.getPacketAmount() && !((removed = offered - this.emitCoolFromNotAllowed(entry, offered, systemTick)) <= 0.0); i += 1.0) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double getPacketAmount() {
        return 1.0;
    }

    public ICoolTile getTileEntity(BlockPos pos) {
        return this.chunkCoordinatesICoolTileMap.get(pos);
    }

    public void update(BlockPos pos) {
        for (EnumFacing dir : EnumFacing.values()) {
            BlockPos pos1 = pos.func_177972_a(dir);
            ICoolTile tile = this.chunkCoordinatesICoolTileMap.get(pos1);
            if (tile == null || !(tile instanceof ICoolConductor)) continue;
            ((ICoolConductor)tile).update_render();
        }
    }

    public void put(ICoolSource par1, List<CoolPath> par2) {
        this.senderPath.add(new SystemTick<ICoolSource, CoolPath>(par1, par2));
    }

    public boolean containsKey(SystemTick<ICoolSource, CoolPath> par1) {
        return this.senderPath.contains(par1);
    }

    public boolean containsKey(ICoolSource par1) {
        return this.senderPath.contains(new SystemTick(par1, null));
    }

    public void remove1(ICoolSource par1) {
        for (SystemTick<ICoolSource, CoolPath> ticks : this.senderPath) {
            if (ticks.getSource() != par1) continue;
            ticks.setList(null);
            break;
        }
    }

    public void remove(ICoolSource par1) {
        this.senderPath.remove(new SystemTick(par1, null));
    }

    public void remove(SystemTick<ICoolSource, CoolPath> par1) {
        this.senderPath.remove(par1);
    }

    public void removeAll(List<SystemTick<ICoolSource, CoolPath>> par1) {
        if (par1 == null) {
            return;
        }
        for (SystemTick<ICoolSource, CoolPath> iCoolSource : par1) {
            iCoolSource.setList(null);
        }
    }

    public List<SystemTick<ICoolSource, CoolPath>> getSources(ICoolAcceptor par1) {
        ArrayList<SystemTick<ICoolSource, CoolPath>> source = new ArrayList<SystemTick<ICoolSource, CoolPath>>();
        block0: for (SystemTick<ICoolSource, CoolPath> entry : this.senderPath) {
            if (entry.getList() == null) continue;
            for (CoolPath path : entry.getList()) {
                if (!(par1 instanceof ICoolConductor && path.conductors.contains(par1) || par1 instanceof ICoolSink && path.target == par1)) continue;
                source.add(entry);
                continue block0;
            }
        }
        return source;
    }

    public SystemTick<ICoolSource, CoolPath> get(ICoolSource tileEntity) {
        for (SystemTick<ICoolSource, CoolPath> entry : this.senderPath) {
            if (entry.getSource() != tileEntity) continue;
            return entry;
        }
        return null;
    }

    public void onUnload() {
        this.senderPath.clear();
        this.chunkCoordinatesICoolTileMap.clear();
    }

    public void onTileEntityAdded(ICoolAcceptor tile) {
        ArrayList<ICoolTile> tileEntitiesToCheck = new ArrayList<ICoolTile>();
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        blockPosList.add(tile.getBlockPos());
        tileEntitiesToCheck.add(tile);
        while (!tileEntitiesToCheck.isEmpty()) {
            ICoolTile currentTileEntity = (ICoolTile)tileEntitiesToCheck.remove(0);
            for (EnumFacing direction : EnumFacing.values()) {
                ICoolTile target2 = this.getTileEntity(currentTileEntity.getBlockPos().func_177972_a(direction));
                if (target2 == null || blockPosList.contains(target2.getBlockPos())) continue;
                blockPosList.add(target2.getBlockPos());
                if (target2 instanceof ICoolSource) {
                    if (this.sourceToUpdateList.contains((ICoolSource)target2)) continue;
                    this.sourceToUpdateList.add((ICoolSource)target2);
                    continue;
                }
                if (!(target2 instanceof ICoolConductor)) continue;
                tileEntitiesToCheck.add(target2);
            }
        }
    }

    public void onTileEntityRemoved(ICoolAcceptor par1) {
        this.onTileEntityAdded(par1);
    }

    public static class CoolPath {
        final List<ICoolConductor> conductors;
        final ICoolSink target;
        final EnumFacing targetDirection;
        double min = Double.MAX_VALUE;

        CoolPath(ICoolSink sink, EnumFacing facing) {
            this.target = sink;
            this.conductors = new ArrayList<ICoolConductor>();
            this.targetDirection = facing;
        }

        public List<ICoolConductor> getConductors() {
            return this.conductors;
        }

        public double getMin() {
            return this.min;
        }

        public void setMin(double min) {
            this.min = min;
        }
    }
}

