/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.IUItem;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.ComponentTimer;
import com.denfop.componets.TypePurifierJob;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;

public class ComponentPollution
extends AbstractComponent {
    boolean active = false;
    private ComponentTimer timer;
    private ItemStack stack;

    public ComponentPollution(TileEntityInventory parent) {
        super(parent);
    }

    public void setTimer(ComponentTimer timer) {
        this.timer = timer;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.stack = new ItemStack(IUItem.module7, 1, 9);
        if (this.active) {
            this.timer.setCanWork(false);
        }
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, EnumHand hand) {
        super.onBlockActivated(player, hand);
        ItemStack stack = player.func_184586_b(hand);
        if (!this.active && !stack.func_190926_b() && stack.func_77969_a(this.stack)) {
            this.active = true;
            stack.func_190918_g(1);
            this.timer.setCanWork(false);
            return true;
        }
        return false;
    }

    @Override
    public void onContainerUpdate(EntityPlayerMP player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16);
        buffer.writeBoolean(this.active);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer packet = super.updateComponent();
        packet.writeBoolean(this.active);
        return packet;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.active = is.readBoolean();
    }

    public int getAllTime() {
        AtomicInteger time = new AtomicInteger();
        this.timer.getDefaultTimers().forEach(timer -> time.addAndGet(timer.getTime()));
        return time.get();
    }

    public int getTime() {
        AtomicInteger time = new AtomicInteger();
        this.timer.getTimers().forEach(timer -> time.addAndGet(timer.getTime()));
        return time.get();
    }

    @Override
    public boolean canUsePurifier(EntityPlayer player) {
        return this.active;
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74757_a("active", this.active);
        return nbt;
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        super.readFromNbt(nbt);
        this.active = nbt.func_74767_n("active");
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.ItemStack;
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> ret = super.getDrops();
        if (this.active) {
            ret.add(this.stack.func_77946_l());
        }
        return ret;
    }

    @Override
    public ItemStack getItemStackUpgrade() {
        this.active = false;
        this.timer.setCanWork(true);
        return this.stack.func_77946_l();
    }
}

