/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks.state;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.jetbrains.annotations.NotNull;

public class TileEntityBlockStateContainer
extends BlockStateContainer {
    public TileEntityBlockStateContainer(Block blockIn, IProperty<?> ... properties) {
        super(blockIn, properties);
    }

    protected BlockStateContainer.StateImplementation createState(Block block, @NotNull ImmutableMap<IProperty<?>, Comparable<?>> properties, ImmutableMap<IUnlistedProperty<?>, Optional<?>> unlistedProperties) {
        return new PropertiesStateInstance(block, properties);
    }

    public class PropertiesStateInstance
    extends BlockStateContainer.StateImplementation {
        private final Map<IProperty<?>, Comparable<?>> Properties;
        private HashMap<ImmutableMap<IProperty<?>, Comparable<?>>, IBlockState> mapProperties;
        private Map<IUnlistedProperty<?>, Object> extraProperties;

        private PropertiesStateInstance(Block block, ImmutableMap<IProperty<?>, Comparable<?>> properties) {
            super(block, properties, null);
            this.mapProperties = new HashMap();
            this.extraProperties = new HashMap();
            this.Properties = new HashMap((Map<IProperty<?>, Comparable<?>>)this.func_177228_b());
        }

        public PropertiesStateInstance(PropertiesStateInstance propertiesStateInstance, Map<IUnlistedProperty<?>, Object> properties) {
            super(propertiesStateInstance.func_177230_c(), propertiesStateInstance.func_177228_b(), propertiesStateInstance.field_177238_c);
            this.mapProperties = new HashMap();
            this.extraProperties = new HashMap();
            this.Properties = new HashMap((Map<IProperty<?>, Comparable<?>>)this.func_177228_b());
            this.extraProperties = properties;
        }

        public HashMap<ImmutableMap<IProperty<?>, Comparable<?>>, IBlockState> getMapProperties() {
            if (this.mapProperties.isEmpty()) {
                this.mapProperties = new HashMap();
                for (IBlockState rawState : TileEntityBlockStateContainer.this.func_177619_a()) {
                    this.mapProperties.put(rawState.func_177228_b(), rawState);
                }
            }
            return this.mapProperties;
        }

        public boolean hasValue(IUnlistedProperty<?> property) {
            return this.extraProperties.containsKey(property);
        }

        public <T> T getValue(IUnlistedProperty<T> property) {
            Object ret = this.extraProperties.get(property);
            return (T)ret;
        }

        public <T> PropertiesStateInstance withProperties(Object ... properties) {
            if (properties.length % 2 != 0) {
                throw new IllegalArgumentException("property pairs expected");
            }
            IdentityHashMap newExtraProperties = new IdentityHashMap(this.extraProperties);
            IUnlistedProperty property = (IUnlistedProperty)properties[0];
            newExtraProperties.put(property, properties[1]);
            TileEntityBlockStateContainer tileEntityBlockStateContainer = TileEntityBlockStateContainer.this;
            ((Object)((Object)tileEntityBlockStateContainer)).getClass();
            return tileEntityBlockStateContainer.new PropertiesStateInstance(this, newExtraProperties);
        }

        public <T extends Comparable<T>, V extends T> PropertiesStateInstance withProperty(IProperty<T> property, V value) {
            for (Comparable value1 : property.func_177700_c()) {
                Comparable value2 = value1;
                if (!value2.equals(value)) continue;
                this.Properties.replace(property, (Comparable<?>)value);
                if (this.mapProperties.isEmpty()) {
                    this.mapProperties = new HashMap();
                    for (IBlockState rawState : TileEntityBlockStateContainer.this.func_177619_a()) {
                        this.mapProperties.put(rawState.func_177228_b(), rawState);
                    }
                }
                return (PropertiesStateInstance)this.mapProperties.get(this.Properties);
            }
            return null;
        }

        public boolean hasExtraProperties() {
            return !this.extraProperties.isEmpty();
        }
    }
}

