/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks.mechanism;

import com.denfop.IUCore;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.MultiTileBlock;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.transformer.TileHEEVTransformer;
import com.denfop.tiles.transformer.TileTransformerEV;
import com.denfop.tiles.transformer.TileTransformerHV;
import com.denfop.tiles.transformer.TileTransformerLV;
import com.denfop.tiles.transformer.TileTransformerMV;
import com.denfop.tiles.transformer.TileUEVTransformer;
import com.denfop.tiles.transformer.TileUHEVTransformer;
import com.denfop.tiles.transformer.TileUHVTransformer;
import com.denfop.tiles.transformer.TileUMEVTransformer;
import com.denfop.tiles.transformer.TileUMHVTransformer;
import com.denfop.tiles.transformer.TileUMVTransformer;
import com.denfop.utils.ModUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;

public enum BlockTransformer implements IMultiTileBlock
{
    umv(TileUMVTransformer.class, 0),
    uhv(TileUHVTransformer.class, 1),
    uev(TileUEVTransformer.class, 2),
    umhv(TileUMHVTransformer.class, 3),
    umev(TileUMEVTransformer.class, 4),
    uhev(TileUHEVTransformer.class, 5),
    heev(TileHEEVTransformer.class, 6),
    lv(TileTransformerLV.class, 7),
    mv(TileTransformerMV.class, 8),
    hv(TileTransformerHV.class, 9),
    ev(TileTransformerEV.class, 10);

    public static final ResourceLocation IDENTITY;
    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    private final EnumRarity rarity;
    private TileEntityBlock dummyTe;

    private BlockTransformer(Class<? extends TileEntityBlock> teClass, int itemMeta) {
        this(teClass, itemMeta, EnumRarity.UNCOMMON);
    }

    private BlockTransformer(Class<? extends TileEntityBlock> teClass, int itemMeta, EnumRarity rarity) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
        this.rarity = rarity;
        GameRegistry.registerTileEntity(teClass, (ResourceLocation)IUCore.getIdentifier(this.func_176610_l()));
    }

    @Override
    public void buildDummies() {
        ModContainer mc = Loader.instance().activeModContainer();
        if (mc == null || !"industrialupgrade".equals(mc.getModId())) {
            throw new IllegalAccessError("Don't mess with this please.");
        }
        for (BlockTransformer block : BlockTransformer.values()) {
            if (block.teClass == null) continue;
            try {
                block.dummyTe = block.teClass.newInstance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String func_176610_l() {
        return this.name();
    }

    @Override
    public int getId() {
        return this.itemMeta;
    }

    @Override
    @Nonnull
    public ResourceLocation getIdentifier() {
        return IDENTITY;
    }

    @Override
    public boolean hasItem() {
        return true;
    }

    @Override
    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    @Override
    public boolean hasActive() {
        return false;
    }

    @Override
    @Nonnull
    public Set<EnumFacing> getSupportedFacings() {
        return ModUtils.allFacings;
    }

    @Override
    public float getHardness() {
        return 3.0f;
    }

    @Override
    @Nonnull
    public MultiTileBlock.HarvestTool getHarvestTool() {
        return MultiTileBlock.HarvestTool.Wrench;
    }

    @Override
    @Nonnull
    public MultiTileBlock.DefaultDrop getDefaultDrop() {
        return MultiTileBlock.DefaultDrop.Self;
    }

    @Override
    public boolean allowWrenchRotating() {
        return true;
    }

    @Override
    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }

    static {
        IDENTITY = IUCore.getIdentifier("transformer_iu");
    }
}

