/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.api.item.IMultiBlockItem;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.ISubEnum;
import com.denfop.tiles.base.TileEntityBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;

public final class TileBlockCreator {
    public static TileBlockCreator instance;
    private final Map<ResourceLocation, InfoAboutTile<?>> dataInfo = new HashMap();

    public TileBlockCreator() {
        instance = this;
    }

    public <E extends Enum<E>> BlockTileEntity create(Class<E> enumClass) {
        InfoAboutTile<E> instance = new InfoAboutTile<E>(enumClass);
        BlockTileEntity block = BlockTileEntity.create("industrialupgrade_" + ((IMultiTileBlock)((Object)((Enum)new ArrayList(((InfoAboutTile)instance).teBlocks).get(0)))).getIdentifier().func_110623_a(), ((IMultiTileBlock)((Object)((Enum)new ArrayList(((InfoAboutTile)instance).teBlocks).get(0)))).getIdentifier(), instance);
        instance.setBlock(block);
        this.dataInfo.put(((IMultiTileBlock)((Object)((Enum)new ArrayList(((InfoAboutTile)instance).teBlocks).get(0)))).getIdentifier(), instance);
        return block;
    }

    public void buildBlocks() {
        for (InfoAboutTile<?> tile : this.dataInfo.values()) {
            for (IMultiTileBlock multiTileBlock : ((InfoAboutTile)tile).teBlocks) {
                multiTileBlock.buildDummies();
            }
        }
    }

    public BlockTileEntity get(ResourceLocation identifier) {
        return this.dataInfo.get(identifier).getBlock();
    }

    public static class InfoAboutTile<E extends Enum<E>> {
        private final boolean specialModels;
        private final Set<E> teBlocks;
        private final List<IMultiTileBlock> idMap = new ArrayList<IMultiTileBlock>();
        private final CreativeTabs tab;
        private final Material defaultMaterial;
        private final List<? extends IMultiTileBlock> listBlock;
        private BlockTileEntity block;

        InfoAboutTile(Class<E> universe) {
            this.teBlocks = new HashSet();
            this.specialModels = IMultiBlockItem.class.isAssignableFrom(universe);
            for (Enum e : EnumSet.allOf(universe)) {
                this.register(e);
            }
            this.defaultMaterial = ((IMultiTileBlock)((Object)((Enum)new ArrayList<E>(this.teBlocks).get(0)))).getMaterial();
            this.tab = ((IMultiTileBlock)((Object)((Enum)new ArrayList<E>(this.teBlocks).get(0)))).getCreativeTab();
            this.listBlock = new ArrayList<IMultiTileBlock>(this.getTeBlocks());
            this.listBlock.sort((o1, o2) -> {
                if (o1.getId() < o2.getId()) {
                    return -1;
                }
                if (o1.getId() - o2.getId() == 0) {
                    return 0;
                }
                return 1;
            });
        }

        public List<? extends IMultiTileBlock> getListBlock() {
            return this.listBlock;
        }

        public CreativeTabs getTab() {
            return this.tab;
        }

        public Class<? extends TileEntityBlock> getClassFromName(String name) {
            ArrayList<E> list = new ArrayList<E>(this.teBlocks);
            for (Enum e : list) {
                if (!((IStringSerializable)e).func_176610_l().equals(name)) continue;
                return ((IMultiTileBlock)((Object)e)).getTeClass();
            }
            return null;
        }

        void register(E block) {
            this.teBlocks.add(block);
            if (((ISubEnum)block).getId() > -1) {
                int ID = ((ISubEnum)block).getId();
                while (this.idMap.size() < ID) {
                    this.idMap.add(null);
                }
                if (this.idMap.size() == ID) {
                    this.idMap.add((IMultiTileBlock)block);
                } else {
                    this.idMap.set(ID, (IMultiTileBlock)block);
                }
            }
        }

        public BlockTileEntity getBlock() {
            return this.block;
        }

        void setBlock(BlockTileEntity block) {
            this.block = block;
        }

        public Material getDefaultMaterial() {
            return this.defaultMaterial;
        }

        public boolean hasSpecialModels() {
            return this.specialModels;
        }

        public Set<? extends IMultiTileBlock> getTeBlocks() {
            return Collections.unmodifiableSet(this.teBlocks);
        }

        public List<IMultiTileBlock> getIdMap() {
            return Collections.unmodifiableList(this.idMap);
        }
    }
}

