/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks;

import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ModUtils;
import java.util.Set;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;

public enum MultiTileBlock implements IMultiTileBlock
{
    invalid(null);

    public static final MultiTileBlock[] values;
    public static final ResourceLocation loc;
    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    private final boolean hasActive;
    private final Set<EnumFacing> supportedFacings;
    private final boolean allowWrenchRotating;
    private final HarvestTool harvestTool;
    private final DefaultDrop defaultDrop;
    private final float hardness;
    private TileEntityBlock dummyTe;

    private MultiTileBlock(Class<? extends TileEntityBlock> teClass) {
        this.teClass = teClass;
        this.itemMeta = -1;
        this.hasActive = false;
        this.supportedFacings = ModUtils.noFacings;
        this.allowWrenchRotating = false;
        this.harvestTool = HarvestTool.None;
        this.defaultDrop = DefaultDrop.None;
        this.hardness = 5.0f;
    }

    @Override
    public void buildDummies() {
        ModContainer mc = Loader.instance().activeModContainer();
        if (mc != null && "industrialupgrade".equals(mc.getModId())) {
            for (MultiTileBlock block : values) {
                if (block.teClass == null) continue;
                try {
                    block.dummyTe = block.teClass.newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        } else {
            throw new IllegalAccessError("Don't mess with this please.");
        }
    }

    @Override
    public boolean hasItem() {
        return this.teClass != null && this.itemMeta != -1;
    }

    public String func_176610_l() {
        return this.name();
    }

    @Override
    public ResourceLocation getIdentifier() {
        return loc;
    }

    @Override
    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    @Override
    public boolean hasActive() {
        return this.hasActive;
    }

    @Override
    public int getId() {
        return this.itemMeta;
    }

    @Override
    public float getHardness() {
        return this.hardness;
    }

    @Override
    public HarvestTool getHarvestTool() {
        return this.harvestTool;
    }

    @Override
    public DefaultDrop getDefaultDrop() {
        return this.defaultDrop;
    }

    @Override
    public boolean allowWrenchRotating() {
        return this.allowWrenchRotating;
    }

    @Override
    public Set<EnumFacing> getSupportedFacings() {
        return this.supportedFacings;
    }

    @Override
    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }

    static {
        values = MultiTileBlock.values();
        loc = new ResourceLocation("industrialupgrade", "te");
    }

    public static enum HarvestTool {
        None(null, -1),
        Pickaxe("pickaxe", 0),
        Shovel("shovel", 0),
        Axe("axe", 0),
        Wrench("wrench", 0);

        public final String toolClass;
        public final int level;

        private HarvestTool(String toolClass, int level) {
            this.toolClass = toolClass;
            this.level = level;
        }
    }

    public static enum DefaultDrop {
        Self,
        None,
        Generator,
        Machine,
        AdvMachine;

    }
}

