/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.windsystem;

import com.denfop.api.windsystem.EnumHorizonSide;
import com.denfop.api.windsystem.EnumRotorSide;
import com.denfop.api.windsystem.EnumTypeWind;
import com.denfop.api.windsystem.EnumWindSide;
import com.denfop.api.windsystem.IWindMechanism;
import com.denfop.api.windsystem.IWindSystem;
import com.denfop.api.windsystem.event.WindGeneratorEvent;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.tiles.mechanism.water.TileBaseWaterGenerator;
import com.denfop.tiles.mechanism.wind.TileWindGenerator;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class WindSystem
implements IWindSystem {
    public static IWindSystem windSystem;
    public EnumTypeWind enumTypeWind = EnumTypeWind.ONE;
    public EnumWindSide windSide;
    public int tick = 12000;
    public EnumTypeWind[] enumTypeWinds = EnumTypeWind.values();
    List<IWindMechanism> mechanismList = new ArrayList<IWindMechanism>();
    Random rand;
    Map<EnumFacing, EnumFacing> facingMap = new HashMap<EnumFacing, EnumFacing>();
    private int time;
    private double Wind_Strength;

    public WindSystem() {
        windSystem = this;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.rand = new Random();
        this.windSide = EnumWindSide.getValue(this.rand.nextInt(8));
        this.facingMap.put(EnumFacing.EAST, EnumFacing.NORTH);
        this.facingMap.put(EnumFacing.NORTH, EnumFacing.WEST);
        this.facingMap.put(EnumFacing.WEST, EnumFacing.SOUTH);
        this.facingMap.put(EnumFacing.SOUTH, EnumFacing.EAST);
    }

    @Override
    public EnumTypeWind getEnumTypeWind() {
        return this.enumTypeWind;
    }

    @Override
    public int getLevelWind() {
        return this.enumTypeWind.ordinal() + 1;
    }

    @Override
    public EnumWindSide getWindSide() {
        return this.windSide;
    }

    @Override
    public void getNewFacing(EnumFacing facing, IWindMechanism windMechanism) {
        if (facing == EnumFacing.DOWN || facing == EnumFacing.UP) {
            return;
        }
        facing = this.facingMap.get(facing);
        if (windMechanism instanceof TileWindGenerator) {
            ((TileWindGenerator)windMechanism).setFacingWrench(facing, null);
            new PacketUpdateFieldTile((TileWindGenerator)windMechanism, "facing", (byte)windMechanism.getFacing().ordinal());
            this.changeRotorSide(windMechanism, windMechanism.getFacing());
        } else {
            ((TileBaseWaterGenerator)windMechanism).setFacingWrench(facing, null);
            new PacketUpdateFieldTile((TileBaseWaterGenerator)windMechanism, "facing", (byte)windMechanism.getFacing().ordinal());
            this.changeRotorSide(windMechanism, windMechanism.getFacing());
        }
    }

    @SubscribeEvent
    public void LoadWindMechanism(WindGeneratorEvent event) {
        IWindMechanism windMechanism = event.getWindMechanism();
        if (event.getLoad()) {
            windMechanism.setCoefficient(this.getCoefficient(windMechanism));
            if (windMechanism.getAuto()) {
                this.getNewPositionOfMechanism(windMechanism);
                windMechanism.setCoefficient(this.getCoefficient(windMechanism));
            }
            if (!this.mechanismList.contains(windMechanism)) {
                this.mechanismList.add(windMechanism);
            }
        } else {
            this.mechanismList.remove(windMechanism);
        }
    }

    @SubscribeEvent
    public void EventWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_73011_w.getDimension() == 0) {
            this.mechanismList.clear();
        }
    }

    @Override
    public double getWind_Strength() {
        return this.Wind_Strength;
    }

    @Override
    public void changeRotorSide(IWindMechanism windMechanism, EnumFacing facing) {
        windMechanism.setRotorSide(this.getRotorSide(facing));
        windMechanism.setCoefficient(this.getCoefficient(windMechanism));
    }

    @Override
    public void getNewPositionOfMechanism(IWindMechanism windMechanism) {
        EnumFacing newFacing = this.getNewFacing();
        if (windMechanism instanceof TileWindGenerator) {
            if (windMechanism.getFacing() != newFacing) {
                ((TileWindGenerator)windMechanism).setFacingWrench(newFacing, null);
                new PacketUpdateFieldTile((TileWindGenerator)windMechanism, "facing", (byte)windMechanism.getFacing().ordinal());
                this.changeRotorSide(windMechanism, windMechanism.getFacing());
            }
        } else if (windMechanism.getFacing() != newFacing) {
            ((TileBaseWaterGenerator)windMechanism).setFacingWrench(newFacing, null);
            new PacketUpdateFieldTile((TileBaseWaterGenerator)windMechanism, "facing", (byte)windMechanism.getFacing().ordinal());
            this.changeRotorSide(windMechanism, windMechanism.getFacing());
        }
    }

    @Override
    public EnumFacing getNewFacing() {
        switch (this.windSide) {
            case E: {
                return EnumFacing.SOUTH;
            }
            case W: 
            case SW: {
                return EnumFacing.NORTH;
            }
            case N: 
            case NW: 
            case SE: {
                return EnumFacing.EAST;
            }
            case S: 
            case NE: {
                return EnumFacing.WEST;
            }
        }
        return null;
    }

    @Override
    public EnumRotorSide getRotorSide(EnumFacing facing) {
        switch (facing) {
            case EAST: {
                return EnumRotorSide.E;
            }
            case WEST: {
                return EnumRotorSide.W;
            }
            case NORTH: {
                return EnumRotorSide.N;
            }
            case SOUTH: {
                return EnumRotorSide.S;
            }
        }
        return null;
    }

    public double getCoefficient(IWindMechanism windMechanism) {
        if (windMechanism == null) {
            return 0.0;
        }
        EnumHorizonSide side = this.windSide.getList().get(0);
        EnumRotorSide side_rotor = windMechanism.getRotorSide();
        EnumHorizonSide bad_sides = side_rotor.getBad_sides();
        EnumHorizonSide good_side = side_rotor.getGood_sides();
        EnumHorizonSide neutral_side = side_rotor.getNeutral_sides();
        for (EnumHorizonSide side2 : side.getEnumWindSide()) {
            for (EnumHorizonSide side1 : good_side.getEnumWindSide()) {
                if (side1 != side2) continue;
                return 1.0;
            }
            for (EnumHorizonSide side1 : neutral_side.getEnumWindSide()) {
                if (side1 != side2) continue;
                return 0.75;
            }
            for (EnumHorizonSide side1 : bad_sides.getEnumWindSide()) {
                if (side1 != side2) continue;
                return 0.5;
            }
        }
        return 0.0;
    }

    @Override
    public double getSpeed() {
        return ModUtils.limit(this.getWind_Strength() / (EnumTypeWind.TEN.getMax() * 1.5), 0.0, 2.0);
    }

    @Override
    public double getSpeed(double speed) {
        return ModUtils.limit(speed / (EnumTypeWind.TEN.getMax() * 1.5), 0.0, 2.0);
    }

    @SubscribeEvent
    public void windTick(TickEvent.WorldTickEvent event) {
        World world;
        if (event.world.field_73011_w.getDimension() != 0) {
            if (this.tick == 0) {
                this.windSide = EnumWindSide.getValue(this.rand.nextInt(8));
                for (IWindMechanism windMechanism : this.mechanismList) {
                    windMechanism.setCoefficient(this.getCoefficient(windMechanism));
                    if (!windMechanism.getAuto()) continue;
                    this.getNewPositionOfMechanism(windMechanism);
                    windMechanism.setCoefficient(this.getCoefficient(windMechanism));
                }
            }
            return;
        }
        --this.tick;
        if (this.tick == 0) {
            this.windSide = EnumWindSide.getValue(this.rand.nextInt(8));
            this.tick = 12000;
            for (IWindMechanism windMechanism : this.mechanismList) {
                windMechanism.setCoefficient(this.getCoefficient(windMechanism));
                if (!windMechanism.getAuto()) continue;
                this.getNewPositionOfMechanism(windMechanism);
                windMechanism.setCoefficient(this.getCoefficient(windMechanism));
            }
        }
        if ((world = event.world).func_72820_D() % 20L == 0L) {
            double coef;
            if (!world.func_72896_J()) {
                if (!world.func_72911_I()) {
                    if (world.func_72912_H().func_176133_A() > 0) {
                        int time = world.func_72912_H().func_176133_A();
                        if (time > 110000) {
                            this.time = time - 8000;
                            this.enumTypeWind = EnumTypeWind.ONE;
                        } else if (time < 110000 && time >= 8000) {
                            this.time = time - 8000;
                            this.enumTypeWind = EnumTypeWind.ONE;
                        }
                        if (time < 8000 && time >= 5000) {
                            this.time = time - 5000;
                            this.enumTypeWind = EnumTypeWind.TWO;
                        }
                        if (time < 5000 && time >= 2500) {
                            this.time = time - 2500;
                            this.enumTypeWind = EnumTypeWind.THREE;
                        }
                        if (time < 2500 && time >= 1) {
                            this.time = time;
                            this.enumTypeWind = EnumTypeWind.FOUR;
                        }
                        coef = this.enumTypeWind.getMax() - this.enumTypeWind.getMin();
                        this.Wind_Strength = this.enumTypeWind.getMin() + (double)world.field_73012_v.nextInt((int)(coef *= 10.0) + 1) / 10.0;
                    } else if (world.func_72912_H().func_76083_p() > 0) {
                        int time = world.func_72912_H().func_76083_p();
                        if (time > 150000) {
                            this.enumTypeWind = EnumTypeWind.ONE;
                            this.time = time - 150000;
                        } else if (time < 150000 && time >= 100000) {
                            this.enumTypeWind = EnumTypeWind.TWO;
                            this.time = time - 100000;
                        } else if (time < 100000 && time >= 60000) {
                            this.enumTypeWind = EnumTypeWind.THREE;
                            this.time = time - 60000;
                        } else if (time < 60000 && time >= 20000) {
                            this.enumTypeWind = EnumTypeWind.FOUR;
                            this.time = time - 20000;
                        } else if (time < 20000 && time >= 1) {
                            this.time = time;
                            this.enumTypeWind = EnumTypeWind.FIVE;
                        }
                        coef = this.enumTypeWind.getMax() - this.enumTypeWind.getMin();
                        this.Wind_Strength = this.enumTypeWind.getMin() + (double)world.field_73012_v.nextInt((int)(coef *= 10.0) + 1) / 10.0;
                    } else if (world.func_72912_H().func_76071_n() > 0) {
                        int time = world.func_72912_H().func_76071_n();
                        if (time > 150000) {
                            this.enumTypeWind = EnumTypeWind.ONE;
                            this.time = time - 100000;
                        } else if (time < 150000 && time >= 100000) {
                            this.enumTypeWind = EnumTypeWind.TWO;
                            this.time = time - 100000;
                        } else if (time < 100000 && time >= 60000) {
                            this.enumTypeWind = EnumTypeWind.THREE;
                            this.time = time - 60000;
                        } else if (time < 60000 && time >= 20000) {
                            this.enumTypeWind = EnumTypeWind.FOUR;
                            this.time = time - 20000;
                        } else if (time < 20000 && time >= 1) {
                            this.enumTypeWind = EnumTypeWind.FIVE;
                            this.time = time;
                        }
                        coef = this.enumTypeWind.getMax() - this.enumTypeWind.getMin();
                        this.Wind_Strength = this.enumTypeWind.getMin() + (double)world.field_73012_v.nextInt((int)(coef *= 10.0) + 1) / 10.0;
                    }
                } else {
                    int time = world.func_72912_H().func_76071_n();
                    if (time > 20000) {
                        this.enumTypeWind = EnumTypeWind.SEVEN;
                        this.time = time - 20000;
                    }
                    if (time < 20000 && time >= 12000) {
                        this.enumTypeWind = EnumTypeWind.EIGHT;
                        this.time = time - 12000;
                    }
                    if (time < 12000 && time >= 5000) {
                        this.time = time - 5000;
                        this.enumTypeWind = EnumTypeWind.NINE;
                    }
                    if (time < 5000 && time >= 1) {
                        this.time = time;
                        this.enumTypeWind = EnumTypeWind.TEN;
                    }
                    coef = this.enumTypeWind.getMax() - this.enumTypeWind.getMin();
                    this.Wind_Strength = this.enumTypeWind.getMin() + (double)world.field_73012_v.nextInt((int)(coef *= 10.0) + 1) / 10.0;
                }
            } else if (world.func_72912_H().func_76083_p() > 0 && world.func_72896_J() && !world.func_72911_I()) {
                int time = world.func_72912_H().func_76083_p();
                if (time > 20000) {
                    this.time = time - 20000;
                    this.enumTypeWind = EnumTypeWind.FIVE;
                }
                if (time < 20000 && time >= 12000) {
                    this.time = time - 12000;
                    this.enumTypeWind = EnumTypeWind.SIX;
                }
                if (time < 12000 && time >= 5000) {
                    this.time = time - 5000;
                    this.enumTypeWind = EnumTypeWind.SEVEN;
                }
                if (time < 5000 && time >= 1) {
                    this.time = time;
                    this.enumTypeWind = EnumTypeWind.EIGHT;
                }
                coef = this.enumTypeWind.getMax() - this.enumTypeWind.getMin();
                this.Wind_Strength = this.enumTypeWind.getMin() + (double)world.field_73012_v.nextInt((int)(coef *= 10.0) + 1) / 10.0;
            } else if (world.func_72912_H().func_76071_n() > 0) {
                int time = world.func_72912_H().func_76071_n();
                if (time > 20000) {
                    this.time = time - 20000;
                    this.enumTypeWind = EnumTypeWind.SEVEN;
                }
                if (time < 20000 && time >= 12000) {
                    this.time = time - 12000;
                    this.enumTypeWind = EnumTypeWind.EIGHT;
                }
                if (time < 12000 && time >= 5000) {
                    this.time = time - 5000;
                    this.enumTypeWind = EnumTypeWind.NINE;
                }
                if (time < 5000 && time >= 1) {
                    this.time = time;
                    this.enumTypeWind = EnumTypeWind.TEN;
                }
                coef = this.enumTypeWind.getMax() - this.enumTypeWind.getMin();
                this.Wind_Strength = this.enumTypeWind.getMin() + (double)world.field_73012_v.nextInt((int)(coef *= 10.0) + 1) / 10.0;
            }
            double speed = this.getSpeed();
            for (IWindMechanism windMechanism : this.mechanismList) {
                if (windMechanism == null) continue;
                windMechanism.setRotationSpeed((float)speed);
            }
        }
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public double getPower(World world, BlockPos pos, boolean min, IWindMechanism rotor) {
        if (world.field_73011_w.getDimension() != 0) {
            return 0.0;
        }
        if (world.field_72995_K) {
            return 0.0;
        }
        if (rotor.getMinWind() != 0) {
            int meta = Math.min(this.enumTypeWind.ordinal() + rotor.getMinWind(), 9);
            EnumTypeWind enumTypeWinds = this.enumTypeWinds[meta];
            double coef = enumTypeWinds.getMax() - enumTypeWinds.getMin();
            coef *= 10.0;
            coef = enumTypeWinds.getMin() + (double)world.field_73012_v.nextInt((int)coef + 1) / 10.0;
            coef += (double)rotor.getMinWindSpeed();
            coef = Math.min(coef, EnumTypeWind.TEN.getMax());
            int y = pos.func_177956_o();
            if (min) {
                y = 150;
            }
            coef = y < 150 ? (coef *= (double)y / 150.0) : (coef *= 150.0 / (double)y);
            return coef * 27.0;
        }
        double coef = this.Wind_Strength;
        coef += (double)rotor.getMinWindSpeed();
        int y = pos.func_177956_o();
        if (min) {
            y = 150;
        }
        coef = y < 150 ? (coef *= (double)y / 150.0) : (coef *= 150.0 / (double)y);
        return coef * 27.0;
    }

    @Override
    public double getSpeedFromPower(BlockPos pos, IWindMechanism rotor, double power) {
        double copy_power = power / 27.0;
        copy_power /= (double)rotor.getRotor().getEfficiency(rotor.getItemStack()) * (1.0 + rotor.getAdditionalPower()) * (rotor.getCoefficient() * (1.0 + rotor.getAdditionalCoefficient()));
        int y = pos.func_177956_o();
        if (rotor.getMin()) {
            y = 150;
        }
        copy_power = y < 150 ? (copy_power /= (double)y / 150.0) : (copy_power /= 150.0 / (double)y);
        return copy_power;
    }

    @Override
    public double getSpeedFromWaterPower(BlockPos pos, IWindMechanism rotor, double power) {
        double copy_power = power / 27.0;
        return copy_power /= (double)rotor.getRotor().getEfficiency(rotor.getItemStack()) * (1.0 + rotor.getAdditionalPower()) * (rotor.getCoefficient() * (1.0 + rotor.getAdditionalCoefficient()));
    }

    @Override
    public double getPowerFromWindRotor(World world, BlockPos pos, IWindMechanism windMechanism, ItemStack stack) {
        return this.getPower(world, pos, windMechanism.getMin(), windMechanism) * ((double)windMechanism.getRotor().getEfficiency(stack) * (1.0 + windMechanism.getAdditionalPower())) * (windMechanism.getCoefficient() * (1.0 + windMechanism.getAdditionalCoefficient()));
    }

    @Override
    public double getPowerFromWaterRotor(World world, IWindMechanism windMechanism, ItemStack stack) {
        return this.getPower(world, new BlockPos(0, 150, 0), windMechanism.getMin(), windMechanism) / 27.0 * 25.0 * ((double)windMechanism.getRotor().getEfficiency(stack) * (1.0 + windMechanism.getAdditionalPower())) * (windMechanism.getCoefficient() * (1.0 + windMechanism.getAdditionalCoefficient()));
    }
}

