/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.upgrade;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.IUpgradeSystem;
import com.denfop.api.upgrade.IUpgradeWithBlackList;
import com.denfop.api.upgrade.UpgradeItemInform;
import com.denfop.api.upgrade.UpgradeModificator;
import com.denfop.api.upgrade.event.EventItemBlackListLoad;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.modules.ItemUpgradeModule;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BaseUpgradeSystem
implements IUpgradeSystem {
    Map<Integer, List<UpgradeItemInform>> map = new HashMap<Integer, List<UpgradeItemInform>>();
    Map<Integer, List<UpgradeModificator>> map_modification;
    Map<Integer, ItemStack> map_stack;
    Map<Integer, Integer> map_col;
    Map<Integer, List<String>> map_blackList = new HashMap<Integer, List<String>>();
    List<UpgradeModificator> list_modificators;
    int max = 0;

    public BaseUpgradeSystem() {
        this.map_col = new HashMap<Integer, Integer>();
        this.map_stack = new HashMap<Integer, ItemStack>();
        this.list_modificators = new ArrayList<UpgradeModificator>();
        this.map_modification = new HashMap<Integer, List<UpgradeModificator>>();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void addupgrade(Item container, ItemStack fill) {
        NBTTagCompound nbt = ModUtils.nbt();
        nbt.func_74778_a("mode_module", fill.func_77973_b() instanceof ItemUpgradeModule ? ItemUpgradeModule.getType((int)fill.func_77952_i()).name : "blacklist");
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("upgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack(container, 1, Short.MAX_VALUE)), input.getInput(fill)), new RecipeOutput(nbt, new ItemStack(container, 1, Short.MAX_VALUE))));
        Recipes.recipes.addRecipe("antiupgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack(container, 1, Short.MAX_VALUE))), new RecipeOutput(nbt, fill)));
    }

    public static void addupgrade(Item container, ItemStack fill, String type) {
        NBTTagCompound nbt = ModUtils.nbt();
        nbt.func_74778_a("type", type);
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("upgradeblock", new BaseMachineRecipe(new Input(input.getInput(new ItemStack(container, 1, Short.MAX_VALUE)), input.getInput(fill)), new RecipeOutput(nbt, new ItemStack(container, 1, Short.MAX_VALUE))));
    }

    @Override
    public void addModification() {
        this.list_modificators.clear();
        this.list_modificators.add(new UpgradeModificator(new ItemStack(IUItem.core, 1, 7), "0"));
        this.list_modificators.add(new UpgradeModificator(new ItemStack(IUItem.neutroniumingot, 1), "1"));
    }

    @Override
    public void addModificate(ItemStack container, String name) {
        NBTTagCompound nbt = ModUtils.nbt(container);
        nbt.func_74778_a("modification_module" + name, name);
    }

    @Override
    public boolean needModificate(ItemStack container, ItemStack fill) {
        List<UpgradeModificator> list = this.getListModifications(container);
        for (UpgradeModificator modificator : list) {
            if (!modificator.matches(fill)) continue;
            return false;
        }
        return true;
    }

    @SubscribeEvent
    public void loadItem(EventItemLoad event) {
        this.updateListFromNBT(event.item, event.stack);
    }

    @SubscribeEvent
    public void loadItem(EventItemBlackListLoad event) {
        this.updateBlackListFromNBT(event.item, event.stack, event.nbt);
    }

    @Override
    public boolean getModifications(ItemStack item) {
        return this.map_modification.containsKey(ModUtils.nbt(item).func_74762_e("ID_Item"));
    }

    @Override
    public List<UpgradeModificator> getListModifications(ItemStack item) {
        int id = ModUtils.nbt(item).func_74762_e("ID_Item");
        ArrayList list = this.map_modification.get(id);
        return list != null ? list : new ArrayList();
    }

    @Override
    public int getRemaining(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        int k = this.getListModifications(item).size();
        return this.map_col.getOrDefault(id, 4 + k);
    }

    @Override
    public boolean hasBlackList(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        return this.map_blackList.containsKey(id);
    }

    @Override
    public boolean hasInMap(ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int id = nbt.func_74762_e("ID_Item");
        ItemStack item = this.map_stack.get(id);
        if (item == null || item.func_190926_b()) {
            return false;
        }
        int id1 = ModUtils.nbt(item).func_74762_e("ID_Item");
        return item.func_77969_a(stack) && id1 == id && item.func_77978_p() != null && item.func_77978_p().equals((Object)stack.func_77978_p());
    }

    @Override
    public List<String> getBlackList(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        ArrayList list = this.map_blackList.get(id);
        return list != null ? list : new ArrayList();
    }

    @Override
    public List<UpgradeItemInform> getInformation(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        ArrayList list = this.map.get(id);
        return list != null ? list : new ArrayList();
    }

    @Override
    public UpgradeItemInform getModules(EnumInfoUpgradeModules module, ItemStack item) {
        List<UpgradeItemInform> list = this.getInformation(item);
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public UpgradeItemInform getModules(EnumInfoUpgradeModules module, ItemStack item, List<UpgradeItemInform> list) {
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public boolean hasModules(EnumInfoUpgradeModules module, ItemStack item) {
        if (!(item.func_77973_b() instanceof IUpgradeItem)) {
            return false;
        }
        List<UpgradeItemInform> list = this.getInformation(item);
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasModules(EnumInfoUpgradeModules module, ItemStack item, List<UpgradeItemInform> list) {
        if (!(item.func_77973_b() instanceof IUpgradeItem)) {
            return false;
        }
        for (UpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateListFromNBT(IUpgradeItem item, ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        boolean hasID = nbt.func_74767_n("hasID");
        int id = nbt.func_74762_e("ID_Item");
        if (!hasID) {
            id = this.max++;
            nbt.func_74768_a("ID_Item", id);
            nbt.func_74757_a("hasID", true);
        }
        ArrayList<EnumInfoUpgradeModules> lst = new ArrayList<EnumInfoUpgradeModules>();
        ArrayList<UpgradeModificator> list = new ArrayList<UpgradeModificator>();
        this.addModification();
        for (int i = 0; i < 2; ++i) {
            String name = nbt.func_74779_i("modification_module" + i);
            if (name.isEmpty() || this.getModification(i) == null) continue;
            list.add(this.getModification(i));
        }
        List<UpgradeModificator> list1 = this.map_modification.get(id);
        if (list1 != null) {
            list1.clear();
            list1.addAll(list);
        } else {
            this.map_modification.put(id, list);
        }
        int empty = 0;
        boolean canupgrade = false;
        for (int i = 0; i < 4 + list.size(); ++i) {
            String name = nbt.func_74779_i("mode_module" + i);
            if (name.equals("")) {
                ++empty;
                canupgrade = true;
            }
            if (name.equals("")) continue;
            int index = IUItem.list.indexOf(name);
            lst.add(EnumInfoUpgradeModules.getFromID(index));
        }
        int ost = empty;
        nbt.func_74757_a("canupgrade", canupgrade);
        if (this.map_col.containsKey(id)) {
            this.map_col.replace(id, ost);
        } else {
            this.map_col.put(id, ost);
        }
        this.setInformation(item, lst, stack);
    }

    private UpgradeModificator getModification(int i) {
        if (i == 0) {
            return this.list_modificators.get(0);
        }
        if (i == 1) {
            return this.list_modificators.get(1);
        }
        return null;
    }

    @Override
    public void setInformation(IUpgradeItem item, List<EnumInfoUpgradeModules> lst, ItemStack stack) {
        this.write(item, lst, stack);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        this.map.clear();
        this.map_blackList.clear();
        this.max = 0;
        this.map_col.clear();
        this.map_stack.clear();
        this.list_modificators.clear();
        this.map_modification.clear();
    }

    @Override
    public void write(IUpgradeItem item, List<EnumInfoUpgradeModules> lst, ItemStack stack) {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        for (Object upgrade : lst) {
            if (map.containsKey(upgrade)) {
                map.replace(upgrade, (Integer)map.get(upgrade) + 1);
                continue;
            }
            map.put(upgrade, 1);
        }
        ArrayList<UpgradeItemInform> list = new ArrayList<UpgradeItemInform>();
        for (Map.Entry entry : map.entrySet()) {
            list.add(new UpgradeItemInform((EnumInfoUpgradeModules)((Object)entry.getKey()), (Integer)entry.getValue()));
        }
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int n = nbt.func_74762_e("ID_Item");
        if (!this.map.containsKey(n)) {
            this.map.put(n, list);
            this.map_stack.put(n, stack);
        } else {
            this.map.replace(n, list);
            this.map_stack.replace(n, stack);
        }
        Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (this.hasModules(EnumInfoUpgradeModules.SILK_TOUCH, stack)) {
            enchantmentMap.put(Enchantments.field_185306_r, 1);
        } else {
            enchantmentMap.remove(Enchantments.field_185306_r);
        }
        if (this.hasModules(EnumInfoUpgradeModules.LUCKY, stack)) {
            enchantmentMap.put(Enchantments.field_185308_t, this.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.LUCKY, (ItemStack)stack).number);
        } else {
            enchantmentMap.remove(Enchantments.field_185308_t);
        }
        if (this.hasModules(EnumInfoUpgradeModules.EFFICIENT, stack)) {
            enchantmentMap.put(Enchantments.field_185305_q, 1 + (this.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.EFFICIENT, (ItemStack)stack).number - 1) * 2);
        } else {
            enchantmentMap.remove(Enchantments.field_185305_q);
        }
        if (this.hasModules(EnumInfoUpgradeModules.FIRE, stack)) {
            enchantmentMap.put(Enchantments.field_77334_n, this.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.FIRE, (ItemStack)stack).number);
        } else {
            enchantmentMap.remove(Enchantments.field_77334_n);
        }
        if (this.hasModules(EnumInfoUpgradeModules.LOOT, stack)) {
            enchantmentMap.put(Enchantments.field_185304_p, this.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.LOOT, (ItemStack)stack).number);
        } else {
            enchantmentMap.remove(Enchantments.field_185304_p);
        }
        if (this.hasModules(EnumInfoUpgradeModules.PROTECTION_ARROW, stack)) {
            enchantmentMap.put(Enchantments.field_180308_g, 1 + (this.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.PROTECTION_ARROW, (ItemStack)stack).number - 1) * 2);
        } else {
            enchantmentMap.remove(Enchantments.field_180308_g);
        }
        EnchantmentHelper.func_82782_a((Map)enchantmentMap, (ItemStack)stack);
    }

    @Override
    public void updateBlackListFromNBT(IUpgradeWithBlackList item, ItemStack stack, NBTTagCompound nbt) {
        this.updateListFromNBT(item, stack);
        ArrayList<String> lst = new ArrayList<String>();
        int size = nbt.func_74762_e("size");
        ModUtils.nbt(stack).func_74768_a("size", size);
        for (int j = 0; j < size; ++j) {
            String l = "number_" + j;
            if (nbt.func_74779_i(l).isEmpty()) continue;
            lst.add(nbt.func_74779_i(l));
        }
        nbt = ModUtils.nbt(stack);
        int id = nbt.func_74762_e("ID_Item");
        nbt.func_74757_a("accept_blacklist", true);
        if (this.map_blackList.containsKey(id)) {
            this.map_blackList.replace(id, lst);
        } else {
            this.map_blackList.put(id, lst);
        }
    }

    @Override
    public void updateBlackListFromStack(ItemStack stack) {
        ArrayList<String> lst = new ArrayList<String>();
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int size = nbt.func_74762_e("size");
        for (int j = 0; j < size; ++j) {
            String l = "number_" + j;
            if (nbt.func_74779_i(l).isEmpty()) continue;
            lst.add(nbt.func_74779_i(l));
        }
        int id = nbt.func_74762_e("ID_Item");
        nbt.func_74757_a("accept_blacklist", true);
        if (this.map_blackList.containsKey(id)) {
            this.map_blackList.replace(id, lst);
        } else {
            this.map_blackList.put(id, lst);
        }
    }

    @Override
    public void removeUpdate(ItemStack stack, World world, int index) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        nbt.func_74778_a("mode_module" + index, "");
        MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, (IUpgradeItem)stack.func_77973_b(), stack));
    }

    @Override
    public List<ItemStack> getListStack(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int size = this.getListModifications(stack).size();
        for (int i = 0; i < 4 + size; ++i) {
            String name = nbt.func_74779_i("mode_module" + i);
            if (!name.equals("")) {
                int index = IUItem.list.indexOf(name);
                list.add(new ItemStack(IUItem.upgrademodule, 1, index));
                continue;
            }
            list.add(ItemStack.field_190927_a);
        }
        return list;
    }

    @Override
    public void addRecipe(Item stack, List<EnumInfoUpgradeModules> lst) {
        for (EnumInfoUpgradeModules upgrades : lst) {
            BaseUpgradeSystem.addupgrade(stack, new ItemStack(IUItem.upgrademodule, 1, upgrades.ordinal()));
        }
        if (lst.contains((Object)EnumInfoUpgradeModules.DIG_DEPTH)) {
            BaseUpgradeSystem.addupgrade(stack, new ItemStack(IUItem.module9, 1, 12));
        }
        for (UpgradeModificator modificator : this.list_modificators) {
            BaseUpgradeSystem.addupgrade(stack, modificator.itemstack, modificator.type);
        }
    }

    @Override
    public boolean shouldUpdate(EnumInfoUpgradeModules type, ItemStack stack1) {
        List<UpgradeItemInform> list = this.getInformation(stack1);
        for (UpgradeItemInform inform : list) {
            if (inform.upgrade != type || inform.number < type.max) continue;
            return false;
        }
        return true;
    }
}

