/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.transport;

import com.denfop.api.transport.EventHandler;
import com.denfop.api.transport.ITransportNet;
import com.denfop.api.transport.ITransportTile;
import com.denfop.api.transport.TransportNetLocal;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TransportNetGlobal
implements ITransportNet {
    public static TransportNetGlobal instance;
    private static Map<World, TransportNetLocal> worldToEnergyNetMap;

    public static TransportNetGlobal initialize() {
        new EventHandler();
        instance = new TransportNetGlobal();
        return instance;
    }

    public static void onWorldUnload(World world) {
        TransportNetLocal local = worldToEnergyNetMap.remove(world);
        if (local != null) {
            local.onUnload();
        }
    }

    public static TransportNetLocal getForWorld(World world) {
        if (world == null) {
            return null;
        }
        if (!worldToEnergyNetMap.containsKey(world)) {
            worldToEnergyNetMap.put(world, new TransportNetLocal(world));
        }
        return worldToEnergyNetMap.get(world);
    }

    public static void onTickEnd(World world) {
        TransportNetLocal energyNet = TransportNetGlobal.getForWorld(world);
        if (energyNet != null) {
            energyNet.onTickEnd();
        }
    }

    @Override
    public ITransportTile getSubTile(World var1, BlockPos var2) {
        TransportNetLocal local = TransportNetGlobal.getForWorld(var1);
        if (local != null) {
            return local.getTileEntity(var2);
        }
        return null;
    }

    @Override
    public <T extends TileEntity> void addTile(T var1) {
        TransportNetLocal local = TransportNetGlobal.getForWorld(var1.func_145831_w());
        local.addTile((ITransportTile)var1);
    }

    @Override
    public void removeTile(ITransportTile var1) {
        TransportNetLocal local = TransportNetGlobal.getForWorld(((TileEntity)var1).func_145831_w());
        local.removeTile(var1);
    }

    static {
        worldToEnergyNetMap = new WeakHashMap<World, TransportNetLocal>();
    }
}

