/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.transport;

import com.denfop.api.transport.ITransportConductor;
import com.denfop.api.transport.ITransportTile;
import com.denfop.api.transport.TransportFluidItemSinkSource;
import com.denfop.api.transport.TransportNetGlobal;
import com.denfop.api.transport.TransportNetLocal;
import com.denfop.api.transport.event.TransportTileLoadEvent;
import com.denfop.api.transport.event.TransportTileUnLoadEvent;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class EventHandler {
    EnumFacing[] enumFacings = EnumFacing.field_82609_l;

    public EventHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergyTileLoad(BlockEvent.PlaceEvent event) {
        TileEntity tile;
        if (event.isCanceled()) {
            return;
        }
        if (event.getWorld().field_72995_K) {
            return;
        }
        BlockPos pos = event.getPos();
        Block block = event.getPlacedBlock().func_177230_c();
        if (block.hasTileEntity(event.getPlacedBlock()) && (tile = event.getWorld().func_175625_s(pos)) != null) {
            if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                IItemHandler item_storage = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                IFluidHandler fluid_storage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null);
                boolean isSink = false;
                boolean isSource = false;
                boolean isSinkFluid = false;
                boolean isSourceFluid = false;
                ArrayList<EnumFacing> facingListSink = new ArrayList<EnumFacing>();
                ArrayList<EnumFacing> facingListSource = new ArrayList<EnumFacing>();
                for (EnumFacing facing : this.enumFacings) {
                    TileEntity tile1 = event.getWorld().func_175625_s(pos.func_177972_a(facing));
                    if (!(tile1 instanceof ITransportConductor)) continue;
                    ITransportConductor transport = (ITransportConductor)tile1;
                    Object handler = transport.getHandler();
                    if (handler instanceof IItemHandler) {
                        item_storage = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                        if (transport.isOutput()) {
                            isSource = true;
                            facingListSource.add(facing.func_176734_d());
                            continue;
                        }
                        isSink = true;
                        facingListSink.add(facing.func_176734_d());
                        continue;
                    }
                    if (!(handler instanceof IFluidHandler)) continue;
                    fluid_storage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
                    if (transport.isOutput()) {
                        isSourceFluid = true;
                        facingListSource.add(facing.func_176734_d());
                        continue;
                    }
                    isSinkFluid = true;
                    facingListSink.add(facing.func_176734_d());
                }
                if (isSink || isSinkFluid || isSource || isSourceFluid) {
                    TransportFluidItemSinkSource transport = new TransportFluidItemSinkSource(pos, item_storage, fluid_storage, isSink, isSource, isSinkFluid, isSourceFluid);
                    transport.setFacingListSink(facingListSink);
                    transport.setFacingListSource(facingListSource);
                    MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(event.getWorld(), transport));
                }
            } else if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                IItemHandler item_storage = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (item_storage == null) {
                    return;
                }
                ArrayList<EnumFacing> facingListSink = new ArrayList<EnumFacing>();
                ArrayList<EnumFacing> facingListSource = new ArrayList<EnumFacing>();
                boolean isSink = false;
                boolean isSource = false;
                for (EnumFacing facing : this.enumFacings) {
                    ITransportConductor transport;
                    TileEntity tile1 = event.getWorld().func_175625_s(pos.func_177972_a(facing));
                    if (!(tile1 instanceof ITransportConductor) || !(transport = (ITransportConductor)tile1).isItem()) continue;
                    item_storage = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
                    if (transport.isOutput()) {
                        facingListSource.add(facing.func_176734_d());
                        isSource = true;
                        continue;
                    }
                    facingListSink.add(facing.func_176734_d());
                    isSink = true;
                }
                if (isSink || isSource) {
                    TransportFluidItemSinkSource transport = new TransportFluidItemSinkSource(pos, item_storage, null, isSink, isSource, false, false);
                    transport.setFacingListSink(facingListSink);
                    transport.setFacingListSource(facingListSource);
                    MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(event.getWorld(), transport));
                }
            } else if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                boolean isSink = false;
                boolean isSource = false;
                IFluidHandler item_storage = null;
                ArrayList<EnumFacing> facingListSink = new ArrayList<EnumFacing>();
                ArrayList<EnumFacing> facingListSource = new ArrayList<EnumFacing>();
                for (EnumFacing facing : this.enumFacings) {
                    ITransportConductor transport;
                    Object handler;
                    TileEntity tile1 = event.getWorld().func_175625_s(pos.func_177972_a(facing));
                    if (!(tile1 instanceof ITransportConductor) || !((handler = (transport = (ITransportConductor)tile1).getHandler()) instanceof IFluidHandler)) continue;
                    item_storage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing.func_176734_d());
                    if (transport.isOutput()) {
                        facingListSource.add(facing.func_176734_d());
                        isSource = true;
                        break;
                    }
                    facingListSink.add(facing.func_176734_d());
                    isSink = true;
                    break;
                }
                if (isSink || isSource) {
                    TransportFluidItemSinkSource transport = new TransportFluidItemSinkSource(pos, null, item_storage, false, false, isSink, isSource);
                    transport.setFacingListSink(facingListSink);
                    transport.setFacingListSource(facingListSource);
                    MinecraftForge.EVENT_BUS.post(new TransportTileLoadEvent(event.getWorld(), transport));
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergyTileLoad(BlockEvent.BreakEvent event) {
        TileEntity tile;
        if (event.isCanceled()) {
            return;
        }
        if (event.getWorld().field_72995_K) {
            return;
        }
        if (event.getPlayer() == null) {
            return;
        }
        BlockPos pos = event.getPos();
        Block block = event.getState().func_177230_c();
        if (block.hasTileEntity(event.getState()) && (tile = event.getWorld().func_175625_s(pos)) != null) {
            ITransportTile iEnergyTile;
            if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)) {
                ITransportTile iEnergyTile2 = TransportNetGlobal.instance.getSubTile(event.getWorld(), pos);
                if (iEnergyTile2 != null) {
                    MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(event.getWorld(), iEnergyTile2));
                }
            } else if (tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
                ITransportTile iEnergyTile3 = TransportNetGlobal.instance.getSubTile(event.getWorld(), pos);
                if (iEnergyTile3 != null) {
                    MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(event.getWorld(), iEnergyTile3));
                }
            } else if (tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (iEnergyTile = TransportNetGlobal.instance.getSubTile(event.getWorld(), pos)) != null) {
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(event.getWorld(), iEnergyTile));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergyTileLoad(TransportTileLoadEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        TransportNetLocal local = TransportNetGlobal.getForWorld(event.getWorld());
        if (local != null) {
            local.addTile(event.tile);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void onEnergyTileUnLoad(TransportTileUnLoadEvent event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        TransportNetLocal local = TransportNetGlobal.getForWorld(event.getWorld());
        if (local != null) {
            local.removeTile(event.tile);
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            TransportNetGlobal.onTickEnd(event.world);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        TransportNetGlobal.onWorldUnload(event.getWorld());
    }
}

