/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.upgrades;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.api.recipe.Input;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.api.space.rovers.EnumTypeUpgrade;
import com.denfop.api.space.rovers.IRovers;
import com.denfop.api.space.upgrades.ISpaceUpgradeSystem;
import com.denfop.api.space.upgrades.SpaceUpgradeItemInform;
import com.denfop.api.space.upgrades.event.EventItemLoad;
import com.denfop.recipe.IInputHandler;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class BaseSpaceUpgradeSystem
implements ISpaceUpgradeSystem {
    Map<Integer, List<SpaceUpgradeItemInform>> map = new HashMap<Integer, List<SpaceUpgradeItemInform>>();
    Map<Integer, List<SpaceUpgradeItemInform>> map_modification;
    Map<Integer, ItemStack> map_stack;
    Map<Integer, Integer> map_col;
    Map<Integer, List<String>> map_blackList = new HashMap<Integer, List<String>>();
    int max = 0;

    public BaseSpaceUpgradeSystem() {
        this.map_col = new HashMap<Integer, Integer>();
        this.map_stack = new HashMap<Integer, ItemStack>();
        this.map_modification = new HashMap<Integer, List<SpaceUpgradeItemInform>>();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void addupgrade(Item container, ItemStack fill) {
        NBTTagCompound nbt = ModUtils.nbt();
        nbt.func_74778_a("mode_module", EnumTypeUpgrade.getFromID(fill.func_77952_i()).getUpgrade());
        IInputHandler input = Recipes.inputFactory;
        Recipes.recipes.addRecipe("upgrade_rovers", new BaseMachineRecipe(new Input(input.getInput(new ItemStack(container, 1, Short.MAX_VALUE)), input.getInput(fill)), new RecipeOutput(nbt, new ItemStack(container, 1, Short.MAX_VALUE))));
    }

    @SubscribeEvent
    public void loadItem(EventItemLoad event) {
        this.updateListFromNBT(event.item, event.stack);
    }

    @Override
    public boolean getModifications(ItemStack item) {
        return this.map_modification.containsKey(ModUtils.nbt(item).func_74762_e("ID_Item"));
    }

    @Override
    public int getRemaining(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        return this.map_col.getOrDefault(id, 4);
    }

    @Override
    public boolean hasInMap(ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int id = nbt.func_74762_e("ID_Item");
        if (!this.map_stack.containsKey(id)) {
            return false;
        }
        ItemStack item = this.map_stack.get(id);
        int id1 = ModUtils.nbt(item).func_74762_e("ID_Item");
        return item.func_77969_a(stack) && id1 == id;
    }

    @Override
    public List<String> getBlackList(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        return this.map_blackList.containsKey(id) ? this.map_blackList.get(id) : new ArrayList<String>();
    }

    @Override
    public List<SpaceUpgradeItemInform> getInformation(ItemStack item) {
        NBTTagCompound nbt = ModUtils.nbt(item);
        int id = nbt.func_74762_e("ID_Item");
        return this.map.containsKey(id) ? this.map.get(id) : new ArrayList<SpaceUpgradeItemInform>();
    }

    @Override
    public SpaceUpgradeItemInform getModules(EnumTypeUpgrade module, ItemStack item) {
        List<SpaceUpgradeItemInform> list = this.getInformation(item);
        for (SpaceUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return upgrade;
        }
        return null;
    }

    @Override
    public boolean hasModules(EnumTypeUpgrade module, ItemStack item) {
        List<SpaceUpgradeItemInform> list = this.getInformation(item);
        for (SpaceUpgradeItemInform upgrade : list) {
            if (!upgrade.matched(module)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateListFromNBT(IRovers item, ItemStack stack) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        boolean hasID = nbt.func_74767_n("hasID");
        int id = nbt.func_74762_e("ID_Item");
        if (!hasID) {
            id = this.max++;
            nbt.func_74768_a("ID_Item", id);
            nbt.func_74757_a("hasID", true);
        }
        ArrayList<EnumTypeUpgrade> lst = new ArrayList<EnumTypeUpgrade>();
        ArrayList list = new ArrayList();
        if (this.map_modification.containsKey(id)) {
            this.map_modification.replace(id, list);
        } else {
            this.map_modification.put(id, list);
        }
        int empty = 0;
        boolean canupgrade = false;
        for (int i = 0; i < 4; ++i) {
            String name = nbt.func_74779_i("mode_module" + i);
            if (name.equals("")) {
                ++empty;
                canupgrade = true;
            }
            if (name.equals("")) continue;
            int index = IUItem.list_space_upgrades.indexOf(name);
            lst.add(EnumTypeUpgrade.getFromID(index));
        }
        int ost = empty;
        nbt.func_74757_a("canupgrade", canupgrade);
        if (this.map_col.containsKey(id)) {
            this.map_col.replace(id, ost);
        } else {
            this.map_col.put(id, ost);
        }
        this.setInformation(item, lst, stack);
    }

    @Override
    public void setInformation(IRovers item, List<EnumTypeUpgrade> lst, ItemStack stack) {
        this.write(item, lst, stack);
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.map.clear();
        this.map_blackList.clear();
        this.max = 0;
        this.map_col.clear();
        this.map_stack.clear();
        this.map_modification.clear();
    }

    @Override
    public void write(IRovers item, List<EnumTypeUpgrade> lst, ItemStack stack) {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        for (Object upgrade : lst) {
            if (map.containsKey(upgrade)) {
                map.replace(upgrade, (Integer)map.get(upgrade) + 1);
                continue;
            }
            map.put(upgrade, 1);
        }
        ArrayList<SpaceUpgradeItemInform> list = new ArrayList<SpaceUpgradeItemInform>();
        for (Map.Entry entry : map.entrySet()) {
            list.add(new SpaceUpgradeItemInform((EnumTypeUpgrade)((Object)entry.getKey()), (Integer)entry.getValue()));
        }
        NBTTagCompound nbt = ModUtils.nbt(stack);
        int n = nbt.func_74762_e("ID_Item");
        if (!this.map.containsKey(n)) {
            this.map.put(n, list);
            this.map_stack.put(n, stack);
        } else {
            this.map.replace(n, list);
            this.map_stack.replace(n, stack);
        }
    }

    @Override
    public void removeUpdate(ItemStack stack, World world, int index) {
        NBTTagCompound nbt = ModUtils.nbt(stack);
        nbt.func_74778_a("mode_module" + index, "");
        MinecraftForge.EVENT_BUS.post((Event)new EventItemLoad(world, (IRovers)stack.func_77973_b(), stack));
    }

    @Override
    public List<ItemStack> getListStack(ItemStack stack) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        NBTTagCompound nbt = ModUtils.nbt(stack);
        for (int i = 0; i < 4; ++i) {
            String name = nbt.func_74779_i("mode_module" + i);
            if (!name.equals("")) {
                int index = IUItem.list.indexOf(name);
                list.add(new ItemStack(IUItem.upgrademodule, 1, index));
                continue;
            }
            list.add(ItemStack.field_190927_a);
        }
        return list;
    }

    @Override
    public void addRecipe(Item stack, List<EnumTypeUpgrade> lst) {
    }
}

