/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.fakebody;

import com.denfop.ElectricItem;
import com.denfop.api.space.IAsteroid;
import com.denfop.api.space.IBaseResource;
import com.denfop.api.space.IBody;
import com.denfop.api.space.IPlanet;
import com.denfop.api.space.ISatellite;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.EnumOperation;
import com.denfop.api.space.fakebody.EventHandlerPlanet;
import com.denfop.api.space.fakebody.FakeAsteroid;
import com.denfop.api.space.fakebody.FakePlanet;
import com.denfop.api.space.fakebody.FakePlayer;
import com.denfop.api.space.fakebody.FakeSatellite;
import com.denfop.api.space.fakebody.IFakeAsteroid;
import com.denfop.api.space.fakebody.IFakeBody;
import com.denfop.api.space.fakebody.IFakePlanet;
import com.denfop.api.space.fakebody.IFakeSatellite;
import com.denfop.api.space.fakebody.IFakeSpaceSystemBase;
import com.denfop.api.space.fakebody.SpaceOperation;
import com.denfop.api.space.research.IResearchTable;
import com.denfop.api.space.rovers.EnumTypeUpgrade;
import com.denfop.api.space.rovers.IRovers;
import com.denfop.api.space.upgrades.SpaceUpgradeSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;

public class FakeSpaceSystemBase
implements IFakeSpaceSystemBase {
    private final List<FakePlanet> fakePlanetList;
    private final List<FakeSatellite> fakeSatelliteList;
    private final Map<FakePlanet, List<IBaseResource>> fakePlanetListMap;
    private final Map<FakeSatellite, List<IBaseResource>> fakeSatelliteListMap;
    private final Map<FakePlayer, List<IFakeBody>> entityPlayerListMap;
    private final Map<FakePlayer, IResearchTable> MapEntityPlayer;
    private final List<FakePlayer> fakePlayerList;
    private final Map<FakePlayer, List<SpaceOperation>> fakePlayerMapMap;
    private final Map<FakePlayer, Map<IBody, SpaceOperation>> fakeBodyMap;
    private final List<FakeAsteroid> fakeAsteroids;
    private final Map<FakeAsteroid, List<IBaseResource>> fakeAsteroidListMap;
    private final Random rand;

    public FakeSpaceSystemBase() {
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerPlanet());
        this.fakePlanetList = new ArrayList<FakePlanet>();
        this.fakeSatelliteList = new ArrayList<FakeSatellite>();
        this.rand = new Random();
        this.fakePlanetListMap = new HashMap<FakePlanet, List<IBaseResource>>();
        this.fakeSatelliteListMap = new HashMap<FakeSatellite, List<IBaseResource>>();
        this.entityPlayerListMap = new HashMap<FakePlayer, List<IFakeBody>>();
        this.MapEntityPlayer = new HashMap<FakePlayer, IResearchTable>();
        this.fakePlayerList = new ArrayList<FakePlayer>();
        this.fakePlayerMapMap = new HashMap<FakePlayer, List<SpaceOperation>>();
        this.fakeBodyMap = new HashMap<FakePlayer, Map<IBody, SpaceOperation>>();
        this.fakeAsteroids = new ArrayList<FakeAsteroid>();
        this.fakeAsteroidListMap = new HashMap<FakeAsteroid, List<IBaseResource>>();
    }

    @Override
    public Map<FakePlanet, List<IBaseResource>> getFakePlanetListMap() {
        return this.fakePlanetListMap;
    }

    @Override
    public void loadSpaceOperation(List<SpaceOperation> map, FakePlayer player) {
        this.fakePlayerMapMap.put(player, map);
        Map<IBody, SpaceOperation> map1 = SpaceNet.instance.getFakeSpaceSystem().getSpaceTable(player);
        if (map1.isEmpty()) {
            map1 = new HashMap<IBody, SpaceOperation>();
        }
        for (SpaceOperation operation : map) {
            map1.put(operation.getBody(), operation);
        }
    }

    @Override
    public Map<FakeSatellite, List<IBaseResource>> getFakeSatelliteListMap() {
        return this.fakeSatelliteListMap;
    }

    @Override
    public Map<FakeAsteroid, List<IBaseResource>> getFakeFakeAsteroidListMap() {
        return this.fakeAsteroidListMap;
    }

    @Override
    public List<FakeAsteroid> getFakeAsteroidList() {
        return this.fakeAsteroids;
    }

    @Override
    public List<SpaceOperation> getSpaceOperationMap(FakePlayer player) {
        if (this.fakePlayerMapMap.containsKey(player)) {
            return this.fakePlayerMapMap.get(player);
        }
        ArrayList<SpaceOperation> map = new ArrayList<SpaceOperation>();
        this.fakePlayerMapMap.put(player, map);
        return map;
    }

    @Override
    public Map<IBody, SpaceOperation> getSpaceTable(FakePlayer player) {
        return this.fakeBodyMap.get(player);
    }

    @Override
    public void addFakePlayer(FakePlayer player) {
        this.fakePlayerList.add(player);
    }

    @Override
    public List<FakePlayer> getFakePlayers() {
        return this.fakePlayerList;
    }

    @Override
    public Map<FakePlayer, IResearchTable> getResearchTableMap() {
        return this.MapEntityPlayer;
    }

    @Override
    public Map<FakePlayer, List<IFakeBody>> getBodyMap() {
        return this.entityPlayerListMap;
    }

    @Override
    public void loadFakeBody(IFakeBody body, List<IBaseResource> resourceList, FakePlayer player) {
        if (!this.entityPlayerListMap.containsKey(player)) {
            this.entityPlayerListMap.put(player, Collections.singletonList(body));
        } else {
            List<IFakeBody> list = this.entityPlayerListMap.get(player);
            list.add(body);
        }
        if (body instanceof IFakePlanet) {
            if (!this.fakePlanetList.contains((FakePlanet)body)) {
                this.fakePlanetList.add((FakePlanet)body);
                this.fakePlanetListMap.put((FakePlanet)body, resourceList);
            }
        } else if (body instanceof IFakeSatellite) {
            if (!this.fakeSatelliteList.contains((FakeSatellite)body)) {
                this.fakeSatelliteList.add((FakeSatellite)body);
                this.fakeSatelliteListMap.put((FakeSatellite)body, resourceList);
            }
        } else if (body instanceof IFakeAsteroid && !this.fakeAsteroids.contains((FakeAsteroid)body)) {
            this.fakeAsteroids.add((FakeAsteroid)body);
            this.fakeAsteroidListMap.put((FakeAsteroid)body, resourceList);
        }
    }

    @Override
    public void addFakeBodyFromPlayer(IResearchTable table, IFakeBody body) {
        if (!this.entityPlayerListMap.containsKey(table.getPlayer())) {
            this.entityPlayerListMap.put(table.getPlayer(), Collections.singletonList(body));
        } else {
            List<IFakeBody> list = this.entityPlayerListMap.get(table.getPlayer());
            list.add(body);
        }
    }

    @Override
    public void removeFakeBodyFromPlayer(IResearchTable table, IBody body) {
        List<IFakeBody> list = this.entityPlayerListMap.get(table.getPlayer());
        list.removeIf(body1 -> body1.matched(body));
    }

    @Override
    public List<FakePlanet> getFakePlanetList() {
        return this.fakePlanetList;
    }

    @Override
    public void working() {
        IResearchTable table;
        List<IBaseResource> resourceList;
        for (FakePlanet fakePlanet : this.fakePlanetList) {
            IResearchTable table2;
            if (ElectricItem.manager.getCharge(fakePlanet.getRover().getItemStack()) >= 100.0) {
                fakePlanet.setTime(1);
                ElectricItem.manager.use(fakePlanet.getRover().getItemStack(), 100.0, null);
                if (fakePlanet.getTime() % 150 != 0) continue;
                if (!this.fakePlanetListMap.containsKey(fakePlanet)) {
                    this.fakePlanetListMap.put(fakePlanet, new ArrayList());
                    continue;
                }
                int solar = 0;
                if (SpaceUpgradeSystem.system.hasModules(EnumTypeUpgrade.SOLAR, fakePlanet.getRover().getItemStack())) {
                    solar = SpaceUpgradeSystem.system.getModules((EnumTypeUpgrade)EnumTypeUpgrade.HEATER, (ItemStack)fakePlanet.getRover().getItemStack()).number;
                }
                if (solar != 0) {
                    ElectricItem.manager.charge(fakePlanet.getRover().getItemStack(), 30 * solar, Integer.MAX_VALUE, true, false);
                }
                resourceList = this.fakePlanetListMap.get(fakePlanet);
                resourceList.add(this.getBaseResource(fakePlanet, (int)fakePlanet.getData().getPercent()));
                if (fakePlanet.getTime() != 0) continue;
                fakePlanet.setEnd();
                if (!this.MapEntityPlayer.containsKey(fakePlanet.getPlayer()) || (table = this.MapEntityPlayer.get(fakePlanet.getPlayer())).getContainerBlock() == null) continue;
                for (IBaseResource resource : resourceList) {
                    table.getContainerBlock().getSlotOutput().add(resource.getItemStack());
                }
                if (!table.getSpaceBody().get(fakePlanet.getPlanet()).getAuto()) {
                    table.getContainerBlock().getSlotOutput().add(fakePlanet.getRover().getItemStack());
                }
                this.fakePlanetListMap.remove(fakePlanet);
                this.fakePlanetList.remove(fakePlanet);
                fakePlanet.getData().addInformation();
                table.getSpaceBody().get(fakePlanet.getPlanet()).setOperation(EnumOperation.SUCCESS);
                this.removeFakeBodyFromPlayer(table, fakePlanet.getPlanet());
                if (table.getSpaceBody().get(fakePlanet.getPlanet()).getAuto()) {
                    SpaceNet.instance.getResearchSystem().sendingOperation(fakePlanet.getRover(), fakePlanet.getPlanet(), table);
                }
                fakePlanet.remove();
                continue;
            }
            fakePlanet.setEnd();
            if (!this.MapEntityPlayer.containsKey(fakePlanet.getPlayer()) || (table2 = this.MapEntityPlayer.get(fakePlanet.getPlayer())).getContainerBlock() == null) continue;
            this.fakePlanetListMap.remove(fakePlanet);
            this.fakePlanetList.remove(fakePlanet);
            fakePlanet.getData().addInformation(Math.abs(fakePlanet.getTime() - 1800) / 1800);
            table2.getSpaceBody().get(fakePlanet.getPlanet()).setOperation(EnumOperation.FAIL);
            this.removeFakeBodyFromPlayer(table2, fakePlanet.getPlanet());
            fakePlanet.remove();
        }
        for (FakeSatellite fakeSatellite : this.fakeSatelliteList) {
            IResearchTable table3;
            if (ElectricItem.manager.getCharge(fakeSatellite.getRover().getItemStack()) >= 100.0) {
                ElectricItem.manager.use(fakeSatellite.getRover().getItemStack(), 100.0, null);
                fakeSatellite.setTime(1);
                int solar = 0;
                if (SpaceUpgradeSystem.system.hasModules(EnumTypeUpgrade.SOLAR, fakeSatellite.getRover().getItemStack())) {
                    solar = SpaceUpgradeSystem.system.getModules((EnumTypeUpgrade)EnumTypeUpgrade.HEATER, (ItemStack)fakeSatellite.getRover().getItemStack()).number;
                }
                if (solar != 0) {
                    ElectricItem.manager.charge(fakeSatellite.getRover().getItemStack(), 30 * solar, Integer.MAX_VALUE, true, false);
                }
                if (fakeSatellite.getTime() % 150 != 0) continue;
                if (!this.fakeSatelliteListMap.containsKey(fakeSatellite)) {
                    this.fakeSatelliteListMap.put(fakeSatellite, new ArrayList());
                    continue;
                }
                resourceList = this.fakeSatelliteListMap.get(fakeSatellite);
                resourceList.add(this.getBaseResource(fakeSatellite, (int)fakeSatellite.getData().getPercent()));
                if (fakeSatellite.getTime() != 0) continue;
                fakeSatellite.setEnd();
                if (!this.MapEntityPlayer.containsKey(fakeSatellite.getPlayer()) || (table = this.MapEntityPlayer.get(fakeSatellite.getPlayer())).getContainerBlock() == null) continue;
                for (IBaseResource resource : resourceList) {
                    table.getContainerBlock().getSlotOutput().add(resource.getItemStack());
                }
                if (!table.getSpaceBody().get(fakeSatellite.getSatellite()).getAuto()) {
                    table.getContainerBlock().getSlotOutput().add(fakeSatellite.getRover().getItemStack());
                }
                this.fakeSatelliteListMap.remove(fakeSatellite);
                this.fakeSatelliteList.remove(fakeSatellite);
                fakeSatellite.getData().addInformation();
                table.getSpaceBody().get(fakeSatellite.getSatellite()).setOperation(EnumOperation.SUCCESS);
                this.removeFakeBodyFromPlayer(table, fakeSatellite.getSatellite());
                if (table.getSpaceBody().get(fakeSatellite.getSatellite()).getAuto()) {
                    SpaceNet.instance.getResearchSystem().sendingOperation(fakeSatellite.getRover(), fakeSatellite.getSatellite(), table);
                }
                fakeSatellite.remove();
                continue;
            }
            fakeSatellite.setEnd();
            if (!this.MapEntityPlayer.containsKey(fakeSatellite.getPlayer()) || (table3 = this.MapEntityPlayer.get(fakeSatellite.getPlayer())).getContainerBlock() == null) continue;
            this.fakeSatelliteListMap.remove(fakeSatellite);
            this.fakeSatelliteList.remove(fakeSatellite);
            fakeSatellite.getData().addInformation(Math.abs(fakeSatellite.getTime() - 1800) / 1800);
            table3.getSpaceBody().get(fakeSatellite.getSatellite()).setOperation(EnumOperation.FAIL);
            this.removeFakeBodyFromPlayer(table3, fakeSatellite.getSatellite());
            fakeSatellite.remove();
        }
        for (FakeAsteroid fakeAsteroid : this.fakeAsteroids) {
            IResearchTable table4;
            if (ElectricItem.manager.getCharge(fakeAsteroid.getRover().getItemStack()) >= 100.0) {
                fakeAsteroid.setTime(1);
                ElectricItem.manager.use(fakeAsteroid.getRover().getItemStack(), 100.0, null);
                if (fakeAsteroid.getTime() % 150 != 0) continue;
                if (!this.fakeAsteroidListMap.containsKey(fakeAsteroid)) {
                    this.fakeAsteroidListMap.put(fakeAsteroid, new ArrayList());
                    continue;
                }
                int solar = 0;
                if (SpaceUpgradeSystem.system.hasModules(EnumTypeUpgrade.SOLAR, fakeAsteroid.getRover().getItemStack())) {
                    solar = SpaceUpgradeSystem.system.getModules((EnumTypeUpgrade)EnumTypeUpgrade.HEATER, (ItemStack)fakeAsteroid.getRover().getItemStack()).number;
                }
                if (solar != 0) {
                    ElectricItem.manager.charge(fakeAsteroid.getRover().getItemStack(), 30 * solar, Integer.MAX_VALUE, true, false);
                }
                resourceList = this.fakeAsteroidListMap.get(fakeAsteroid);
                resourceList.add(this.getBaseResource(fakeAsteroid, (int)fakeAsteroid.getData().getPercent()));
                if (fakeAsteroid.getTime() != 0) continue;
                fakeAsteroid.setEnd();
                if (!this.MapEntityPlayer.containsKey(fakeAsteroid.getPlayer()) || (table = this.MapEntityPlayer.get(fakeAsteroid.getPlayer())).getContainerBlock() == null) continue;
                for (IBaseResource resource : resourceList) {
                    table.getContainerBlock().getSlotOutput().add(resource.getItemStack());
                }
                if (!table.getSpaceBody().get(fakeAsteroid.getAsteroid()).getAuto()) {
                    table.getContainerBlock().getSlotOutput().add(fakeAsteroid.getRover().getItemStack());
                }
                this.fakeAsteroidListMap.remove(fakeAsteroid);
                this.fakeAsteroids.remove(fakeAsteroid);
                fakeAsteroid.getData().addInformation();
                table.getSpaceBody().get(fakeAsteroid.getAsteroid()).setOperation(EnumOperation.SUCCESS);
                this.removeFakeBodyFromPlayer(table, fakeAsteroid.getAsteroid());
                if (table.getSpaceBody().get(fakeAsteroid.getAsteroid()).getAuto()) {
                    SpaceNet.instance.getResearchSystem().sendingOperation(fakeAsteroid.getRover(), fakeAsteroid.getAsteroid(), table);
                }
                fakeAsteroid.remove();
                continue;
            }
            fakeAsteroid.setEnd();
            if (!this.MapEntityPlayer.containsKey(fakeAsteroid.getPlayer()) || (table4 = this.MapEntityPlayer.get(fakeAsteroid.getPlayer())).getContainerBlock() == null) continue;
            this.fakeAsteroidListMap.remove(fakeAsteroid);
            this.fakeAsteroids.remove(fakeAsteroid);
            fakeAsteroid.getData().addInformation(Math.abs(fakeAsteroid.getTime() - 1800) / 1800);
            table4.getSpaceBody().get(fakeAsteroid.getAsteroid()).setOperation(EnumOperation.FAIL);
            this.removeFakeBodyFromPlayer(table4, fakeAsteroid.getAsteroid());
            fakeAsteroid.remove();
        }
    }

    @Override
    public List<FakeSatellite> getFakeSatelliteList() {
        return this.fakeSatelliteList;
    }

    @Override
    public void addFakeSatellite(FakeSatellite satellite) {
        this.fakeSatelliteList.add(satellite);
    }

    @Override
    public boolean cadAddFakeSatellite(FakeSatellite satellite) {
        if (!this.fakeSatelliteList.contains(satellite)) {
            int[] temperature_mod;
            if (satellite.getSatellite().getPressure() && !SpaceUpgradeSystem.system.hasModules(EnumTypeUpgrade.PRESSURE, satellite.getRover().getItemStack())) {
                return false;
            }
            int temperature = satellite.getSatellite().getTemperature();
            return temperature < (temperature_mod = this.getLimitTemperatureFromRovers(satellite.getRover()))[0] && temperature > temperature_mod[1];
        }
        return false;
    }

    @Override
    public boolean canAddFakeAsteroid(FakeAsteroid asteroid) {
        if (!this.fakeAsteroids.contains(asteroid)) {
            int[] temperature_mod;
            int temperature = asteroid.getAsteroid().getTemperature();
            if (temperature >= (temperature_mod = this.getLimitTemperatureFromRovers(asteroid.getRover()))[0] || temperature <= temperature_mod[1]) {
                return false;
            }
            double distance = asteroid.getAsteroid().getDistanceFromStar();
            double distance_min = 2.0;
            double coef = 1.0;
            if (SpaceUpgradeSystem.system.getModules(EnumTypeUpgrade.ENGINE, asteroid.getRover().getItemStack()) != null) {
                coef = SpaceUpgradeSystem.system.getModules((EnumTypeUpgrade)EnumTypeUpgrade.ENGINE, (ItemStack)asteroid.getRover().getItemStack()).number;
            }
            if (distance < 2.0) {
                return distance > (distance_min /= 1.0 + coef);
            }
            return distance < (distance_min *= 1.0 + coef);
        }
        return false;
    }

    @Override
    public void addFakePlanet(FakePlanet planet) {
        this.fakePlanetList.add(planet);
    }

    @Override
    public void addFakeAsteroid(FakeAsteroid asteroid) {
        this.fakeAsteroids.add(asteroid);
    }

    @Override
    public void loadFakePlanet(FakePlanet planet) {
        this.fakePlanetList.add(planet);
    }

    @Override
    public void loadFakeSatellite(FakeSatellite satellite) {
        this.fakeSatelliteList.add(satellite);
    }

    @Override
    public void loadFakeAsteroid(FakeAsteroid asteroid) {
        this.fakeAsteroids.add(asteroid);
    }

    @Override
    public void loadDataFromPlayer(FakePlayer player) {
        if (!this.fakePlayerList.contains(player)) {
            this.addFakePlayer(player);
            NBTTagCompound tag = player.getTag().func_74775_l("space_iu");
            for (IPlanet iPlanet : SpaceNet.instance.getPlanetList()) {
                if (!tag.func_74764_b(iPlanet.getName())) continue;
                this.addFakePlanet(new FakePlanet(player, iPlanet.getName()));
            }
            for (ISatellite iSatellite : SpaceNet.instance.getSatelliteList()) {
                if (!tag.func_74764_b(iSatellite.getName())) continue;
                this.addFakeSatellite(new FakeSatellite(player, iSatellite.getName()));
            }
            for (IAsteroid iAsteroid : SpaceNet.instance.getAsteroidList()) {
                if (!tag.func_74764_b(iAsteroid.getName())) continue;
                this.addFakeAsteroid(new FakeAsteroid(player, iAsteroid.getName()));
            }
        }
    }

    @Override
    public void unloadDataFromPlayer(FakePlayer player) {
        for (FakePlanet planet : this.fakePlanetList) {
            planet.writeNBT(this.fakePlanetListMap.get(planet));
        }
        for (FakeSatellite satellite : this.fakeSatelliteList) {
            satellite.writeNBT(this.fakeSatelliteListMap.get(satellite));
        }
    }

    @Override
    public int[] getLimitTemperatureFromRovers(IRovers rover) {
        int max_temperature = 100;
        int min_temperature = -50;
        int cooler_mod = 0;
        int heater_mod = 0;
        if (SpaceUpgradeSystem.system.getModules(EnumTypeUpgrade.COOLER, rover.getItemStack()) != null) {
            cooler_mod = SpaceUpgradeSystem.system.getModules((EnumTypeUpgrade)EnumTypeUpgrade.COOLER, (ItemStack)rover.getItemStack()).number;
        }
        if (SpaceUpgradeSystem.system.getModules(EnumTypeUpgrade.HEATER, rover.getItemStack()) != null) {
            heater_mod = SpaceUpgradeSystem.system.getModules((EnumTypeUpgrade)EnumTypeUpgrade.HEATER, (ItemStack)rover.getItemStack()).number;
        }
        int[] temperatures = new int[]{max_temperature += 100 * heater_mod, min_temperature -= 75 * cooler_mod};
        return temperatures;
    }

    @Override
    public boolean cadAddFakePlanet(FakePlanet planet) {
        if (!this.fakePlanetList.contains(planet)) {
            int[] temperature_mod;
            if (planet.getPlanet().getPressure() && !SpaceUpgradeSystem.system.hasModules(EnumTypeUpgrade.PRESSURE, planet.getRover().getItemStack())) {
                return false;
            }
            int temperature = planet.getPlanet().getTemperature();
            if (temperature >= (temperature_mod = this.getLimitTemperatureFromRovers(planet.getRover()))[0] || temperature <= temperature_mod[1]) {
                return false;
            }
            double distance = planet.getPlanet().getDistanceFromStar();
            double distance_min = 2.0;
            double coef = 1.0;
            if (SpaceUpgradeSystem.system.getModules(EnumTypeUpgrade.ENGINE, planet.getRover().getItemStack()) != null) {
                coef = SpaceUpgradeSystem.system.getModules((EnumTypeUpgrade)EnumTypeUpgrade.ENGINE, (ItemStack)planet.getRover().getItemStack()).number;
            }
            if (distance < 2.0) {
                return distance > (distance_min /= 1.0 + coef);
            }
            return distance < (distance_min *= 1.0 + coef);
        }
        return false;
    }

    @Override
    public IRovers getRoversFromPlanet(FakePlanet planet) {
        return planet.getRover();
    }

    @Override
    public IRovers getRoversFromSatellite(FakeSatellite satellite) {
        return satellite.getRover();
    }

    @Override
    public IRovers getRoversFromAsteroid(FakeAsteroid asteroid) {
        return asteroid.getRover();
    }

    @Override
    public IBaseResource getBaseResource(FakePlanet planet, int percent) {
        List<IBaseResource> list = planet.getPlanet().getResources();
        ArrayList<IBaseResource> newlist = new ArrayList<IBaseResource>();
        for (IBaseResource resource : list) {
            if (resource.getChance() > percent || resource.getChance() <= this.rand.nextInt(resource.getMaxChance())) continue;
            newlist.add(resource);
        }
        int chance = this.rand.nextInt(newlist.size());
        return (IBaseResource)newlist.get(chance);
    }

    @Override
    public IBaseResource getBaseResource(FakeSatellite satellite, int percent) {
        List<IBaseResource> list = satellite.getSatellite().getResources();
        ArrayList<IBaseResource> newlist = new ArrayList<IBaseResource>();
        for (IBaseResource resource : list) {
            if (resource.getChance() > percent || resource.getChance() <= this.rand.nextInt(resource.getMaxChance())) continue;
            newlist.add(resource);
        }
        int chance = this.rand.nextInt(newlist.size());
        return (IBaseResource)newlist.get(chance);
    }

    @Override
    public IBaseResource getBaseResource(FakeAsteroid planet, int percent) {
        List<IBaseResource> list = planet.getAsteroid().getResources();
        ArrayList<IBaseResource> newlist = new ArrayList<IBaseResource>();
        for (IBaseResource resource : list) {
            if (resource.getChance() > percent || resource.getChance() <= this.rand.nextInt(resource.getMaxChance())) continue;
            newlist.add(resource);
        }
        int chance = this.rand.nextInt(newlist.size());
        return (IBaseResource)newlist.get(chance);
    }

    @Override
    public void unload() {
        this.fakePlanetList.clear();
        this.fakeSatelliteList.clear();
        this.fakePlanetListMap.clear();
        this.fakeSatelliteListMap.clear();
        this.entityPlayerListMap.clear();
        this.MapEntityPlayer.clear();
        this.fakePlayerList.clear();
        this.fakePlayerMapMap.clear();
        this.fakeBodyMap.clear();
        this.fakeAsteroids.clear();
        this.fakeAsteroidListMap.clear();
    }
}

