/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.fakebody;

import com.denfop.api.space.BaseResource;
import com.denfop.api.space.IAsteroid;
import com.denfop.api.space.IBaseResource;
import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.fakebody.Data;
import com.denfop.api.space.fakebody.FakePlayer;
import com.denfop.api.space.fakebody.IData;
import com.denfop.api.space.fakebody.IFakeAsteroid;
import com.denfop.api.space.rovers.EnumTypeUpgrade;
import com.denfop.api.space.rovers.IRovers;
import com.denfop.api.space.rovers.IRoversItem;
import com.denfop.api.space.rovers.Rovers;
import com.denfop.api.space.upgrades.SpaceUpgradeSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class FakeAsteroid
implements IFakeAsteroid {
    private FakePlayer player;
    private IAsteroid planet;
    private IRovers rovers;
    private IData data;
    private int time;
    private boolean end;

    public FakeAsteroid(FakePlayer player, IAsteroid planet, IRovers rovers, IData data) {
        this.player = player;
        this.planet = planet;
        this.rovers = rovers;
        int temp = SpaceUpgradeSystem.system.getModules(EnumTypeUpgrade.PROTECTION, this.rovers.getItemStack()) != null ? SpaceUpgradeSystem.system.getModules((EnumTypeUpgrade)EnumTypeUpgrade.PROTECTION, (ItemStack)this.rovers.getItemStack()).number * 600 : 0;
        this.time = 1800 + temp;
        this.data = data;
        this.end = false;
    }

    public FakeAsteroid(FakePlayer player, String name) {
        this.readNBT(player, name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FakeAsteroid that = (FakeAsteroid)o;
        return Objects.equals(this.player, that.player) && Objects.equals(this.planet, that.planet);
    }

    @Override
    public void setEnd() {
        assert (!this.end);
        this.end = true;
    }

    @Override
    public boolean getEnd() {
        return this.end;
    }

    @Override
    public IAsteroid getAsteroid() {
        return this.planet;
    }

    @Override
    public FakePlayer getPlayer() {
        return this.player;
    }

    @Override
    public IRovers getRover() {
        return this.rovers;
    }

    @Override
    public int getTime() {
        return this.time;
    }

    @Override
    public void setTime(int time) {
        assert (this.time > 0);
        this.time -= time;
    }

    @Override
    public IData getData() {
        return this.data;
    }

    @Override
    public boolean matched(IBody body) {
        return this.planet.getName().equals(body.getName());
    }

    @Override
    public void readNBT(FakePlayer player, String name) {
        this.player = player;
        NBTTagCompound nbt = player.getTag().func_74775_l("space_iu");
        this.planet = (IAsteroid)SpaceNet.instance.getBodyFromName(name);
        NBTTagCompound nbt1 = nbt.func_74775_l(this.planet.getName());
        this.time = nbt1.func_74762_e("time");
        this.end = nbt1.func_74767_n("end");
        NBTTagCompound rovers_tag = nbt1.func_74775_l("rovers");
        ItemStack rover = new ItemStack(rovers_tag);
        this.rovers = new Rovers((IRoversItem)rover.func_77973_b(), rover);
        this.data = new Data(player, this.planet);
        ArrayList<IBaseResource> list = new ArrayList<IBaseResource>();
        NBTTagCompound resources_tag = nbt1.func_74775_l("resource");
        int col = resources_tag.func_74762_e("resource");
        for (int i = 0; i < col; ++i) {
            list.add(new BaseResource(new ItemStack((NBTTagCompound)resources_tag.func_74781_a("resource" + i)), this.planet));
        }
        SpaceNet.instance.getFakeSpaceSystem().loadFakeBody(this, list, this.player);
    }

    @Override
    public void writeNBT(List<IBaseResource> list) {
        NBTTagCompound nbt;
        if (!this.player.getTag().func_74764_b("space_iu")) {
            nbt = new NBTTagCompound();
            this.player.getTag().func_74782_a("space_iu", (NBTBase)nbt);
        }
        nbt = this.player.getTag().func_74775_l("space_iu");
        NBTTagCompound nbt1 = new NBTTagCompound();
        nbt1.func_74768_a("time", this.time);
        nbt1.func_74757_a("end", this.end);
        NBTTagCompound rovers_tag = new NBTTagCompound();
        this.rovers.getItemStack().func_77955_b(rovers_tag);
        nbt1.func_74782_a("rovers", (NBTBase)rovers_tag);
        NBTTagCompound resources = new NBTTagCompound();
        for (int i = 0; i < list.size(); ++i) {
            resources.func_74782_a("resource" + i, (NBTBase)list.get(i).getItemStack().func_77955_b(new NBTTagCompound()));
        }
        resources.func_74768_a("col", list.size());
        nbt1.func_74782_a("resource", (NBTBase)resources);
        nbt.func_74782_a(this.planet.getName(), (NBTBase)nbt1);
    }

    @Override
    public void remove() {
        NBTTagCompound nbt = this.player.getTag().func_74775_l("space_iu");
        nbt.func_82580_o(this.planet.getName());
    }
}

