/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.fakebody;

import com.denfop.api.space.IBody;
import com.denfop.api.space.fakebody.FakePlayer;
import com.denfop.api.space.fakebody.IData;
import com.denfop.utils.ModUtils;
import java.util.Objects;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class Data
implements IData {
    private final FakePlayer player;
    private final IBody body;
    private double percent;

    public Data(FakePlayer player, IBody body) {
        this.player = player;
        this.body = body;
        this.init(body);
    }

    private void init(IBody body) {
        NBTTagCompound nbt = this.player.getTag();
        if (nbt.func_74764_b("space")) {
            NBTTagCompound nbt1 = nbt.func_74775_l("space");
            this.percent = nbt1.func_74769_h(body.getName().toLowerCase());
        } else {
            NBTTagCompound nbt1 = ModUtils.nbt();
            this.percent = 0.0;
            nbt1.func_74780_a(body.getName().toLowerCase(), 0.0);
            nbt.func_74782_a("space", (NBTBase)nbt1);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Data data = (Data)o;
        return Objects.equals(this.player, data.player) && Objects.equals(this.body, data.body);
    }

    @Override
    public double getPercent() {
        return this.percent;
    }

    @Override
    public void addInformation() {
        NBTTagCompound nbt = this.player.getTag();
        NBTTagCompound nbt1 = nbt.func_74775_l("space");
        nbt1.func_74780_a(this.body.getName().toLowerCase(), Math.min(this.percent + 1.0, 100.0));
    }

    @Override
    public void setInformation(double information) {
        NBTTagCompound nbt = this.player.getTag();
        NBTTagCompound nbt1 = nbt.func_74775_l("space");
        nbt1.func_74780_a(this.body.getName().toLowerCase(), Math.min(information, 100.0));
    }

    @Override
    public void addInformation(double information) {
        NBTTagCompound nbt = this.player.getTag();
        NBTTagCompound nbt1 = nbt.func_74775_l("space");
        nbt1.func_74780_a(this.body.getName().toLowerCase(), Math.min(this.percent + information, 100.0));
    }
}

