/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies;

import com.denfop.api.space.colonies.Building;
import com.denfop.api.space.colonies.EnumProblems;
import com.denfop.api.space.colonies.IColony;
import com.denfop.api.space.colonies.IColonyStorage;
import com.denfop.api.space.colonies.IStorage;
import com.denfop.api.space.colonies.Storage;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class StorageBuilding
extends Building
implements IColonyStorage {
    boolean work;
    IStorage storage;
    int energy;
    int peoples;

    public StorageBuilding(String name, IColony colonie) {
        super(name, colonie);
        this.storage = new Storage(this);
        this.energy = 10;
        this.peoples = 5;
        this.getColony().addStorage(this.storage);
        this.getColony().addNeededWorkers(this.peoples);
        this.getColony().addConsumeEnergy(this.energy);
        this.work = true;
    }

    public StorageBuilding(NBTTagCompound tag, IColony colonie) {
        super(tag.func_74779_i("name"), colonie);
        this.peoples = tag.func_74762_e("people");
        this.energy = tag.func_74762_e("energy");
        this.work = tag.func_74767_n("work");
        this.storage = new Storage(tag.func_74775_l("storage"), this);
        this.getColony().addStorage(this.storage);
        this.getColony().addNeededWorkers(this.peoples);
        this.getColony().addConsumeEnergy(this.energy);
    }

    @Override
    public NBTTagCompound writeTag(NBTTagCompound tag) {
        super.writeTag(tag);
        tag.func_74768_a("people", this.peoples);
        tag.func_74768_a("energy", this.energy);
        tag.func_74757_a("work", this.work);
        tag.func_74778_a("type", "storage");
        tag.func_74782_a("storage", (NBTBase)this.getStorage().writeNBT(new NBTTagCompound()));
        return tag;
    }

    @Override
    public IStorage getStorage() {
        return this.storage;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public int getPeoples() {
        return this.peoples;
    }

    @Override
    public boolean getWork() {
        return this.work;
    }

    @Override
    public void setWork(boolean setWork) {
        this.work = setWork;
    }

    @Override
    public void work() {
        if (this.getColony().getEnergy() < this.getEnergy()) {
            this.getColony().useEnergy(this.getEnergy());
            this.getColony().getProblems().remove((Object)EnumProblems.ENERGY);
            if (!this.getWork()) {
                this.setWork(true);
            }
        } else {
            if (!this.getColony().getProblems().contains((Object)EnumProblems.ENERGY)) {
                this.getColony().getProblems().add(EnumProblems.ENERGY);
            }
            if (this.getWork()) {
                this.setWork(false);
            }
        }
    }

    @Override
    public void remove() {
        this.getColony().removeStorage(this.storage);
        this.getColony().removeNeededWorkers(this.peoples);
        this.getColony().removeConsumeEnergy(10);
    }
}

