/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies;

import com.denfop.api.space.colonies.Building;
import com.denfop.api.space.colonies.EnumProblems;
import com.denfop.api.space.colonies.IColony;
import com.denfop.api.space.colonies.IOxygenFactory;
import net.minecraft.nbt.NBTTagCompound;

public class OxygenFactory
extends Building
implements IOxygenFactory {
    private final int max;
    private final int generation;
    private final int people;
    private final int energy;

    public OxygenFactory(String name, IColony colonie) {
        super(name, colonie);
        this.max = 5000;
        this.generation = 80;
        this.people = 0;
        this.energy = 10;
        this.getColony().addNeededWorkers(this.getPeople());
        this.getColony().addConsumeEnergy(this.getEnergy());
        this.getColony().addMaxOxygen(this.getMax());
        this.getColony().getOxygenFactory().add(this);
    }

    public OxygenFactory(String name, IColony colonie, int people) {
        super(name, colonie);
        this.max = 5000;
        this.generation = 60;
        this.people = people;
        this.energy = 10;
        this.getColony().addNeededWorkers(this.getPeople());
        this.getColony().addConsumeEnergy(this.getEnergy());
        this.getColony().addMaxOxygen(this.getMax());
        this.getColony().getOxygenFactory().add(this);
    }

    public OxygenFactory(NBTTagCompound tag, IColony colonie) {
        super(tag.func_74779_i("name"), colonie);
        this.max = tag.func_74762_e("max");
        this.generation = tag.func_74762_e("generation");
        this.people = tag.func_74762_e("people");
        this.energy = tag.func_74762_e("energy");
        this.getColony().addNeededWorkers(this.getPeople());
        this.getColony().addConsumeEnergy(this.getEnergy());
        this.getColony().addMaxOxygen(this.getMax());
        this.getColony().getOxygenFactory().add(this);
    }

    @Override
    public int getMax() {
        return this.max;
    }

    @Override
    public int getGeneration() {
        return this.generation;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public boolean needWorkers() {
        return this.getPeople() > 0;
    }

    @Override
    public int getPeople() {
        return this.people;
    }

    @Override
    public void work() {
        if (this.getColony().getOxygen() < this.getColony().getMaxOxygen()) {
            if (this.getColony().getEnergy() > this.getEnergy()) {
                int temp = Math.min(this.getGeneration(), this.getColony().getMaxOxygen() - this.getColony().getEnergy());
                this.getColony().addOxygen(temp);
            } else if (!this.getColony().getProblems().contains((Object)EnumProblems.ENERGY)) {
                this.getColony().getProblems().add(EnumProblems.ENERGY);
            }
        }
    }

    @Override
    public NBTTagCompound writeTag(NBTTagCompound tag) {
        super.writeTag(tag);
        tag.func_74768_a("max", this.max);
        tag.func_74768_a("people", this.people);
        tag.func_74768_a("energy", this.energy);
        tag.func_74768_a("generation", this.generation);
        tag.func_74778_a("type", "oxygenfactory");
        return tag;
    }

    @Override
    public void remove() {
        this.getColony().removeNeededWorkers(this.getPeople());
        this.getColony().removeConsumeEnergy(this.getEnergy());
        this.getColony().decreaseOxygen(this.getMax());
        this.getColony().getOxygenFactory().remove(this);
    }
}

