/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies;

import com.denfop.blocks.FluidName;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public enum EnumFluidFactory {
    LAVA(10, new FluidStack(FluidRegistry.LAVA, 1), 5, 10),
    WATER(10, new FluidStack(FluidRegistry.WATER, 1), 4, 8),
    OIL(12, new FluidStack(FluidName.fluidneft.getInstance(), 1), 6, 12),
    PETROL(14, new FluidStack(FluidName.fluidbenz.getInstance(), 1), 8, 16),
    DIESEL(14, new FluidStack(FluidName.fluiddizel.getInstance(), 1), 8, 16),
    COOLANT(14, new FluidStack(FluidName.fluidcoolant.getInstance(), 1), 8, 16);

    private final int energy;
    private final FluidStack stack;
    private final int needPeople;
    private final int needProtection;

    private EnumFluidFactory(int energy, FluidStack stack, int needPeople, int needProtection) {
        this.energy = energy;
        this.stack = stack;
        this.needPeople = needPeople;
        this.needProtection = needProtection;
    }

    public static EnumFluidFactory getID(int id) {
        return EnumFluidFactory.values()[id % EnumFluidFactory.values().length];
    }

    public int getEnergy() {
        return this.energy;
    }

    public FluidStack getStack() {
        return this.stack;
    }

    public int getNeedPeople() {
        return this.needPeople;
    }

    public int getNeedProtection() {
        return this.needProtection;
    }
}

