/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies;

import com.denfop.api.space.colonies.Building;
import com.denfop.api.space.colonies.EnumTypeSolarPanel;
import com.denfop.api.space.colonies.IColony;
import com.denfop.api.space.colonies.IColonyPanelFactory;
import net.minecraft.nbt.NBTTagCompound;

public class ColonyPanelFactory
extends Building
implements IColonyPanelFactory {
    private final EnumTypeSolarPanel type;

    public ColonyPanelFactory(String name, IColony colonie, EnumTypeSolarPanel type) {
        super(name, colonie);
        this.type = type;
        this.getColony().addNeededWorkers(this.type.getPeople());
        this.getColony().addMaxEnergy(5000);
    }

    public ColonyPanelFactory(NBTTagCompound tag, IColony colonie) {
        super(tag.func_74779_i("name"), colonie);
        this.type = EnumTypeSolarPanel.getID(tag.func_74762_e("id"));
        this.getColony().addNeededWorkers(this.type.getPeople());
        this.getColony().addMaxEnergy(5000);
    }

    @Override
    public int getGeneration() {
        return this.type.getGeneration();
    }

    @Override
    public int getPeople() {
        return this.type.getPeople();
    }

    @Override
    public EnumTypeSolarPanel getType() {
        return this.type;
    }

    @Override
    public void work() {
        if (this.getColony().getEnergy() < this.getColony().getMaxEnergy()) {
            int temp = Math.min(this.getGeneration(), this.getColony().getMaxEnergy() - this.getColony().getEnergy());
            this.getColony().addEnergy(temp);
        }
    }

    @Override
    public NBTTagCompound writeTag(NBTTagCompound tag) {
        super.writeTag(tag);
        tag.func_74778_a("type", "solar");
        tag.func_74768_a("id", this.getType().ordinal());
        return tag;
    }

    @Override
    public void remove() {
        this.getColony().removeNeededWorkers(this.type.getPeople());
        this.getColony().decreaseEnergy(5000);
    }
}

