/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies;

import com.denfop.api.space.colonies.Building;
import com.denfop.api.space.colonies.EnumHouses;
import com.denfop.api.space.colonies.EnumHousesLevel;
import com.denfop.api.space.colonies.EnumProblems;
import com.denfop.api.space.colonies.IBuildingHouse;
import com.denfop.api.space.colonies.IColony;
import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;

public class ColonyHouse
extends Building
implements IBuildingHouse {
    private final EnumHouses houses;
    private int timeToDecrease;
    private int peoples;

    public ColonyHouse(String name, EnumHouses houses, IColony colonie) {
        super(name, colonie);
        this.houses = houses;
        Random rand = new Random();
        this.peoples = rand.nextInt(houses.getMax() + 1);
        this.timeToDecrease = 60;
        this.getColony().addWorkers(this.getWorkers());
        this.getColony().addConsumeEnergy(this.getEnergy());
    }

    public ColonyHouse(NBTTagCompound tag, IColony colonie) {
        super(tag.func_74779_i("name"), colonie);
        int id = tag.func_74762_e("id");
        this.houses = EnumHouses.getID(id);
        this.peoples = tag.func_74762_e("people");
        this.timeToDecrease = tag.func_74762_e("timeToDecrease");
        this.getColony().addWorkers(this.getWorkers());
        this.getColony().addConsumeEnergy(this.getEnergy());
    }

    @Override
    public EnumHousesLevel getLevel() {
        return this.houses.getLevel();
    }

    @Override
    public int getPeople() {
        return this.peoples;
    }

    @Override
    public void setPeoples(int peoples) {
        this.peoples = peoples;
    }

    @Override
    public int getEnergy() {
        return this.houses.getEnergy();
    }

    @Override
    public int getMaxPeople() {
        return this.houses.getMax();
    }

    @Override
    public void addPeople(int peoples) {
        assert (this.peoples + peoples <= this.getMaxPeople());
        this.peoples += peoples;
    }

    @Override
    public int getWorkers() {
        return (int)((double)this.peoples * 0.7);
    }

    @Override
    public NBTTagCompound writeTag(NBTTagCompound tag) {
        super.writeTag(tag);
        tag.func_74778_a("type", "house");
        tag.func_74768_a("id", this.houses.ordinal());
        tag.func_74768_a("people", this.peoples);
        tag.func_74768_a("timeToDecrease", this.timeToDecrease);
        return tag;
    }

    @Override
    public void work() {
        int temp1;
        int temp;
        boolean problem = false;
        int max = this.getColony().getMaxWorkers();
        int need = this.getColony().getNeededWorkers();
        if (this.getColony().getEnergy() >= this.getEnergy()) {
            this.getColony().useEnergy(this.getEnergy());
            this.getColony().getProblems().remove((Object)EnumProblems.ENERGY);
            this.timeToDecrease = 60;
        } else {
            if (!this.getColony().getProblems().contains((Object)EnumProblems.ENERGY)) {
                this.getColony().getProblems().add(EnumProblems.ENERGY);
            }
            problem = true;
            --this.timeToDecrease;
            if (this.timeToDecrease == 0 && this.getPeople() > 0) {
                temp = this.getWorkers();
                this.addPeople(-1);
                temp1 = this.getWorkers();
                this.getColony().removeWorkers(temp - temp1);
                this.timeToDecrease = 60;
            }
        }
        if (this.houses.getConsumeOxygen() < this.getColony().getOxygen()) {
            if (!this.getColony().getProblems().contains((Object)EnumProblems.OXYGEN)) {
                this.getColony().getProblems().add(EnumProblems.OXYGEN);
            }
            if (!problem) {
                --this.timeToDecrease;
                if (this.timeToDecrease == 0 && this.getPeople() > 0) {
                    temp = this.getWorkers();
                    this.addPeople(-1);
                    temp1 = this.getWorkers();
                    this.getColony().removeWorkers(temp - temp1);
                    this.timeToDecrease = 60;
                }
                problem = true;
            }
        } else {
            this.getColony().useOxygen(this.houses.getConsumeOxygen());
        }
        if (!problem && (double)need * 1.5 > (double)max && this.getPeople() < this.getMaxPeople()) {
            temp = this.getWorkers();
            this.addPeople(1);
            temp1 = this.getWorkers();
            this.getColony().addWorkers(temp1 - temp);
            this.addPeople(1);
        }
    }

    @Override
    public void remove() {
        this.getColony().removeWorkers(this.getWorkers());
        this.getColony().removeConsumeEnergy(this.getEnergy());
    }
}

