/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space.colonies;

import com.denfop.api.space.IBody;
import com.denfop.api.space.SpaceNet;
import com.denfop.api.space.colonies.ColonyHouse;
import com.denfop.api.space.colonies.ColonyPanelFactory;
import com.denfop.api.space.colonies.EnumProblems;
import com.denfop.api.space.colonies.EnumTypeUpdate;
import com.denfop.api.space.colonies.Factory;
import com.denfop.api.space.colonies.FluidFactory;
import com.denfop.api.space.colonies.IBuildingHouse;
import com.denfop.api.space.colonies.IBuildingMining;
import com.denfop.api.space.colonies.IColony;
import com.denfop.api.space.colonies.IColonyBuilding;
import com.denfop.api.space.colonies.IOxygenFactory;
import com.denfop.api.space.colonies.IStorage;
import com.denfop.api.space.colonies.OxygenFactory;
import com.denfop.api.space.colonies.ProtectionBuilding;
import com.denfop.api.space.colonies.StorageBuilding;
import com.denfop.api.space.fakebody.FakePlayer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class Colony
implements IColony {
    private final IBody body;
    private final int level;
    private FakePlayer fakeplayer;
    private List<IColonyBuilding> list;
    private List<IBuildingHouse> buildingHouseList;
    private List<IBuildingMining> buildingMiningList;
    private List<IOxygenFactory> oxygenFactoriesList;
    private List<EnumProblems> enumProblemsList;
    private List<IStorage> storageList;
    private int energy = 0;
    private int maxenergy = 0;
    private int oxygen = 0;
    private int maxoxygen = 0;
    private int workers = 0;
    private int needworkers = 0;
    private int consume = 0;
    private int toDelete;
    private int protection;
    private int needprotection;

    public Colony(IBody body, FakePlayer player) {
        this.level = 1;
        this.body = body;
        this.list = new ArrayList<IColonyBuilding>();
        this.toDelete = 600;
        this.fakeplayer = player;
        this.enumProblemsList = new ArrayList<EnumProblems>();
        this.storageList = new ArrayList<IStorage>();
        this.buildingHouseList = new ArrayList<IBuildingHouse>();
        this.buildingMiningList = new ArrayList<IBuildingMining>();
        this.oxygenFactoriesList = new ArrayList<IOxygenFactory>();
    }

    public Colony(NBTTagCompound tag, FakePlayer fakeplayer) {
        this.level = tag.func_74762_e("level");
        this.body = SpaceNet.instance.getBodyFromName(tag.func_74779_i("name"));
        this.fakeplayer = fakeplayer;
        int size = tag.func_74762_e("col");
        block18: for (int i = 0; i < size; ++i) {
            String type;
            NBTTagCompound nbt = tag.func_74775_l("" + i);
            switch (type = nbt.func_74779_i("type")) {
                case "oxygenfactory": {
                    new OxygenFactory(nbt, (IColony)this);
                    continue block18;
                }
                case "storage": {
                    new StorageBuilding(nbt, (IColony)this);
                    continue block18;
                }
                case "house": {
                    new ColonyHouse(nbt, (IColony)this);
                    continue block18;
                }
                case "solar": {
                    new ColonyPanelFactory(nbt, (IColony)this);
                    continue block18;
                }
                case "factory": {
                    new Factory(nbt, (IColony)this);
                    continue block18;
                }
                case "protection": {
                    new ProtectionBuilding(nbt, (IColony)this);
                    continue block18;
                }
                case "fluidfactory": {
                    new FluidFactory(nbt, (IColony)this);
                }
            }
        }
    }

    @Override
    public int getProtection() {
        return this.protection;
    }

    @Override
    public void addProtection(int protection) {
        this.protection += protection;
    }

    @Override
    public void removeProtection(int protection) {
        this.protection -= protection;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void update(EnumTypeUpdate typeUpdate) {
    }

    @Override
    public boolean matched(IBody body) {
        return this.body == body;
    }

    @Override
    public IBody getBody() {
        return this.body;
    }

    @Override
    public FakePlayer getFakePlayer() {
        return this.fakeplayer;
    }

    @Override
    public void setFakePlayer(FakePlayer fakePlayer) {
        this.fakeplayer = fakePlayer;
    }

    @Override
    public List<EnumProblems> getProblems() {
        return this.enumProblemsList;
    }

    @Override
    public int getEnergy() {
        return this.energy;
    }

    @Override
    public int getMaxEnergy() {
        return this.maxenergy;
    }

    @Override
    public int getOxygen() {
        return this.oxygen;
    }

    @Override
    public int getNeededWorkers() {
        return this.needworkers;
    }

    @Override
    public void setNeededWorkers(int workers) {
        this.needworkers = workers;
    }

    @Override
    public void addNeededWorkers(int workers) {
        this.needworkers += workers;
    }

    @Override
    public void removeNeededWorkers(int workers) {
        this.needworkers -= workers;
    }

    @Override
    public List<IBuildingHouse> getHouse() {
        return this.buildingHouseList;
    }

    @Override
    public List<IBuildingMining> getMining() {
        return this.buildingMiningList;
    }

    @Override
    public List<IOxygenFactory> getOxygenFactory() {
        return this.oxygenFactoriesList;
    }

    @Override
    public int getTimeToDelete() {
        return this.toDelete;
    }

    @Override
    public void setTimeToDelete(int time) {
        this.toDelete = time;
    }

    @Override
    public void addTimeToDelete(int time) {
        this.toDelete += time;
    }

    @Override
    public int getMaxOxygen() {
        return this.maxoxygen;
    }

    @Override
    public int getMaxWorkers() {
        return this.workers;
    }

    @Override
    public void addWorkers(int workers) {
        this.workers += workers;
    }

    @Override
    public void removeWorkers(int workers) {
        this.workers -= workers;
    }

    @Override
    public void update() {
        if (this.enumProblemsList.size() > 0) {
            if (this.toDelete == 0) {
                SpaceNet.instance.getColonieNet().removeColony(this, this.getFakePlayer());
            } else {
                --this.toDelete;
            }
        } else {
            this.toDelete = 600;
        }
        if (this.workers < this.needworkers) {
            if (!this.enumProblemsList.contains((Object)EnumProblems.WORKERS)) {
                this.enumProblemsList.add(EnumProblems.WORKERS);
            }
            return;
        }
        for (IColonyBuilding building : this.list) {
            building.work();
        }
    }

    @Override
    public void useEnergy(int energy) {
        this.energy -= energy;
    }

    @Override
    public void decreaseEnergy(int energy) {
        this.maxenergy -= energy;
    }

    @Override
    public void useOxygen(int oxygen) {
        this.oxygen -= oxygen;
    }

    @Override
    public void decreaseOxygen(int oxygen) {
        this.maxoxygen -= oxygen;
    }

    @Override
    public void addOxygen(int oxygen) {
        this.oxygen += oxygen;
    }

    @Override
    public int getDemandedEnergy() {
        return this.maxenergy - this.energy;
    }

    @Override
    public int getDemandedOxygen() {
        return this.maxoxygen - this.oxygen;
    }

    @Override
    public void addEnergy(int energy) {
        this.energy += energy;
    }

    @Override
    public void addMaxOxygen(int oxygen) {
        this.oxygen += oxygen;
    }

    @Override
    public void addMaxEnergy(int energy) {
        this.maxenergy += energy;
    }

    @Override
    public void addConsumeEnergy(int energy) {
        this.consume += energy;
    }

    @Override
    public void removeConsumeEnergy(int energy) {
        this.consume -= energy;
    }

    @Override
    public int getConsume() {
        return this.consume;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.body.getName());
        tag.func_74768_a("level", this.level);
        tag.func_74768_a("col", this.list.size());
        for (int i = 0; i < this.list.size(); ++i) {
            tag.func_74782_a("" + i, (NBTBase)this.list.get(i).writeTag(new NBTTagCompound()));
        }
        return tag;
    }

    @Override
    public List<IColonyBuilding> getBuildingList() {
        return this.list;
    }

    @Override
    public void addBuilding(IColonyBuilding building) {
        this.list.add(building);
    }

    @Override
    public List<IStorage> getStorageList() {
        return this.storageList;
    }

    @Override
    public void addStorage(IStorage storage) {
        this.storageList.add(storage);
    }

    @Override
    public void removeStorage(IStorage storage) {
        this.storageList.remove(storage);
    }

    @Override
    public void addNeedProtection(int protection) {
        this.needprotection += protection;
    }

    @Override
    public void removeNeedProtection(int protection) {
        this.needprotection -= protection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Colony colony = (Colony)o;
        return this.fakeplayer.equals(colony.fakeplayer) && this.body.equals(colony.body);
    }
}

