/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.space;

import com.denfop.api.space.IAsteroid;
import com.denfop.api.space.IBaseResource;
import com.denfop.api.space.IBody;
import com.denfop.api.space.IPlanet;
import com.denfop.api.space.ISatellite;
import com.denfop.api.space.ISpaceNet;
import com.denfop.api.space.IStar;
import com.denfop.api.space.ISystem;
import com.denfop.api.space.colonies.ColonyNet;
import com.denfop.api.space.colonies.IColonyNet;
import com.denfop.api.space.fakebody.FakeSpaceSystemBase;
import com.denfop.api.space.fakebody.IFakeSpaceSystemBase;
import com.denfop.api.space.research.BaseSpaceResearchSystem;
import com.denfop.api.space.research.IResearchSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.MinecraftForge;

public class BaseSpaceSystem
implements ISpaceNet {
    public IColonyNet colonienet;
    public IFakeSpaceSystemBase spaceSystemBase;
    public IResearchSystem spaceResearch;
    Map<IBody, ISystem> systemIBodyMap;
    Map<IPlanet, List<ISatellite>> planetISatelliteMap = new HashMap<IPlanet, List<ISatellite>>();
    Map<IStar, List<IPlanet>> starListMap;
    Map<IPlanet, ISystem> systemIPlanetMap;
    Map<IStar, ISystem> systemIStarMap;
    List<IPlanet> planetList;
    List<IAsteroid> asteroidList;
    List<ISatellite> satelliteList;
    List<IStar> starList;
    List<ISystem> systemList;
    Map<String, IBody> bodyMap;
    List<IBody> bodies;

    public BaseSpaceSystem() {
        this.systemIBodyMap = new HashMap<IBody, ISystem>();
        this.systemIPlanetMap = new HashMap<IPlanet, ISystem>();
        this.systemIStarMap = new HashMap<IStar, ISystem>();
        this.systemList = new ArrayList<ISystem>();
        this.planetList = new ArrayList<IPlanet>();
        this.satelliteList = new ArrayList<ISatellite>();
        this.starListMap = new HashMap<IStar, List<IPlanet>>();
        this.starList = new ArrayList<IStar>();
        this.bodyMap = new HashMap<String, IBody>();
        this.bodies = new ArrayList<IBody>();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.spaceSystemBase = new FakeSpaceSystemBase();
        this.spaceResearch = new BaseSpaceResearchSystem();
        this.asteroidList = new ArrayList<IAsteroid>();
        this.colonienet = new ColonyNet();
    }

    @Override
    public IResearchSystem getResearchSystem() {
        return this.spaceResearch;
    }

    @Override
    public List<IAsteroid> getAsteroidList() {
        return this.asteroidList;
    }

    @Override
    public List<IBody> getBodyList() {
        return this.bodies;
    }

    @Override
    public IFakeSpaceSystemBase getFakeSpaceSystem() {
        return this.spaceSystemBase;
    }

    @Override
    public IBody getBodyFromName(String name) {
        return this.bodyMap.get(name);
    }

    @Override
    public Map<String, IBody> getBodyMap() {
        return this.bodyMap;
    }

    @Override
    public IColonyNet getColonieNet() {
        return this.colonienet;
    }

    @Override
    public List<IPlanet> getPlanetList() {
        return this.planetList;
    }

    @Override
    public List<ISatellite> getSatelliteList() {
        return this.satelliteList;
    }

    @Override
    public void addPlanet(IPlanet planet) {
        this.planetList.add(planet);
        this.planetISatelliteMap.put(planet, planet.getSatelliteList());
        this.systemIPlanetMap.put(planet, planet.getSystem());
        this.systemIBodyMap.put(planet, planet.getSystem());
        this.bodyMap.put(planet.getName(), planet);
        this.bodies.add(planet);
        if (this.starListMap.containsKey(planet.getStar())) {
            List<IPlanet> planetList = this.starListMap.get(planet.getStar());
            planetList.add(planet);
            planet.getStar().getPlanetList().clear();
            planet.getStar().getPlanetList().addAll(planetList);
        }
    }

    @Override
    public void addAsteroid(IAsteroid asteroid) {
        this.asteroidList.add(asteroid);
        this.bodies.add(asteroid);
        this.systemIBodyMap.put(asteroid, asteroid.getSystem());
        this.bodyMap.put(asteroid.getName(), asteroid);
    }

    @Override
    public void addStar(IStar star) {
        this.starList.add(star);
        this.systemIStarMap.put(star, star.getSystem());
        this.starListMap.put(star, star.getPlanetList());
        this.systemIBodyMap.put(star, star.getSystem());
    }

    @Override
    public void addSatellite(ISatellite satellite) {
        this.satelliteList.add(satellite);
        this.systemIBodyMap.put(satellite, satellite.getSystem());
        this.bodyMap.put(satellite.getName(), satellite);
        this.bodies.add(satellite);
        if (this.planetISatelliteMap.containsKey(satellite.getPlanet())) {
            List<ISatellite> satelliteList = this.planetISatelliteMap.get(satellite.getPlanet());
            satelliteList.add(satellite);
            satellite.getPlanet().getSatelliteList().clear();
            satellite.getPlanet().getSatelliteList().addAll(satelliteList);
        }
    }

    @Override
    public void addSystem(ISystem system) {
        this.systemList.add(system);
    }

    @Override
    public void addResource(IBaseResource resource) {
        if (resource.getBody() instanceof IPlanet) {
            IPlanet planet = this.planetList.get(this.planetList.indexOf((IPlanet)resource.getBody()));
            planet.getResources().add(resource);
        }
        if (resource.getBody() instanceof ISatellite) {
            ISatellite satellite = this.satelliteList.get(this.satelliteList.indexOf((ISatellite)resource.getBody()));
            satellite.getResources().add(resource);
        }
        if (resource.getBody() instanceof IAsteroid) {
            IAsteroid asteroid = this.asteroidList.get(this.asteroidList.indexOf((IAsteroid)resource.getBody()));
            asteroid.getResources().add(resource);
        }
    }
}

