/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.research.main;

import com.denfop.api.research.main.EnumLeveling;
import com.denfop.api.research.main.ILevelSystem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;

public class BaseLevelSystem
implements ILevelSystem {
    public final EntityPlayer player;
    public final int[] levels;
    public final int[] levels_points;
    public int[] levels_next;

    public BaseLevelSystem(EntityPlayer player) {
        this.player = player;
        this.levels = new int[EnumLeveling.values().length];
        this.levels_points = new int[EnumLeveling.values().length];
        this.levels_next = new int[EnumLeveling.values().length];
        this.init();
    }

    public BaseLevelSystem(EntityPlayer player, NBTTagCompound tagCompound) {
        this.player = player;
        this.levels = new int[EnumLeveling.values().length];
        this.levels_points = new int[EnumLeveling.values().length];
        this.levels_next = new int[EnumLeveling.values().length];
        this.init(tagCompound);
    }

    private void init() {
        NBTTagCompound nbt = this.player.getEntityData();
        for (EnumLeveling leveling : EnumLeveling.values()) {
            this.levels[leveling.ordinal()] = nbt.func_74762_e("iu.level." + leveling.name().toLowerCase());
            this.levels_points[leveling.ordinal()] = nbt.func_74762_e("iu.level_points." + leveling.name().toLowerCase());
            this.levels_next[leveling.ordinal()] = this.levels_points[leveling.ordinal()] * 40 + 20 - this.levels[leveling.ordinal()];
        }
    }

    private void init(NBTTagCompound tagCompound) {
        for (EnumLeveling leveling : EnumLeveling.values()) {
            this.levels[leveling.ordinal()] = tagCompound.func_74762_e("iu.level." + leveling.name().toLowerCase());
            this.levels_points[leveling.ordinal()] = tagCompound.func_74762_e("iu.level_points." + leveling.name().toLowerCase());
            this.levels_next[leveling.ordinal()] = this.levels_points[leveling.ordinal()] * 40 + 20 - this.levels[leveling.ordinal()];
        }
        NBTTagCompound nbt = this.player.getEntityData();
        for (EnumLeveling leveling : EnumLeveling.values()) {
            nbt.func_74768_a("iu.level." + leveling.name().toLowerCase(), this.levels[leveling.ordinal()]);
            nbt.func_74768_a("iu.level_points." + leveling.name().toLowerCase(), this.levels_points[leveling.ordinal()]);
        }
    }

    @Override
    public int getLevel(EnumLeveling enumLeveling) {
        return this.levels_points[enumLeveling.ordinal()];
    }

    @Override
    public void setLevel(EnumLeveling enumLeveling, int level) {
        this.levels[enumLeveling.ordinal()] = level;
        NBTTagCompound nbt = this.player.getEntityData();
        nbt.func_74768_a("iu.level." + enumLeveling.name().toLowerCase(), this.levels[enumLeveling.ordinal()]);
        this.levels_points[enumLeveling.ordinal()] = this.getLevelPoint(enumLeveling);
        if (enumLeveling != EnumLeveling.BASE) {
            this.setOwnBaseLevel(enumLeveling, level);
        }
    }

    @Override
    public void addLevel(EnumLeveling enumLeveling, int level) {
        int n = enumLeveling.ordinal();
        this.levels[n] = this.levels[n] + level;
        NBTTagCompound nbt = this.player.getEntityData();
        while (this.levels[enumLeveling.ordinal()] > this.levels_points[enumLeveling.ordinal()] * 40 + 20) {
            int n2 = enumLeveling.ordinal();
            this.levels[n2] = this.levels[n2] - (this.levels_points[enumLeveling.ordinal()] * 40 + 20);
            int n3 = enumLeveling.ordinal();
            this.levels_points[n3] = this.levels_points[n3] + 1;
            this.levels_next[enumLeveling.ordinal()] = this.levels_points[enumLeveling.ordinal()] * 40 + 20 - this.levels[enumLeveling.ordinal()];
        }
        nbt.func_74768_a("iu.level." + enumLeveling.name().toLowerCase(), this.levels[enumLeveling.ordinal()]);
        nbt.func_74768_a("iu.level_points." + enumLeveling.name().toLowerCase(), this.levels_points[enumLeveling.ordinal()]);
        if (enumLeveling != EnumLeveling.BASE && enumLeveling != EnumLeveling.PVP) {
            this.setOwnBaseLevel(enumLeveling, level);
        }
    }

    @Override
    public NBTTagCompound write() {
        return this.player.getEntityData();
    }

    @Override
    public int getLevelPoint(EnumLeveling enumLeveling) {
        return this.levels_points[enumLeveling.ordinal()];
    }

    @Override
    public double getBar(EnumLeveling enumLeveling, int length) {
        return Math.min(length * this.levels[enumLeveling.ordinal()] / (this.levels_points[enumLeveling.ordinal()] * 40 + 20), length);
    }

    @Override
    public void setOwnBaseLevel(EnumLeveling enumLeveling, int level) {
        level = EnumLeveling.PRACTICE == enumLeveling ? (level /= 10) : (level /= 5);
        this.addLevel(EnumLeveling.BASE, level);
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }
}

