/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.recipe;

import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.packet.CustomPacketBuffer;
import java.io.IOException;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class RecipeInfo {
    private final ItemStack stack;
    private final double col;

    public RecipeInfo(ItemStack stack, double col) {
        this.stack = stack;
        this.col = col;
    }

    public RecipeInfo(NBTTagCompound tagCompound) {
        this.stack = new ItemStack(tagCompound.func_74775_l("stack"));
        this.col = tagCompound.func_74769_h("matter");
    }

    public RecipeInfo(CustomPacketBuffer packetBuffer) {
        this.col = packetBuffer.readDouble();
        try {
            this.stack = (ItemStack)DecoderHandler.decode(packetBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public CustomPacketBuffer getPacket() {
        CustomPacketBuffer packetBuffer = new CustomPacketBuffer();
        packetBuffer.writeDouble(this.col);
        try {
            EncoderHandler.encode(packetBuffer, this.stack);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packetBuffer;
    }

    public double getCol() {
        return this.col;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public NBTTagCompound writeCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound stackNBT = new NBTTagCompound();
        this.stack.func_77955_b(stackNBT);
        tag.func_74782_a("stack", (NBTBase)stackNBT);
        tag.func_74780_a("matter", this.col);
        return tag;
    }
}

