/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.reactors;

import com.denfop.api.reactors.EnumTypeComponent;
import com.denfop.api.reactors.IAdvReactor;
import com.denfop.api.reactors.IReactorItem;
import com.denfop.api.reactors.LogicComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class LogicReactor {
    protected Random rand = new Random();
    private List<LogicComponent> listComponent;
    protected List<LogicComponent> rodsList = new ArrayList<LogicComponent>();
    private double maxHeat;
    static LogicComponent NULL = new LogicComponent(new IReactorItem(){

        @Override
        public EnumTypeComponent getType() {
            return null;
        }

        @Override
        public int getLevel() {
            return 0;
        }

        @Override
        public int getAutoRepair(IAdvReactor reactor) {
            return 0;
        }

        @Override
        public int getRepairOther(IAdvReactor reactor) {
            return 0;
        }

        @Override
        public int getDamageCFromHeat(int heat, IAdvReactor reactor) {
            return 0;
        }

        @Override
        public int getHeat(IAdvReactor reactor) {
            return 0;
        }

        @Override
        public double getHeatRemovePercent(IAdvReactor reactor) {
            return 0.0;
        }

        @Override
        public void damageItem(ItemStack stack, int damage) {
        }

        @Override
        public boolean updatableItem() {
            return false;
        }

        @Override
        public boolean caneExtractHeat() {
            return false;
        }

        @Override
        public double getEnergyProduction(IAdvReactor reactor) {
            return 0.0;
        }

        @Override
        public boolean needClear(ItemStack stack) {
            return false;
        }
    }, -1, -1, null, null);
    protected final IAdvReactor reactor;
    protected final List<Integer> listIndexRod = new ArrayList<Integer>();
    protected final int x;
    protected final int y;
    protected int generation;
    protected int rad_generation;

    public LogicReactor(IAdvReactor advReactor) {
        this.reactor = advReactor;
        this.rand = new Random();
        this.x = this.reactor.getWidth();
        this.y = this.reactor.getHeight();
        this.listComponent = new ArrayList<LogicComponent>(Collections.nCopies(this.x * this.y, NULL));
        this.calculateComponent();
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public int getRadGeneration() {
        return this.rad_generation;
    }

    public void setRadGeneration(int rad_generation) {
        this.rad_generation = rad_generation;
    }

    public void calculateComponent() {
        for (int j = 0; j < this.y; ++j) {
            for (int i = 0; i < this.x; ++i) {
                ItemStack stack = this.reactor.getItemAt(i, j);
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IReactorItem)) continue;
                this.listComponent.set(i + this.x * j, new LogicComponent((IReactorItem)stack.func_77973_b(), i, j, stack, this.reactor));
            }
        }
        this.listComponent.forEach(logicComponent -> logicComponent.updateAllInterface(this.listComponent, this.x, this.y, this.reactor));
        this.listComponent.removeIf(logicComponent -> logicComponent.getItem().getType() != EnumTypeComponent.ROD || logicComponent == NULL);
        this.rodsList = new ArrayList<LogicComponent>(this.listComponent);
        for (LogicComponent component : this.rodsList) {
            if (this.listIndexRod.contains(component.getX())) continue;
            this.listIndexRod.add(component.getX());
        }
        this.calculateFirstLogic(this.listComponent);
    }

    public List<Integer> getListIndexRod() {
        return this.listIndexRod;
    }

    private void calculateFirstLogic(List<LogicComponent> logicComponents) {
        ArrayList<LogicComponent> list = new ArrayList<LogicComponent>(logicComponents);
        ArrayList<LogicComponent> logicComponents1 = new ArrayList<LogicComponent>(logicComponents);
        ArrayList<LogicComponent> list1 = new ArrayList<LogicComponent>();
        this.maxHeat = 0.0;
        this.generation = 0;
        this.rad_generation = 0;
        while (!logicComponents1.isEmpty()) {
            ArrayList<LogicComponent> logicComponents2 = new ArrayList<LogicComponent>();
            for (LogicComponent component : logicComponents1) {
                boolean added = false;
                int col = 0;
                if (component == null || component.getItem() == null) continue;
                this.generation += (int)(component.getItem().getEnergyProduction(this.reactor) * this.reactor.getMulOutput(component.getX(), component.getY(), component.getStack()));
                this.rad_generation += (int)component.getItem().getRadiation();
                if (component.getItem().updatableItem() && !list1.contains(component)) {
                    list1.add(component);
                }
                for (LogicComponent lg : component.getLogicComponents()) {
                    if (list.contains(lg)) continue;
                    ++col;
                }
                for (LogicComponent lg : component.getLogicComponents()) {
                    if (list.contains(lg) || lg == NULL) continue;
                    if (component.canExtractHeat()) {
                        lg.heat += component.heat / (double)col * lg.getItem().getHeatRemovePercent(this.reactor) * this.reactor.getMulHeat(lg.getX(), lg.getY(), lg.getStack());
                        lg.damage = (int)(lg.heat / (double)lg.getItem().getDamageCFromHeat((int)lg.heat, this.reactor) * this.reactor.getMulDamage(lg.getX(), lg.getY(), lg.getStack()) - (double)lg.getItem().getAutoRepair(this.reactor));
                        if (lg.getItem().getType() == EnumTypeComponent.COOLANT_ROD) {
                            lg.damage *= 10;
                        }
                        if (component.getItem().getType() == EnumTypeComponent.ROD && lg.getItem().getType() == EnumTypeComponent.PLATE) {
                            lg.heat *= 1.5;
                        }
                        if (lg.getItem().getType() == EnumTypeComponent.CAPACITOR) {
                            lg.damage *= 3;
                        }
                        added = true;
                    }
                    if (logicComponents2.contains(lg)) continue;
                    logicComponents2.add(lg);
                }
                if (added) continue;
                this.maxHeat += component.getHeat();
            }
            logicComponents1.clear();
            logicComponents1.addAll(logicComponents2);
            list.addAll(logicComponents2);
        }
        this.listComponent = list1;
    }

    public void onTick() {
        ArrayList<LogicComponent> logicComponentList = new ArrayList<LogicComponent>();
        for (LogicComponent component : this.listComponent) {
            boolean tick = component.onTick();
            if (!tick) continue;
            logicComponentList.add(component);
        }
        if (!logicComponentList.isEmpty()) {
            logicComponentList.forEach(logicComponent -> this.reactor.setItemAt(logicComponent.getX(), logicComponent.getY()));
            this.reactor.setUpdate();
        }
        this.reactor.setOutput(this.generation);
        this.reactor.setRad(this.rad_generation);
    }

    public List<LogicComponent> getRodsList() {
        return this.rodsList;
    }

    public double getMaxHeat() {
        return this.maxHeat;
    }
}

