/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.radiationsystem;

import com.denfop.IUPotion;
import com.denfop.api.item.IHazmatLike;
import com.denfop.api.radiationsystem.EnumCoefficient;
import com.denfop.api.radiationsystem.EnumLevelRadiation;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateRadiation;
import java.util.Random;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.ChunkPos;

public class Radiation {
    private final ChunkPos pos;
    private final Random rand = new Random();
    private double radiation;
    private EnumLevelRadiation level;
    private EnumCoefficient coef;

    public Radiation(ChunkPos pos) {
        this.radiation = 0.0;
        this.level = EnumLevelRadiation.LOW;
        this.coef = EnumCoefficient.NANO;
        this.pos = pos;
    }

    public Radiation(NBTTagCompound tagCompound) {
        this.radiation = tagCompound.func_74769_h("radiation");
        this.level = EnumLevelRadiation.values()[tagCompound.func_74771_c("level")];
        this.coef = EnumCoefficient.values()[tagCompound.func_74771_c("coef")];
        this.pos = new ChunkPos(tagCompound.func_74762_e("x"), tagCompound.func_74762_e("z"));
    }

    public Radiation(CustomPacketBuffer packetBuffer) {
        this.radiation = packetBuffer.readDouble();
        this.level = EnumLevelRadiation.values()[packetBuffer.readInt()];
        this.coef = EnumCoefficient.values()[packetBuffer.readInt()];
        this.pos = new ChunkPos(packetBuffer.readInt(), packetBuffer.readInt());
    }

    public CustomPacketBuffer writePacket() {
        CustomPacketBuffer customPacketBuffer = new CustomPacketBuffer();
        customPacketBuffer.writeDouble(this.radiation);
        customPacketBuffer.writeInt(this.level.ordinal());
        customPacketBuffer.writeInt(this.coef.ordinal());
        customPacketBuffer.writeInt(this.pos.field_77276_a);
        customPacketBuffer.writeInt(this.pos.field_77275_b);
        return customPacketBuffer;
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public EnumCoefficient getCoef() {
        return this.coef;
    }

    public void setCoef(EnumCoefficient coef) {
        this.coef = coef;
    }

    public EnumLevelRadiation getLevel() {
        return this.level;
    }

    public void setLevel(EnumLevelRadiation level) {
        this.level = level;
    }

    public double getRadiation() {
        return this.radiation;
    }

    public void setRadiation(double radiation) {
        this.radiation = radiation;
    }

    public boolean removeRadiationWithType(double radiation) {
        boolean removed;
        if (this.level == EnumLevelRadiation.LOW) {
            if (this.radiation == 999.0 && radiation == 1000.0) {
                this.radiation = 0.0;
                new PacketUpdateRadiation(this);
                return true;
            }
            if (this.radiation < radiation) {
                return false;
            }
        }
        if (this.level == EnumLevelRadiation.DEFAULT) {
            radiation /= 10.0;
        }
        if (this.level == EnumLevelRadiation.MEDIUM) {
            radiation /= 100.0;
        }
        if (this.level == EnumLevelRadiation.HIGH) {
            radiation /= 1000.0;
        }
        if (this.level == EnumLevelRadiation.VERY_HIGH) {
            radiation /= 10000.0;
        }
        if (this.radiation - radiation == 0.0) {
            this.radiation = this.level != EnumLevelRadiation.LOW ? 1000.0 : 0.0;
            this.level = EnumLevelRadiation.values()[Math.max(this.level.ordinal() - 1, 0)];
            this.coef = EnumCoefficient.values()[Math.max(this.coef.ordinal() - 1, 0)];
            removed = true;
        } else if (this.radiation - radiation < 0.0) {
            this.radiation = 1000.0 - (radiation - this.radiation);
            this.level = EnumLevelRadiation.values()[Math.max(this.level.ordinal() - 1, 0)];
            this.coef = EnumCoefficient.values()[Math.max(this.coef.ordinal() - 1, 0)];
            removed = true;
        } else {
            this.radiation -= radiation;
            removed = true;
        }
        new PacketUpdateRadiation(this);
        return removed;
    }

    public void removeRadiation(double radiation) {
        while (radiation > 0.0 && (this.radiation != 0.0 || this.getLevel() != EnumLevelRadiation.LOW)) {
            if (this.radiation - radiation == 0.0) {
                radiation = 0.0;
                this.radiation = 1000.0;
                this.level = EnumLevelRadiation.values()[Math.max(this.level.ordinal() - 1, 0)];
                this.coef = EnumCoefficient.values()[Math.max(this.coef.ordinal() - 1, 0)];
                continue;
            }
            if (this.radiation - radiation < 0.0) {
                this.radiation = 1000.0;
                radiation -= this.radiation;
                this.level = EnumLevelRadiation.values()[Math.max(this.level.ordinal() - 1, 0)];
                this.coef = EnumCoefficient.values()[Math.max(this.coef.ordinal() - 1, 0)];
                continue;
            }
            this.radiation -= radiation;
            radiation = 0.0;
        }
    }

    public void addRadiation(double radiation) {
        while (radiation > 0.0) {
            if (this.level == EnumLevelRadiation.DEFAULT) {
                radiation /= 10.0;
            }
            if (this.level == EnumLevelRadiation.MEDIUM) {
                radiation /= 100.0;
            }
            if (this.level == EnumLevelRadiation.HIGH) {
                radiation /= 1000.0;
            }
            if (this.level == EnumLevelRadiation.VERY_HIGH) {
                radiation /= 10000.0;
            }
            if (this.radiation + radiation == 1000.0) {
                radiation = 0.0;
                this.level = EnumLevelRadiation.values()[Math.min(this.level.ordinal() + 1, EnumLevelRadiation.values().length - 1)];
                this.coef = EnumCoefficient.values()[Math.min(this.coef.ordinal() + 1, EnumCoefficient.values().length - 1)];
                continue;
            }
            if (this.radiation + radiation > 1000.0) {
                this.radiation = 0.0;
                radiation -= 1000.0 - this.radiation;
                this.level = EnumLevelRadiation.values()[Math.min(this.level.ordinal() + 1, EnumLevelRadiation.values().length - 1)];
                this.coef = EnumCoefficient.values()[Math.min(this.coef.ordinal() + 1, EnumCoefficient.values().length - 1)];
                continue;
            }
            this.radiation += radiation;
        }
    }

    public void process(EntityPlayer player) {
        boolean need = IHazmatLike.hasCompleteHazmat((EntityLivingBase)player, this.level);
        if (!need) {
            switch (this.level) {
                case MEDIUM: {
                    int num = this.rand.nextInt(4);
                    switch (num) {
                        case 0: {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 200, 0));
                            break;
                        }
                        case 1: {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200, 0));
                            break;
                        }
                        case 2: {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 0));
                            break;
                        }
                        case 3: {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 0));
                        }
                    }
                    break;
                }
                case HIGH: {
                    int num = this.rand.nextInt(4);
                    switch (num) {
                        case 0: {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 200, 0));
                            break;
                        }
                        case 1: {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200, 0));
                            break;
                        }
                        case 2: {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 0));
                            break;
                        }
                        case 3: {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 0));
                        }
                    }
                    player.func_70690_d(new PotionEffect((Potion)IUPotion.radiation, 200, 0));
                    break;
                }
                case VERY_HIGH: {
                    int num = this.rand.nextInt(4);
                    switch (num) {
                        case 0: {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76438_s, 200, 0));
                            break;
                        }
                        case 1: {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76440_q, 200, 0));
                            break;
                        }
                        case 2: {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 200, 0));
                            break;
                        }
                        case 3: {
                            player.func_70690_d(new PotionEffect(MobEffects.field_76436_u, 200, 0));
                        }
                    }
                    player.func_70690_d(new PotionEffect((Potion)IUPotion.radiation, 43200, 0));
                    player.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 400, 0));
                    break;
                }
            }
        }
    }

    public NBTTagCompound writeCompound() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74780_a("radiation", this.radiation);
        tag.func_74774_a("level", (byte)this.level.ordinal());
        tag.func_74774_a("coef", (byte)this.coef.ordinal());
        tag.func_74768_a("x", this.pos.field_77276_a);
        tag.func_74768_a("z", this.pos.field_77275_b);
        return tag;
    }
}

