/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.multiblock;

import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.multiblock.IMainMultiBlock;
import com.denfop.api.multiblock.IMultiElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class MultiBlockStructure {
    public final Map<BlockPos, Class<? extends IMultiElement>> blockPosMap = new HashMap<BlockPos, Class<? extends IMultiElement>>();
    public final Map<BlockPos, ItemStack> ItemStackMap = new HashMap<BlockPos, ItemStack>();
    public final List<ItemStack> itemStackList = new ArrayList<ItemStack>();
    public final Map<BlockPos, EnumFacing> RotationMap = new HashMap<BlockPos, EnumFacing>();
    public final Map<BlockPos, IBakedModel> bakedModelMap = new HashMap<BlockPos, IBakedModel>();
    public final BlockPos pos;
    private final Map<Class<? extends IMultiElement>, String> reportLaskBlock = new HashMap<Class<? extends IMultiElement>, String>();
    public boolean hasActivatedItem = false;
    public int height;
    public int weight;
    public int length;
    public int maxHeight;
    public int minHeight;
    public int maxWeight;
    public int minWeight;
    public int maxLength;
    public int minLength;
    public boolean ignoreMetadata = false;
    public ItemStack activateItem = ItemStack.field_190927_a;
    private Class<? extends IMainMultiBlock> main;

    public MultiBlockStructure() {
        this.pos = BlockPos.field_177992_a;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public int getHeight() {
        return this.height + 1;
    }

    public int getLength() {
        return this.length + 1;
    }

    public int getWeight() {
        return this.weight + 1;
    }

    public MultiBlockStructure setIgnoreMetadata(boolean ignoreMetadata) {
        this.ignoreMetadata = ignoreMetadata;
        return this;
    }

    public ItemStack getActivateItem() {
        return this.activateItem;
    }

    public MultiBlockStructure setActivateItem(ItemStack activateItem) {
        this.activateItem = activateItem;
        return this;
    }

    public boolean isActivateItem(ItemStack stack) {
        assert (stack != null);
        assert (!stack.func_190926_b());
        return this.ignoreMetadata ? this.activateItem.func_77973_b() == stack.func_77973_b() : this.activateItem.func_77969_a(stack);
    }

    public boolean isHasActivatedItem() {
        return this.hasActivatedItem;
    }

    public MultiBlockStructure setHasActivatedItem(boolean hasActivatedItem) {
        this.hasActivatedItem = hasActivatedItem;
        return this;
    }

    public void add(BlockPos pos, Class<? extends IMultiElement> class1, ItemStack stack) {
        if (this.blockPosMap.containsKey(pos)) {
            return;
        }
        boolean found = false;
        for (ItemStack stack1 : this.itemStackList) {
            if (!stack1.func_77969_a(stack)) continue;
            stack1.func_190917_f(stack.func_190916_E());
            found = true;
            break;
        }
        if (!found) {
            this.itemStackList.add(stack.func_77946_l());
        }
        this.blockPosMap.put(pos, class1);
        this.ItemStackMap.put(pos, stack);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (y < this.minHeight) {
            this.minHeight = y;
        }
        if (y > this.maxHeight) {
            this.maxHeight = y;
        }
        if (x < this.minLength) {
            this.minLength = x;
        }
        if (x > this.maxLength) {
            this.maxLength = x;
        }
        if (z < this.minWeight) {
            this.minWeight = z;
        }
        if (z > this.maxWeight) {
            this.maxWeight = z;
        }
        this.height = this.maxHeight - this.minHeight;
        this.weight = this.maxWeight - this.minWeight;
        this.length = this.maxLength - this.minLength;
    }

    public List<ItemStack> getItemStackList() {
        return this.itemStackList;
    }

    public void add(BlockPos pos, Class<? extends IMultiElement> class1, ItemStack stack, EnumFacing rotation) {
        if (this.blockPosMap.containsKey(pos)) {
            return;
        }
        boolean found = false;
        for (ItemStack stack1 : this.itemStackList) {
            if (!stack1.func_77969_a(stack)) continue;
            stack1.func_190917_f(stack.func_190916_E());
            found = true;
            break;
        }
        if (!found) {
            this.itemStackList.add(stack.func_77946_l());
        }
        this.blockPosMap.put(pos, class1);
        this.ItemStackMap.put(pos, stack);
        this.RotationMap.put(pos, rotation);
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (y < this.minHeight) {
            this.minHeight = y;
        }
        if (y > this.maxHeight) {
            this.maxHeight = y;
        }
        if (x < this.minLength) {
            this.minLength = x;
        }
        if (x > this.maxLength) {
            this.maxLength = x;
        }
        if (z < this.minWeight) {
            this.minWeight = z;
        }
        if (z > this.maxWeight) {
            this.maxWeight = z;
        }
        this.height = this.maxHeight - this.minHeight;
        this.weight = this.maxWeight - this.minWeight;
        this.length = this.maxLength - this.minLength;
    }

    public List<BlockPos> getPosFromClass(EnumFacing facing, BlockPos pos, Class<? extends IMultiElement> class1) {
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
            BlockPos pos1;
            switch (facing) {
                case NORTH: {
                    pos1 = pos.func_177971_a((Vec3i)entry.getKey());
                    break;
                }
                case EAST: {
                    pos1 = pos.func_177982_a(entry.getKey().func_177952_p() * -1, entry.getKey().func_177956_o(), entry.getKey().func_177958_n());
                    break;
                }
                case WEST: {
                    pos1 = pos.func_177982_a(entry.getKey().func_177952_p(), entry.getKey().func_177956_o(), entry.getKey().func_177958_n() * -1);
                    break;
                }
                case SOUTH: {
                    pos1 = pos.func_177982_a(entry.getKey().func_177958_n() * -1, entry.getKey().func_177956_o(), entry.getKey().func_177952_p() * -1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + facing);
                }
            }
            if (entry.getValue() != class1) continue;
            blockPosList.add(pos1);
        }
        return blockPosList;
    }

    public boolean getFull(EnumFacing facing, BlockPos pos, World world, EntityPlayer player) {
        IMainMultiBlock mainTile = (IMainMultiBlock)world.func_175625_s(pos);
        for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
            BlockPos pos1;
            if (entry.getValue() == this.main) continue;
            switch (facing) {
                case NORTH: {
                    pos1 = pos.func_177971_a((Vec3i)entry.getKey());
                    break;
                }
                case EAST: {
                    pos1 = pos.func_177982_a(entry.getKey().func_177952_p() * -1, entry.getKey().func_177956_o(), entry.getKey().func_177958_n());
                    break;
                }
                case WEST: {
                    pos1 = pos.func_177982_a(entry.getKey().func_177952_p(), entry.getKey().func_177956_o(), entry.getKey().func_177958_n() * -1);
                    break;
                }
                case SOUTH: {
                    pos1 = pos.func_177982_a(entry.getKey().func_177958_n() * -1, entry.getKey().func_177956_o(), entry.getKey().func_177952_p() * -1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + facing);
                }
            }
            TileEntity tile = world.func_175625_s(pos1);
            if (entry.getValue() == null) {
                IBlockState blockstate = world.func_180495_p(pos1);
                if (blockstate.func_185904_a() == Material.field_151579_a) continue;
                return false;
            }
            if (!entry.getValue().isInstance(tile)) {
                String report = this.reportLaskBlock.get(entry.getValue());
                if (report != null && !report.isEmpty()) {
                    if (IUCore.proxy.isSimulating()) {
                        IUCore.proxy.messagePlayer(player, Localization.translate("iu.not.found") + "x: " + pos1.func_177958_n() + " y: " + pos1.func_177956_o() + " z: " + pos1.func_177952_p() + " " + Localization.translate(report), new Object[0]);
                    }
                } else if (IUCore.proxy.isSimulating()) {
                    IUCore.proxy.messagePlayer(player, Localization.translate("iu.not.found") + "x: " + pos1.func_177958_n() + " y: " + pos1.func_177956_o() + " z: " + pos1.func_177952_p() + " " + this.ItemStackMap.get(entry.getKey()).func_82833_r(), new Object[0]);
                }
                return false;
            }
            IMultiElement element = (IMultiElement)tile;
            if (element.isMain() && element.getMain() != mainTile || element.getLevel() != mainTile.getLevel() || !element.canCreateSystem(mainTile)) {
                return false;
            }
            if (element.getMain() != null && element.getMain() != mainTile) {
                IMainMultiBlock mainTwo = element.getMain();
                element.setMainMultiElement(mainTile);
                mainTwo.updateFull();
                if (!mainTwo.wasActivated()) continue;
                mainTwo.setActivated(false);
                continue;
            }
            if (element.getMain() != null) continue;
            element.setMainMultiElement(mainTile);
        }
        return true;
    }

    public boolean getFull(EnumFacing facing, BlockPos pos, World world) {
        IMainMultiBlock mainTile = (IMainMultiBlock)world.func_175625_s(pos);
        for (Map.Entry<BlockPos, Class<? extends IMultiElement>> entry : this.blockPosMap.entrySet()) {
            BlockPos pos1;
            if (entry.getValue() == this.main) continue;
            switch (facing) {
                case NORTH: {
                    pos1 = pos.func_177971_a((Vec3i)entry.getKey());
                    break;
                }
                case EAST: {
                    pos1 = pos.func_177982_a(entry.getKey().func_177952_p() * -1, entry.getKey().func_177956_o(), entry.getKey().func_177958_n());
                    break;
                }
                case WEST: {
                    pos1 = pos.func_177982_a(entry.getKey().func_177952_p(), entry.getKey().func_177956_o(), entry.getKey().func_177958_n() * -1);
                    break;
                }
                case SOUTH: {
                    pos1 = pos.func_177982_a(entry.getKey().func_177958_n() * -1, entry.getKey().func_177956_o(), entry.getKey().func_177952_p() * -1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + facing);
                }
            }
            TileEntity tile = world.func_175625_s(pos1);
            if (entry.getValue() == null) {
                IBlockState blockstate = world.func_180495_p(pos1);
                if (blockstate.func_185904_a() == Material.field_151579_a) continue;
                return false;
            }
            if (!entry.getValue().isInstance(tile)) {
                return false;
            }
            IMultiElement element = (IMultiElement)tile;
            if (element.getMain() != null && element.getMain() != mainTile || element.getLevel() != mainTile.getLevel() || !element.canCreateSystem(mainTile)) {
                return false;
            }
            if (element.getMain() != null) continue;
            element.setMainMultiElement(mainTile);
        }
        return true;
    }

    public MultiBlockStructure setMain(Class<? extends IMainMultiBlock> main) {
        this.main = main;
        return this;
    }

    public void addReport(Class<? extends IMultiElement> name, String report) {
        this.reportLaskBlock.put(name, report);
    }
}

