/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.api.gui.GuiElement;
import com.denfop.gui.GuiCore;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class TextBook
extends GuiElement<TextBook> {
    private final String textProvider;
    private final Supplier<Integer> color;
    private final boolean shadow;
    private final boolean fixedHoverWidth;
    private final boolean fixedHoverHeight;
    private final int baseX;
    private final int baseY;
    private final boolean centerX;
    private final boolean centerY;

    private TextBook(GuiCore<?> gui, int x, int y, int width, int height, String textProvider, Supplier<Integer> color, boolean shadow, boolean fixedHoverWidth, boolean fixedHoverHeight, int baseX, int baseY, boolean centerX, boolean centerY) {
        super(gui, x, y, width, height);
        this.textProvider = textProvider;
        this.color = color;
        this.shadow = shadow;
        this.fixedHoverWidth = fixedHoverWidth;
        this.fixedHoverHeight = fixedHoverHeight;
        this.baseX = baseX;
        this.baseY = baseY;
        this.centerX = centerX;
        this.centerY = centerY;
    }

    public static TextBook create(GuiCore<?> gui, int x, int y, String textProvider, int color, boolean shadow) {
        return TextBook.create(gui, x, y, textProvider, color, shadow, false, false);
    }

    public static TextBook create(GuiCore<?> gui, int x, int y, String textProvider, int color, boolean shadow, boolean centerX, boolean centerY) {
        return TextBook.create(gui, x, y, -1, -1, textProvider, color, shadow, centerX, centerY);
    }

    public static TextBook create(GuiCore<?> gui, int x, int y, int width, int height, String textProvider, int color, boolean shadow, boolean centerX, boolean centerY) {
        return TextBook.create(gui, x, y, width, height, textProvider, color, shadow, 0, 0, centerX, centerY);
    }

    public static TextBook create(GuiCore<?> gui, int x, int y, int width, int height, String textProvider, int color, boolean shadow, int xOffset, int yOffset, boolean centerX, boolean centerY) {
        return TextBook.create(gui, x, y, width, height, textProvider, (Supplier<Integer>)Suppliers.ofInstance((Object)color), shadow, xOffset, yOffset, centerX, centerY);
    }

    public static TextBook create(GuiCore<?> gui, int x, int y, int width, int height, String textProvider, Supplier<Integer> color, boolean shadow, int xOffset, int yOffset, boolean centerX, boolean centerY) {
        boolean fixedHoverHeight;
        boolean fixedHoverWidth;
        if (width < 0) {
            fixedHoverWidth = false;
            width = TextBook.getWidth(gui, textProvider);
        } else {
            fixedHoverWidth = true;
        }
        if (height < 0) {
            fixedHoverHeight = false;
            height = 8;
        } else {
            fixedHoverHeight = true;
        }
        int baseX = x + xOffset;
        int baseY = y + yOffset;
        if (centerX) {
            if (fixedHoverWidth) {
                baseX += width / 2;
            } else {
                x -= width / 2;
            }
        }
        if (centerY) {
            if (fixedHoverHeight) {
                baseY += (height + 1) / 2;
            } else {
                y -= height / 2;
            }
        }
        return new TextBook(gui, x, y, width, height, textProvider, color, shadow, fixedHoverWidth, fixedHoverHeight, baseX, baseY, centerX, centerY);
    }

    private static int getWidth(GuiCore<?> gui, String textProvider) {
        String text = textProvider;
        return text.isEmpty() ? 0 : Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
    }

    public static List<String> splitEqually(String text) {
        boolean isUkrOrrus = Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a().equals("ru_ru") || Minecraft.func_71410_x().func_135016_M().func_135041_c().func_135034_a().equals("uk_ua");
        int size = isUkrOrrus ? 43 : 33;
        String[] ret = text.split(" ");
        ArrayList<String> ret1 = new ArrayList<String>();
        StringBuilder k = new StringBuilder();
        for (String res : ret) {
            if (k.length() + res.length() + 1 < size && !res.equals("\n")) {
                k.append(" ").append(res);
                continue;
            }
            ret1.add(k.toString().trim());
            k = new StringBuilder();
            k.append(res);
        }
        if (k.length() > 0) {
            ret1.add(k.toString().trim());
        }
        return ret1;
    }

    public Supplier<Integer> getColor() {
        return this.color;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public String getText() {
        return this.textProvider;
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        int textWidth;
        int textHeight;
        String text = this.textProvider;
        if (text.isEmpty()) {
            textHeight = 0;
            textWidth = 0;
        } else {
            textWidth = this.gui.getStringWidth(text);
            textHeight = 8;
        }
        int textX = this.baseX;
        if (this.centerX) {
            textX -= textWidth / 2;
        }
        int textY = this.baseY;
        if (this.centerY) {
            textY -= textHeight / 2;
        }
        if (!this.fixedHoverWidth) {
            this.x = textX;
            this.width = textWidth;
        }
        if (!this.fixedHoverHeight) {
            this.y = textY;
            this.height = textHeight;
        }
        super.drawBackground(mouseX, mouseY);
        List<String> textList = TextBook.splitEqually(text);
        int y = 0;
        for (String text1 : textList) {
            if (text1.isEmpty()) continue;
            this.drawText(text1, textX, textY + y, 0.75);
            y += 9;
        }
    }

    private int calculateX(int originalX, String text, double scale) {
        return originalX + this.getGui().field_146294_l / 8;
    }

    private int calculateY(int originalY, String text, double scale) {
        return originalY + this.getGui().field_146295_m / 16;
    }

    public void drawText(String text, float posX, float posY, double scale) {
        GL11.glPushMatrix();
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        this.gui.drawString(this.calculateX((int)posX, text, scale), this.calculateY((int)posY, text, scale), text, (Integer)this.color.get(), this.shadow);
        GL11.glPopMatrix();
    }

    public static enum TextAlignment {
        Start,
        Center,
        End;

        private static final Map<String, TextAlignment> map;
        public final String name = this.name().toLowerCase(Locale.ENGLISH);

        public static TextAlignment get(String name) {
            return map.get(name);
        }

        private static Map<String, TextAlignment> getMap() {
            TextAlignment[] values = TextAlignment.values();
            HashMap<String, TextAlignment> ret = new HashMap<String, TextAlignment>(values.length);
            TextAlignment[] var2 = values;
            int var3 = values.length;
            for (int var4 = 0; var4 < var3; ++var4) {
                TextAlignment style = var2[var4];
                ret.put(style.name, style);
            }
            return ret;
        }

        static {
            map = TextAlignment.getMap();
        }
    }
}

