/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.gui;

import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.gui.GuiElement;
import com.denfop.api.gui.GuiElementFluidToFluids;
import com.denfop.api.recipe.BaseMachineRecipe;
import com.denfop.gui.GuiCore;
import com.denfop.utils.ModUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class GuiElementItemFluid
extends GuiElement<GuiElementFluidToFluids> {
    private BaseMachineRecipe recipe;

    public GuiElementItemFluid(GuiCore<?> gui, int x, int y, int width, int height, String recipe, ItemStack stack, Fluid fluid) {
        super(gui, x, y, width, height);
        List<BaseMachineRecipe> recipes = Recipes.recipes.getRecipeList(recipe);
        for (BaseMachineRecipe recipe1 : recipes) {
            FluidStack liquid;
            if (recipe1.input.getFluid() == null || (liquid = FluidUtil.getFluidContained((ItemStack)recipe1.output.items.get(0))) == null || liquid.getFluid() != fluid) continue;
            if (stack != null) {
                if (!recipe1.input.getInputs().get(0).matches(stack)) continue;
                this.recipe = recipe1;
                break;
            }
            this.recipe = recipe1;
            break;
        }
    }

    public static GuiElementItemFluid GuiElementItemFluid(GuiCore<?> gui, int x, int y, String recipe, ItemStack stack, Fluid fluid) {
        return new GuiElementItemFluid(gui, x, y, 83, 22, recipe, stack, fluid);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        ItemStack stack1;
        if (mouseX >= this.x && mouseX <= this.x + 18 && mouseY >= this.y && mouseY <= this.y + 18) {
            String tooltip;
            List<String> lines = this.getToolTip();
            if (this.getTooltipProvider() != null && (tooltip = (String)this.getTooltipProvider().get()) != null && !tooltip.isEmpty()) {
                GuiElementItemFluid.addLines(lines, tooltip);
            }
            if (!lines.isEmpty()) {
                this.gui.drawTooltip(mouseX, mouseY, lines);
            }
        }
        int i = 1;
        FluidStack stack = FluidUtil.getFluidContained((ItemStack)this.recipe.output.items.get(0));
        int fluidX = this.x + 1 + 44 + 20 * i;
        int fluidY = this.y + 1;
        ArrayList<String> ret = new ArrayList<String>();
        if (mouseX >= fluidX && mouseX <= fluidX + 18 && mouseY >= fluidY && mouseY <= fluidY + 18) {
            if (stack != null && stack.amount > 0) {
                Fluid fluid = stack.getFluid();
                if (fluid != null) {
                    ret.add(fluid.getLocalizedName(stack));
                    ret.add("Amount: " + stack.amount + " " + Localization.translate("iu.generic.text.mb"));
                    String state = stack.getFluid().isGaseous() ? "Gas" : "Liquid";
                    ret.add("Type: " + state);
                } else {
                    ret.add("Invalid FluidStack instance.");
                }
            } else {
                ret.add("No Fluid");
                ret.add("Amount: 0 " + Localization.translate("iu.generic.text.mb"));
                ret.add("Type: Not Available");
            }
            if (!ret.isEmpty()) {
                this.gui.drawTooltip(mouseX, mouseY, ret);
            }
        }
        fluidX = this.x + 1 + 19;
        fluidY = this.y + 1;
        if (mouseX >= fluidX && mouseX <= fluidX + 18 && mouseY >= fluidY && mouseY <= fluidY + 18 && !ModUtils.isEmpty(stack1 = this.recipe.input.getInputs().get(1).getInputs().get(0))) {
            this.gui.drawTooltip(mouseX, mouseY, stack1);
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY) {
        ItemStack stack;
        GuiElementItemFluid.bindCommonTexture();
        if (this.recipe == null) {
            return;
        }
        if (this.recipe.input == null) {
            return;
        }
        FluidStack fs = this.recipe.input.getFluid();
        this.gui.drawTexturedRect(this.x, this.y, this.width, this.height, 169.0, 75.0);
        if (fs != null && fs.amount > 0) {
            int fluidX = this.x + 1;
            int fluidY = this.y + 1;
            int fluidWidth = 16;
            int fluidHeight = 16;
            Fluid fluid = fs.getFluid();
            TextureAtlasSprite sprite = fluid != null ? GuiElementItemFluid.getBlockTextureMap().func_110572_b(fluid.getStill(fs).toString()) : null;
            int color = fluid != null ? fluid.getColor(fs) : -1;
            GuiElementItemFluid.bindBlockTexture();
            this.gui.drawSprite(fluidX, fluidY, fluidWidth, fluidHeight, sprite, color, 1.0, false, false);
        }
        if (!ModUtils.isEmpty(stack = this.recipe.input.getInputs().get(1).getInputs().get(0))) {
            RenderHelper.func_74520_c();
            this.gui.drawItemStack(this.x + 21, this.y + 1, stack);
            RenderHelper.func_74518_a();
        }
        if ((fs = FluidUtil.getFluidContained((ItemStack)this.recipe.output.items.get(0))) != null && fs.amount > 0) {
            int fluidX = this.x + 1 + 64;
            int fluidY = this.y + 1;
            int fluidWidth = 16;
            int fluidHeight = 16;
            Fluid fluid = fs.getFluid();
            TextureAtlasSprite sprite = fluid != null ? GuiElementItemFluid.getBlockTextureMap().func_110572_b(fluid.getStill(fs).toString()) : null;
            int color = fluid != null ? fluid.getColor(fs) : -1;
            GuiElementItemFluid.bindBlockTexture();
            this.gui.drawSprite(fluidX, fluidY, fluidWidth, fluidHeight, sprite, color, 1.0, false, false);
        }
    }

    @Override
    protected List<String> getToolTip() {
        List<String> ret = super.getToolTip();
        FluidStack fs = this.recipe.input.getFluid();
        if (fs != null && fs.amount > 0) {
            Fluid fluid = fs.getFluid();
            if (fluid != null) {
                ret.add(fluid.getLocalizedName(fs));
                ret.add("Amount: " + fs.amount + " " + Localization.translate("iu.generic.text.mb"));
                String state = fs.getFluid().isGaseous() ? "Gas" : "Liquid";
                ret.add("Type: " + state);
            } else {
                ret.add("Invalid FluidStack instance.");
            }
        } else {
            ret.add("No Fluid");
            ret.add("Amount: 0 " + Localization.translate("iu.generic.text.mb"));
            ret.add("Type: Not Available");
        }
        return ret;
    }
}

