/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.api.energy;

import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.EnergyTick;
import com.denfop.api.energy.EnergyTickList;
import com.denfop.api.energy.IDual;
import com.denfop.api.energy.IEnergyAcceptor;
import com.denfop.api.energy.IEnergyConductor;
import com.denfop.api.energy.IEnergyController;
import com.denfop.api.energy.IEnergyEmitter;
import com.denfop.api.energy.IEnergySink;
import com.denfop.api.energy.IEnergySource;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.energy.IMultiDual;
import com.denfop.api.energy.NodeStats;
import com.denfop.api.energy.Path;
import com.denfop.api.energy.SunCoef;
import com.denfop.api.sytem.InfoTile;
import com.denfop.api.transport.ITransportTile;
import com.denfop.api.transport.TransportNetGlobal;
import com.denfop.api.transport.event.TransportTileUnLoadEvent;
import com.denfop.network.packet.PacketExplosion;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.items.IItemHandler;

public class EnergyNetLocal {
    public static EnergyNetLocal EMPTY = new EnergyNetLocal();
    final EnergyTickList<EnergyTick> energyTickList = new EnergyTickList();
    private World world;
    private final List<IEnergyController> controllerList;
    private final Map<BlockPos, IEnergyTile> chunkCoordinatesIEnergyTileMap;
    private final List<IEnergySource> energySourceList = new ArrayList<IEnergySource>();
    private SunCoef suncoef;
    final List<IEnergySource> sourceToUpdateList = new ArrayList<IEnergySource>();
    private final boolean hasrestrictions;
    private final boolean explosing;
    private final boolean ignoring;
    private final boolean losing;
    private int tick;

    EnergyNetLocal(World world) {
        this.world = world;
        this.controllerList = new ArrayList<IEnergyController>();
        this.chunkCoordinatesIEnergyTileMap = new HashMap<BlockPos, IEnergyTile>();
        this.tick = 0;
        this.suncoef = new SunCoef(world);
        this.losing = EnergyNetGlobal.instance.getLosing();
        this.ignoring = EnergyNetGlobal.instance.needIgnoringTiers();
        this.explosing = EnergyNetGlobal.instance.needExplosion();
        this.hasrestrictions = EnergyNetGlobal.instance.hasRestrictions();
    }

    EnergyNetLocal() {
        this.world = null;
        this.controllerList = new ArrayList<IEnergyController>();
        this.chunkCoordinatesIEnergyTileMap = new HashMap<BlockPos, IEnergyTile>();
        this.tick = 0;
        this.suncoef = null;
        this.losing = EnergyNetGlobal.instance.getLosing();
        this.ignoring = EnergyNetGlobal.instance.needIgnoringTiers();
        this.explosing = EnergyNetGlobal.instance.needExplosion();
        this.hasrestrictions = EnergyNetGlobal.instance.hasRestrictions();
    }

    public void setWorld(World world) {
        this.world = world;
    }

    public void explodeTiles(IEnergySink sink) {
        if (!(sink instanceof IEnergySource)) {
            this.explodeMachineAt(this.getTileFromIEnergy(sink));
            this.removeTile(sink);
        } else {
            this.energySourceList.add((IEnergySource)((Object)sink));
        }
    }

    void explodeMachineAt(TileEntity entity) {
        if (this.explosing) {
            BlockPos pos = entity.func_174877_v();
            ITransportTile IEnergyTile2 = TransportNetGlobal.instance.getSubTile(this.world, pos);
            if (IEnergyTile2 != null && IEnergyTile2.getHandler() instanceof IItemHandler) {
                MinecraftForge.EVENT_BUS.post(new TransportTileUnLoadEvent(this.world, IEnergyTile2));
            }
            Explosion explosion = new Explosion(this.world, null, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 4.0f, false, false);
            this.world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            this.world.func_175698_g(pos);
            new PacketExplosion(explosion, 4, false, false);
        }
    }

    public SunCoef getSuncoef() {
        if (this.suncoef == null) {
            this.suncoef = new SunCoef(this.world);
        }
        return this.suncoef;
    }

    public void addController(IEnergyController tile1) {
        this.controllerList.add(tile1);
    }

    public void removeController(IEnergyController tile1) {
        this.controllerList.remove(tile1);
        tile1.unload();
    }

    public void addTile(IEnergyTile tile1) {
        try {
            this.addTileEntity(tile1.getBlockPos(), tile1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addTile(IEnergyTile tile, TileEntity tileentity) {
        try {
            this.addTileEntity(tileentity.func_174877_v(), tile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BlockPos getPos(IEnergyTile tile) {
        return tile.getBlockPos();
    }

    public void addTileEntity(BlockPos coords, IEnergyTile tile) {
        if (this.chunkCoordinatesIEnergyTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesIEnergyTileMap.put(coords, tile);
        this.update(coords);
        if (tile instanceof IEnergyAcceptor) {
            this.onTileEntityAdded((IEnergyAcceptor)tile);
        }
        if (tile instanceof IEnergySource) {
            this.energyTickList.add(new EnergyTick((IEnergySource)tile, null));
        }
    }

    public void removeTile(IEnergyTile tile1) {
        if (tile1 != EnergyNetGlobal.EMPTY) {
            this.removeTileEntity(tile1);
        }
    }

    public void removeTileEntity(IEnergyTile tile1, IEnergyTile tile) {
        if (!this.chunkCoordinatesIEnergyTileMap.containsKey(tile1.getBlockPos())) {
            return;
        }
        this.chunkCoordinatesIEnergyTileMap.remove(tile1.getBlockPos(), tile);
        this.update(tile1.getBlockPos());
        if (tile instanceof IEnergyAcceptor) {
            this.removeAll(this.getSources((IEnergyAcceptor)tile));
            this.onTileEntityRemoved((IEnergyAcceptor)tile);
        }
        if (tile instanceof IEnergySource) {
            this.remove((IEnergySource)tile);
        }
    }

    public void removeTileEntity(IEnergyTile tile) {
        if (tile.getBlockPos() != null ? !this.chunkCoordinatesIEnergyTileMap.containsKey(tile.getBlockPos()) : !this.chunkCoordinatesIEnergyTileMap.containsKey(tile.getTileEntity().func_174877_v())) {
            return;
        }
        BlockPos coord = tile.getBlockPos();
        this.chunkCoordinatesIEnergyTileMap.remove(coord);
        this.update(coord);
        if (tile instanceof IEnergyAcceptor) {
            this.removeAll(this.getSources((IEnergyAcceptor)tile));
            this.onTileEntityRemoved((IEnergyAcceptor)tile);
        }
        if (tile instanceof IEnergySource) {
            this.remove((IEnergySource)tile);
        }
    }

    public TileEntity getTileFromMap(IEnergyTile tile) {
        return tile.getTileEntity();
    }

    public double emitEnergyFrom(IEnergySource energySource, double amount, EnergyTick tick) {
        List<Path> energyPaths = tick.getList();
        if (energyPaths == null) {
            energyPaths = this.discover(energySource);
            for (Path path : energyPaths) {
                boolean isSorted = false;
                while (!isSorted) {
                    isSorted = true;
                    for (int i = 0; i < path.getConductors().size() - 1; ++i) {
                        if (!(path.getConductors().get(i).getConductorBreakdownEnergy() > path.getConductors().get(i + 1).getConductorBreakdownEnergy())) continue;
                        isSorted = false;
                        IEnergyConductor buf = path.getConductors().get(i);
                        path.getConductors().set(i, path.getConductors().get(i + 1));
                        path.getConductors().set(i + 1, buf);
                    }
                }
            }
            tick.setList(energyPaths);
            tick.rework();
            if (!this.controllerList.isEmpty()) {
                this.controllerList.forEach(IEnergyController::work);
            }
        }
        if (amount > 0.0) {
            for (Path energyPath : energyPaths) {
                if (amount <= 0.0) break;
                IEnergySink energySink = energyPath.target;
                double demandedEnergy = energySink.getDemandedEnergy();
                if (demandedEnergy <= 0.0) continue;
                double energyProvided = amount;
                double adding = this.hasrestrictions && !this.explosing ? Math.min(energyProvided, Math.min(demandedEnergy, energyPath.min) + energyPath.loss) : (this.hasrestrictions ? Math.min(energyProvided, demandedEnergy + energyPath.loss) : Math.min(energyProvided, demandedEnergy + energyPath.loss));
                adding -= energyPath.loss;
                if (energyPath.isLimit) {
                    adding = Math.min(adding, energyPath.limit_amount);
                }
                if (adding <= 0.0) continue;
                if (this.ignoring) {
                    int tier = energySink.getSinkTier();
                    int tier1 = EnergyNetGlobal.instance.getTierFromPower(adding);
                    if (tier1 > tier) {
                        if (energyPath.hasController) continue;
                        this.explodeTiles(energySink);
                        continue;
                    }
                }
                energySink.receiveEnergy(adding);
                energyPath.totalEnergyConducted = (long)adding;
                energyPath.tick(this.tick, adding);
                amount -= adding;
                amount -= energyPath.loss;
                amount = Math.max(0.0, amount);
                if (!this.hasrestrictions || !this.explosing || !(adding > energyPath.min)) continue;
                for (IEnergyConductor energyConductor : energyPath.conductors) {
                    if (!(energyConductor.getConductorBreakdownEnergy() < adding)) break;
                    energyConductor.removeConductor();
                }
            }
        }
        return amount;
    }

    public double getTotalEnergyEmitted(IEnergyTile tileEntity) {
        double ret = 0.0;
        int col = 0;
        if (tileEntity instanceof IEnergyConductor) {
            for (Path energyPath : this.getPaths((IEnergyAcceptor)tileEntity)) {
                if (!energyPath.conductors.contains(tileEntity)) continue;
                double energy = this.getTotalEnergySunken(energyPath.target);
                ret += energy;
                if (energy == 0.0) continue;
                ++col;
            }
        }
        if (tileEntity instanceof IEnergySource) {
            IEnergySource advEnergySource = (IEnergySource)tileEntity;
            if (!(advEnergySource instanceof IDual) && advEnergySource.isSource()) {
                ret = Math.max(0.0, advEnergySource.getPerEnergy() - advEnergySource.getPastEnergy());
            } else if (advEnergySource instanceof IDual && advEnergySource.isSource()) {
                IDual dual = (IDual)advEnergySource;
                ret = Math.max(0.0, dual.getPerEnergy1() - dual.getPastEnergy1());
            }
        }
        if (tileEntity instanceof IEnergyConductor) {
            try {
                return ret / (double)col;
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        return ret;
    }

    public double getTotalEnergySunken(IEnergyTile tileEntity) {
        double ret = 0.0;
        int col = 0;
        if (!(tileEntity instanceof IEnergySink)) {
            if (tileEntity instanceof IEnergyConductor) {
                for (Path energyPath : this.getPaths((IEnergyAcceptor)tileEntity)) {
                    if (!energyPath.conductors.contains(tileEntity)) continue;
                    double energy = this.getTotalEnergySunken(energyPath.target);
                    ret += energy;
                    if (energy == 0.0) continue;
                    ++col;
                }
            }
        } else {
            IEnergySink advEnergySink = (IEnergySink)tileEntity;
            if (advEnergySink.isSink() && ((double)(this.tick - 1) == advEnergySink.getTick() || (double)this.tick == advEnergySink.getTick() || (double)(this.tick + 1) == advEnergySink.getTick())) {
                ret = Math.max(0.0, advEnergySink.getPerEnergy() - advEnergySink.getPastEnergy());
            }
        }
        if (tileEntity instanceof IEnergyConductor) {
            try {
                return ret / (double)col;
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        return ret;
    }

    public TileEntity getTileFromIEnergy(IEnergyTile tile) {
        if (tile instanceof TileEntity) {
            return (TileEntity)tile;
        }
        return tile.getTileEntity();
    }

    public List<Path> discover(IEnergySource emitter) {
        HashMap<IEnergyConductor, EnumFacing> reachedTileEntities = new HashMap<IEnergyConductor, EnumFacing>();
        ArrayList<IEnergySource> tileEntitiesToCheck = new ArrayList<IEnergySource>();
        ArrayList<Path> energyPaths = new ArrayList<Path>();
        tileEntitiesToCheck.add(emitter);
        while (!tileEntitiesToCheck.isEmpty()) {
            IEnergyTile currentTileEntity = (IEnergyTile)tileEntitiesToCheck.remove(0);
            List<InfoTile<IEnergyTile>> validReceivers = this.getValidReceivers(currentTileEntity, false);
            for (InfoTile<IEnergyTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter) continue;
                if (validReceiver.tileEntity instanceof IEnergySink) {
                    energyPaths.add(new Path((IEnergySink)validReceiver.tileEntity, validReceiver.direction));
                    continue;
                }
                if (reachedTileEntities.containsKey((IEnergyConductor)validReceiver.tileEntity)) continue;
                reachedTileEntities.put((IEnergyConductor)validReceiver.tileEntity, validReceiver.direction);
                tileEntitiesToCheck.add((IEnergySource)validReceiver.tileEntity);
            }
        }
        block2: for (Path energyPath : energyPaths) {
            IEnergyTile tileEntity = energyPath.target;
            EnumFacing energyBlockLink = energyPath.targetDirection;
            BlockPos te = tileEntity.getBlockPos();
            while (tileEntity != emitter) {
                if (energyBlockLink != null && te != null) {
                    tileEntity = this.getTileEntity(te.func_177972_a(energyBlockLink));
                    te = te.func_177972_a(energyBlockLink);
                }
                if (!(tileEntity instanceof IEnergyConductor)) continue block2;
                IEnergyConductor energyConductor = (IEnergyConductor)tileEntity;
                energyPath.conductors.add(energyConductor);
                if (energyConductor.getConductorBreakdownEnergy() - 1.0 < energyPath.getMin()) {
                    energyPath.setMin(energyConductor.getConductorBreakdownEnergy() - 1.0);
                }
                if (this.losing) {
                    energyPath.loss += energyConductor.getConductionLoss();
                }
                energyBlockLink = (EnumFacing)reachedTileEntities.get(tileEntity);
            }
        }
        return energyPaths;
    }

    public void put(IEnergySource par1, List<Path> par2) {
        this.energyTickList.add(new EnergyTick(par1, par2));
    }

    public boolean containsKey(EnergyTick par1) {
        return this.energyTickList.contains(par1);
    }

    public boolean containsKey(IEnergySource par1) {
        return this.energyTickList.contains(par1);
    }

    public void remove1(IEnergySource par1) {
        for (EnergyTick ticks : this.energyTickList) {
            if (ticks.getSource() != par1) continue;
            ticks.setList(null);
            break;
        }
    }

    public void remove(IEnergySource par1) {
        this.energyTickList.remove(par1);
    }

    public void remove(EnergyTick par1) {
        this.energyTickList.remove(par1);
    }

    public void removeAll(List<EnergyTick> par1) {
        if (par1 == null) {
            return;
        }
        for (EnergyTick IEnergySource2 : par1) {
            IEnergySource2.setList(null);
        }
    }

    public List<Path> getPaths(IEnergyAcceptor par1) {
        ArrayList<Path> paths = new ArrayList<Path>();
        List<EnergyTick> sources_list = this.getSources(par1);
        if (sources_list == null || sources_list.isEmpty()) {
            return paths;
        }
        for (EnergyTick source : sources_list) {
            paths.addAll(source.getList());
        }
        return paths;
    }

    public List<EnergyTick> getSources(IEnergyAcceptor par1) {
        ArrayList<EnergyTick> source = new ArrayList<EnergyTick>();
        block0: for (EnergyTick entry : this.energyTickList) {
            if (entry.getList() == null) continue;
            for (Path path : entry.getList()) {
                if (!(par1 instanceof IEnergyConductor && path.conductors.contains(par1) || par1 instanceof IEnergySink && path.target == par1)) continue;
                source.add(entry);
                continue block0;
            }
        }
        return source;
    }

    public void clear() {
        this.energyTickList.clear();
    }

    private List<InfoTile<IEnergyTile>> getValidReceivers(IEnergyTile emitter, boolean reverse) {
        LinkedList<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();
        BlockPos tile1 = emitter.getBlockPos();
        if (tile1 != null) {
            for (EnumFacing direction : EnumFacing.values()) {
                IEnergyAcceptor receiver2;
                IEnergyEmitter sender2;
                IEnergyTile target2 = this.getTileEntity(tile1.func_177972_a(direction));
                if (target2 == emitter || target2 == EnergyNetGlobal.EMPTY) continue;
                EnumFacing inverseDirection2 = direction.func_176734_d();
                if (reverse) {
                    if (!(emitter instanceof IEnergyAcceptor) || !(target2 instanceof IEnergyEmitter) || !(sender2 = (IEnergyEmitter)target2).emitsEnergyTo(receiver2 = (IEnergyAcceptor)emitter, inverseDirection2) || !receiver2.acceptsEnergyFrom(sender2, direction)) continue;
                    validReceivers.add(new InfoTile<IEnergyTile>(target2, inverseDirection2));
                    continue;
                }
                if (!(emitter instanceof IEnergyEmitter) || !(target2 instanceof IEnergyAcceptor) || !(sender2 = (IEnergyEmitter)emitter).emitsEnergyTo(receiver2 = (IEnergyAcceptor)target2, direction) || !receiver2.acceptsEnergyFrom(sender2, inverseDirection2)) continue;
                validReceivers.add(new InfoTile<IEnergyTile>(target2, inverseDirection2));
            }
        }
        return validReceivers;
    }

    public void onTickEnd() {
        for (IEnergySource source : this.energySourceList) {
            this.removeTile(source);
            this.explodeMachineAt(this.getTileFromIEnergy(source));
        }
        this.energySourceList.clear();
        if (this.suncoef == null) {
            this.suncoef = new SunCoef(this.world);
        }
        this.suncoef.calculate();
        if (this.sourceToUpdateList.size() > 0) {
            for (IEnergySource source : this.sourceToUpdateList) {
                this.remove1(source);
            }
            this.sourceToUpdateList.clear();
        }
        for (EnergyTick tick : this.energyTickList) {
            IEnergySource entry = tick.getSource();
            tick.tick();
            if (tick.getList() != null && tick.getList().isEmpty()) continue;
            int multi = entry instanceof IMultiDual ? 4 : 1;
            for (int i = 0; i < multi; ++i) {
                double offer = Math.min(entry.canExtractEnergy(), EnergyNetGlobal.instance.getPowerFromTier(entry.getSourceTier()));
                if (offer > 0.0) {
                    double removed = offer - this.emitEnergyFrom(entry, offer, tick);
                    entry.extractEnergy(removed);
                    tick.addEnergy(removed);
                    continue;
                }
                if (!tick.isAdv() || !tick.getAdvSource().isSource()) continue;
                tick.getAdvSource().setPastEnergy(tick.getAdvSource().getPerEnergy());
            }
        }
        ++this.tick;
    }

    public IEnergyTile getTileEntity(BlockPos pos) {
        return this.chunkCoordinatesIEnergyTileMap.getOrDefault(pos, EnergyNetGlobal.EMPTY);
    }

    public NodeStats getNodeStats(IEnergyTile tile) {
        double emitted = this.getTotalEnergyEmitted(tile);
        double received = this.getTotalEnergySunken(tile);
        return new NodeStats(received, emitted);
    }

    public List<Path> getEnergyPaths(IEnergyTile energyTile) {
        ArrayList<Path> energyPathList = new ArrayList<Path>();
        if (energyTile instanceof IEnergySource) {
            return energyPathList;
        }
        if (energyTile instanceof IEnergyConductor) {
            for (Path energyPath : this.getPaths((IEnergyAcceptor)energyTile)) {
                if (!energyPath.conductors.contains(energyTile)) continue;
                energyPathList.add(energyPath);
            }
        }
        return energyPathList;
    }

    public void update(BlockPos pos) {
        for (EnumFacing dir : EnumFacing.values()) {
            BlockPos pos1 = pos.func_177972_a(dir);
            IEnergyTile tile = this.chunkCoordinatesIEnergyTileMap.get(pos1);
            if (tile == EnergyNetGlobal.EMPTY || !(tile instanceof IEnergyConductor)) continue;
            ((IEnergyConductor)tile).update_render();
        }
    }

    public Map<BlockPos, IEnergyTile> getChunkCoordinatesIEnergyTileMap() {
        return this.chunkCoordinatesIEnergyTileMap;
    }

    public void onUnload() {
        this.energyTickList.clear();
        this.chunkCoordinatesIEnergyTileMap.clear();
        this.controllerList.clear();
        this.suncoef = null;
    }

    public void onTileEntityAdded(IEnergyAcceptor tile) {
        ArrayList<IEnergyTile> tileEntitiesToCheck = new ArrayList<IEnergyTile>();
        ArrayList<BlockPos> blockPosList = new ArrayList<BlockPos>();
        blockPosList.add(tile.getBlockPos());
        tileEntitiesToCheck.add(tile);
        while (!tileEntitiesToCheck.isEmpty()) {
            IEnergyTile currentTileEntity = (IEnergyTile)tileEntitiesToCheck.remove(0);
            for (EnumFacing direction : EnumFacing.values()) {
                IEnergyTile target2 = this.getTileEntity(currentTileEntity.getBlockPos().func_177972_a(direction));
                if (target2 == EnergyNetGlobal.EMPTY || blockPosList.contains(target2.getBlockPos())) continue;
                blockPosList.add(target2.getBlockPos());
                if (target2 instanceof IEnergySource) {
                    if (this.sourceToUpdateList.contains((IEnergySource)target2)) continue;
                    this.sourceToUpdateList.add((IEnergySource)target2);
                    continue;
                }
                if (!(target2 instanceof IEnergyConductor)) continue;
                tileEntitiesToCheck.add(target2);
            }
        }
    }

    public void onTileEntityRemoved(IEnergyAcceptor par1) {
        this.onTileEntityAdded(par1);
    }
}

