/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.reskillable;

import codersafterdark.reskillable.api.data.PlayerDataHandler;
import codersafterdark.reskillable.api.data.PlayerSkillInfo;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.integration.reskillable.ReskillableItegration;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestData;
import com.feed_the_beast.ftbquests.quest.task.BooleanTaskData;
import com.feed_the_beast.ftbquests.quest.task.Task;
import com.feed_the_beast.ftbquests.quest.task.TaskData;
import com.feed_the_beast.ftbquests.quest.task.TaskType;
import java.util.Collection;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class ReskillableTask
extends Task {
    public static final ResourceLocation RESKILLABLE_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/reskillable.png");
    public String skill = "";
    public int skill_level = 0;

    public ReskillableTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return ReskillableItegration.RESKILLABLE_TASK;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("skill", this.skill);
        nbt.func_74768_a("skill_level", this.skill_level);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.skill = nbt.func_74779_i("skill");
        this.skill_level = nbt.func_74762_e("skill_level");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeString(this.skill);
        data.writeVarInt(this.skill_level);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.skill = data.readString();
        this.skill_level = data.readVarInt();
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("skill", () -> this.skill, v -> {
            this.skill = v;
        }, "");
        config.addInt("skill_level", () -> this.skill_level, v -> {
            this.skill_level = v;
        }, 0, 1, Integer.MAX_VALUE);
    }

    @Override
    public String getAltTitle() {
        return I18n.func_135052_a((String)"ftbquests.task.ftbquests.reskillable.skillyouneed", (Object[])new Object[0]) + ": " + TextFormatting.YELLOW + this.skill + " (" + this.skill_level + ")";
    }

    @Override
    public TaskData createData(QuestData data) {
        return new Data(this, data);
    }

    public static class Data
    extends BooleanTaskData<ReskillableTask> {
        public Data(ReskillableTask task, QuestData data) {
            super(task, data);
        }

        @Override
        public boolean canSubmit(EntityPlayerMP player) {
            return this.playerHasSkillLevel(player, ((ReskillableTask)this.task).skill, ((ReskillableTask)this.task).skill_level);
        }

        private boolean playerHasSkillLevel(EntityPlayerMP player, String skill, int lvl) {
            Collection skills = PlayerDataHandler.get((EntityPlayer)player).getAllSkillInfo();
            for (PlayerSkillInfo playerSkillInfo : skills) {
                if (!playerSkillInfo.skill.getName().equals(skill) || playerSkillInfo.getLevel() != lvl) continue;
                return true;
            }
            return false;
        }
    }
}

