/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.lib.gui.misc;

import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftblib.lib.gui.TextBox;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetLayout;
import net.minecraft.client.resources.I18n;

public abstract class GuiButtonListBase
extends GuiBase {
    private final Panel panelButtons = new Panel(this){

        @Override
        public void add(Widget widget) {
            if (!GuiButtonListBase.this.hasSearchBox || GuiButtonListBase.this.searchBox.getText().isEmpty() || GuiButtonListBase.this.getFilterText(widget).contains(GuiButtonListBase.this.searchBox.getText().toLowerCase())) {
                super.add(widget);
            }
        }

        @Override
        public void addWidgets() {
            GuiButtonListBase.this.addButtons(this);
        }

        @Override
        public void alignWidgets() {
            this.setY(GuiButtonListBase.this.hasSearchBox ? 23 : 9);
            int prevWidth = this.width;
            if (this.widgets.isEmpty()) {
                this.setWidth(100);
            } else {
                this.setWidth(100);
                for (Widget w : this.widgets) {
                    this.setWidth(Math.max(this.width, w.width));
                }
            }
            if (GuiButtonListBase.this.hasSearchBox) {
                this.setWidth(Math.max(this.width, prevWidth));
            }
            for (Widget w : this.widgets) {
                w.setX(GuiButtonListBase.this.borderH);
                w.setWidth(this.width - GuiButtonListBase.this.borderH * 2);
            }
            this.setHeight(140);
            GuiButtonListBase.this.scrollBar.setPosAndSize(this.posX + this.width + 6, this.posY - 1, 16, this.height + 2);
            GuiButtonListBase.this.scrollBar.setMaxValue(this.align(new WidgetLayout.Vertical(GuiButtonListBase.this.borderV, GuiButtonListBase.this.borderW, GuiButtonListBase.this.borderV)));
            this.getGui().setWidth(((GuiButtonListBase)GuiButtonListBase.this).scrollBar.posX + ((GuiButtonListBase)GuiButtonListBase.this).scrollBar.width + 8);
            this.getGui().setHeight(this.height + 18 + (GuiButtonListBase.this.hasSearchBox ? 14 : 0));
            if (GuiButtonListBase.this.hasSearchBox) {
                GuiButtonListBase.this.searchBox.setPosAndSize(8, 6, this.getGui().width - 16, 12);
            }
        }

        @Override
        public void drawBackground(Theme theme, int x, int y, int w, int h) {
            theme.drawPanelBackground(x, y, w, h);
        }
    };
    private final PanelScrollBar scrollBar;
    private String title = "";
    private TextBox searchBox;
    private boolean hasSearchBox;
    private int borderH;
    private int borderV;
    private int borderW;

    public GuiButtonListBase() {
        this.panelButtons.setPosAndSize(9, 9, 0, 146);
        this.scrollBar = new PanelScrollBar(this, this.panelButtons);
        this.scrollBar.setCanAlwaysScroll(true);
        this.scrollBar.setScrollStep(20);
        this.searchBox = new TextBox(this){

            @Override
            public void onTextChanged() {
                GuiButtonListBase.this.panelButtons.refreshWidgets();
            }
        };
        this.searchBox.ghostText = I18n.func_135052_a((String)"gui.search_box", (Object[])new Object[0]);
        this.hasSearchBox = false;
    }

    public void setHasSearchBox(boolean v) {
        if (this.hasSearchBox != v) {
            this.hasSearchBox = v;
            this.refreshWidgets();
        }
    }

    public String getFilterText(Widget widget) {
        return widget.getTitle().toLowerCase();
    }

    @Override
    public void addWidgets() {
        this.add(this.panelButtons);
        this.add(this.scrollBar);
        if (this.hasSearchBox) {
            this.add(this.searchBox);
        }
    }

    @Override
    public void alignWidgets() {
        this.panelButtons.alignWidgets();
    }

    public abstract void addButtons(Panel var1);

    public void setTitle(String txt) {
        this.title = txt;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    public void setBorder(int h, int v, int w) {
        this.borderH = h;
        this.borderV = v;
        this.borderW = w;
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        super.drawBackground(theme, x, y, w, h);
        String title = this.getTitle();
        if (!title.isEmpty()) {
            theme.drawString(title, x + (this.width - theme.getStringWidth(title)) / 2, y - theme.getFontHeight() - 2, 2);
        }
    }

    public void focus() {
        this.searchBox.setFocused(true);
    }
}

