/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.events;

import divinerpg.DivineRPG;
import divinerpg.registry.BlockRegistry;
import divinerpg.registry.DimensionRegistry;
import divinerpg.utils.DivineTeleporter;
import divinerpg.utils.portals.ServerPortal;
import divinerpg.utils.portals.VetheaPortal;
import divinerpg.utils.portals.description.ArcanaPortalRoomDescription;
import divinerpg.utils.portals.description.IPortalDescription;
import divinerpg.utils.portals.description.NetherLikePortalDescription;
import divinerpg.utils.portals.description.VetheaPortalDescription;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.util.ITeleporter;

public class DimensionHelper {
    public static final Map<Block, IPortalDescription> descriptionsByBlock = new HashMap<Block, IPortalDescription>();
    public static final Map<DimensionType, IPortalDescription> descriptionsByDimension = new HashMap<DimensionType, IPortalDescription>();
    private static final Map<DimensionType, ITeleporter> teleporterMapByModdedDimension = new HashMap<DimensionType, ITeleporter>();
    public static final ArcanaPortalRoomDescription arcanaPortalHelper = new ArcanaPortalRoomDescription(BlockRegistry.arcanaPortalFrame, BlockRegistry.arcanaPortal);

    public static void initPortalDescriptions() {
        ServerPortal portal = new ServerPortal(128, 200);
        DimensionHelper.add(DimensionRegistry.edenDimension, new NetherLikePortalDescription(BlockRegistry.divineRock, (Block)BlockRegistry.edenPortal), portal);
        DimensionHelper.add(DimensionRegistry.wildwoodDimension, new NetherLikePortalDescription(BlockRegistry.edenBlock, (Block)BlockRegistry.wildwoodPortal), portal);
        DimensionHelper.add(DimensionRegistry.apalachiaDimension, new NetherLikePortalDescription(BlockRegistry.wildwoodBlock, (Block)BlockRegistry.apalachiaPortal), portal);
        DimensionHelper.add(DimensionRegistry.skythernDimension, new NetherLikePortalDescription(BlockRegistry.apalachiaBlock, (Block)BlockRegistry.skythernPortal), portal);
        DimensionHelper.add(DimensionRegistry.mortumDimension, new NetherLikePortalDescription(BlockRegistry.skythernBlock, (Block)BlockRegistry.mortumPortal), portal);
        DimensionHelper.add(DimensionRegistry.iceikaDimension, new NetherLikePortalDescription(Blocks.field_150433_aE, (Block)BlockRegistry.iceikaPortal), portal);
        VetheaPortal vetheaPortal = new VetheaPortal(128, 1200);
        DimensionHelper.add(DimensionRegistry.vetheaDimension, new VetheaPortalDescription(), vetheaPortal);
    }

    private static void add(DimensionType type, IPortalDescription description, ITeleporter teleporter) {
        descriptionsByBlock.put(description.getFrame(), description);
        descriptionsByDimension.put(type, description);
        teleporterMapByModdedDimension.put(type, teleporter);
    }

    public static void transferEntity(Entity e, DimensionType modDimension) {
        if (e == null || modDimension == null) {
            return;
        }
        DimensionType current = e.func_130014_f_().field_73011_w.func_186058_p();
        ITeleporter teleporter = teleporterMapByModdedDimension.get(current);
        if (teleporter == null) {
            teleporter = teleporterMapByModdedDimension.get(modDimension);
        }
        if (teleporter == null) {
            DivineRPG.logger.warn(String.format("Unknown dimensions: 1) %s/n2)%s", current.func_186065_b(), modDimension.func_186065_b()));
            return;
        }
        e.changeDimension(modDimension.func_186068_a(), teleporter);
    }

    public static void transferEntityToDivineDims(Entity e, DimensionType destination) {
        if (e == null || destination == null || e.func_184102_h() == null) {
            return;
        }
        DimensionType current = e.func_130014_f_().field_73011_w.func_186058_p();
        IPortalDescription description = descriptionsByDimension.get(destination);
        if (description == null) {
            description = descriptionsByDimension.get(current);
        }
        if (description == null) {
            DivineRPG.logger.warn(String.format("Unknown dimensions: 1) %s/n2)%s", current.func_186065_b(), destination.func_186065_b()));
            return;
        }
        DivineTeleporter teleporter = new DivineTeleporter(e.func_184102_h().func_71218_a(destination.func_186068_a()), description.getPortal(), description.getFrame().func_176223_P());
        e.changeDimension(destination.func_186068_a(), (ITeleporter)teleporter);
    }
}

