/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.dimensions;

import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenerator;

public class TwilightBiomeBase
extends Biome {
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    protected WorldGenerator genTree;
    protected WorldGenerator genLargeTree;
    protected WorldGenerator genConeUp;
    protected WorldGenerator genLakes;
    protected WorldGenerator brush;
    protected WorldGenerator bloom;
    protected WorldGenerator blossom;
    protected Chunk chunk;

    public TwilightBiomeBase(Biome.BiomeProperties properties, String name) {
        super(properties);
        this.setRegistryName("divinerpg", name);
    }

    public void func_180624_a(World worldIn, Random rand, BlockPos pos) {
        this.chunk = worldIn.func_175726_f(pos);
        this.generate(worldIn, rand, this.chunk.field_76635_g, this.chunk.field_76647_h, 4, 13, 93, this.bloom, this.genLargeTree);
        this.generate(worldIn, rand, this.chunk.field_76635_g, this.chunk.field_76647_h, 10, 13, 93, this.brush, this.blossom);
        this.generate(worldIn, rand, this.chunk.field_76635_g, this.chunk.field_76647_h, 100, 13, 93, this.brush);
        this.generate(worldIn, rand, this.chunk.field_76635_g, this.chunk.field_76647_h, 10, 55, 75, this.genTree);
        this.generate(worldIn, rand, this.chunk.field_76635_g, this.chunk.field_76647_h, 1, 55, 75, this.genLakes, this.genConeUp);
    }

    protected void generate(World world, Random random, int chunkX, int chunkZ, int tries, int minY, int maxY, WorldGenerator ... generators) {
        random = world.func_72843_D(chunkX, chunkZ, 10387313);
        if (generators != null && generators.length > 0) {
            int height = this.getHeightOrThrow(minY, maxY);
            for (int i = 0; i < tries; ++i) {
                for (WorldGenerator generator : generators) {
                    if (generator == null) continue;
                    this.pos.func_181079_c(chunkX * 16 + random.nextInt(16) + 8, minY + random.nextInt(height + 1), chunkZ * 16 + random.nextInt(16) + 8);
                    generator.func_180709_b(world, random, (BlockPos)this.pos);
                }
            }
        }
    }

    private int getHeightOrThrow(int minY, int maxY) {
        int height = maxY - minY;
        if (height <= 0) {
            throw new IllegalArgumentException("Max Y equals or less min Y");
        }
        if (minY < 0 || maxY > 256) {
            throw new IllegalArgumentException("Ore Generated Out of Bounds");
        }
        return height;
    }
}

