/*
 * Decompiled with CFR 0.152.
 */
package divinerpg.api.armor;

import divinerpg.api.DivineAPI;
import divinerpg.api.armor.IItemContainer;
import divinerpg.api.armor.cap.IArmorPowers;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.eventhandler.Event;

public class ArmorEquippedEvent
extends Event {
    private final Set<ResourceLocation> confirmed = new HashSet<ResourceLocation>();
    private final Map<EntityEquipmentSlot, Set<Item>> items = new LinkedHashMap<EntityEquipmentSlot, Set<Item>>();

    public ArmorEquippedEvent(Entity player) {
        IArmorPowers powers = DivineAPI.getArmorPowers(player);
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            HashSet<Item> slotItems = new HashSet<Item>();
            if (powers != null) {
                slotItems.addAll(powers.currentItems(slot));
            }
            this.items.put(slot, slotItems);
        }
    }

    public ArmorEquippedEvent(Map<EntityEquipmentSlot, ItemStack> items) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            HashSet<Item> slotItems = new HashSet<Item>();
            ItemStack stack = items.get(slot);
            slotItems.add(stack.func_77973_b());
            if (stack.func_77973_b() instanceof IItemContainer) {
                slotItems.addAll(((IItemContainer)stack.func_77973_b()).getItems(stack));
            }
            this.items.put(slot, slotItems);
        }
    }

    public Set<Item> getItemsInSlot(EntityEquipmentSlot slot) {
        return Collections.unmodifiableSet(this.items.get(slot));
    }

    public void confirm(ResourceLocation id) {
        this.confirmed.add(id);
    }

    public void remove(ResourceLocation id) {
        this.confirmed.remove(id);
    }

    public Set<ResourceLocation> getConfirmed() {
        return new HashSet<ResourceLocation>(this.confirmed);
    }
}

