/*
 * Decompiled with CFR 0.152.
 */
package dev.ricobrase.chatcalculator.events;

import dev.ricobrase.chatcalculator.termsolver.TermSolver;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.SERVER})
public class ServerChatEventListener {
    @SubscribeEvent
    public static void onServerChatEvent(ServerChatEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        String chatMessage = event.getMessage();
        EntityPlayerMP player = event.getPlayer();
        if (chatMessage.matches("@=[^=]*")) {
            block6: {
                Optional<String> postfix = TermSolver.transformInfixToPostfix(chatMessage.substring(2));
                if (postfix.isPresent()) {
                    try {
                        double result = TermSolver.solvePostfix(postfix.get());
                        server.func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("chat.chatcalculator.globalcalcmessage", new Object[]{player.getDisplayNameString(), chatMessage.substring(2)}));
                        if (result == Math.floor(result) && !Double.isInfinite(result) && result <= 2.147483647E9 && result >= -2.147483648E9) {
                            result = Math.floor(result);
                            server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(String.format("= %d", (int)result)));
                            break block6;
                        }
                        server.func_184103_al().func_148539_a((ITextComponent)new TextComponentString(String.format("= %f", result)));
                    }
                    catch (NumberFormatException ex) {
                        ServerChatEventListener.printInvalidCharactersMessage(player);
                    }
                } else {
                    ServerChatEventListener.printInvalidCharactersMessage(player);
                }
            }
            event.setCanceled(true);
        }
    }

    private static void printInvalidCharactersMessage(EntityPlayerMP player) {
        Style redColor = new Style().func_150238_a(TextFormatting.RED);
        player.func_145747_a(new TextComponentTranslation("chat.chatcalculator.invalidcharacters", new Object[0]).func_150255_a(redColor));
    }
}

