/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network;

import com.brandon3055.brandonscore.lib.ModContributorHandler;
import com.brandon3055.brandonscore.network.MessageHandlerWrapper;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketContributor
implements IMessage {
    private String modid;
    private String contributor;
    private NBTTagCompound data;

    public PacketContributor() {
    }

    public PacketContributor(String modid, String contributor, NBTTagCompound data) {
        this.modid = modid;
        this.contributor = contributor;
        this.data = data;
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modid);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.contributor);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
    }

    public void fromBytes(ByteBuf buf) {
        this.modid = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.contributor = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public static class Handler
    extends MessageHandlerWrapper<PacketContributor, IMessage> {
        @Override
        public IMessage handleMessage(PacketContributor message, MessageContext ctx) {
            if (!ModContributorHandler.MOD_CONTRIBUTOR_HANDLERS.containsKey(message.modid)) {
                return null;
            }
            ModContributorHandler handler = ModContributorHandler.MOD_CONTRIBUTOR_HANDLERS.get(message.modid);
            if (ctx.side == Side.CLIENT) {
                handler.configReceivedClient(message.data, message.contributor);
            } else {
                handler.configReceivedServer(message.data, message.contributor, ctx.getServerHandler().field_147369_b);
            }
            return null;
        }
    }
}

