/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.config;

import com.brandon3055.brandonscore.registry.ModConfigParser;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.ConfigGuiType;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiEditArrayEntries;
import net.minecraftforge.fml.client.config.IConfigElement;

public class BCConfigElement
implements IConfigElement {
    public final String modid;
    public Property prop;
    public Property.Type type;
    public boolean isProperty;
    public ConfigCategory category;
    public boolean categoriesFirst = true;
    public boolean isLocked = false;

    public BCConfigElement(String modid, ConfigCategory category) {
        this.modid = modid;
        this.category = category;
        this.isProperty = false;
    }

    public BCConfigElement(String modid, Property prop) {
        this.modid = modid;
        this.prop = prop;
        this.type = prop.getType();
        this.isProperty = true;
        this.isLocked = ModConfigParser.isPropLocked(modid, prop);
    }

    public BCConfigElement listCategoriesFirst(boolean categoriesFirst) {
        this.categoriesFirst = categoriesFirst;
        return this;
    }

    public List<IConfigElement> getChildElements() {
        if (!this.isProperty) {
            BCConfigElement temp;
            ArrayList<IConfigElement> elements = new ArrayList<IConfigElement>();
            Iterator ccI = this.category.getChildren().iterator();
            Iterator pI = this.category.getOrderedValues().iterator();
            boolean index = false;
            if (this.categoriesFirst) {
                while (ccI.hasNext()) {
                    temp = new BCConfigElement(this.modid, (ConfigCategory)ccI.next());
                    if (!temp.showInGui()) continue;
                    elements.add(temp);
                }
            }
            while (pI.hasNext()) {
                temp = new BCConfigElement(this.modid, (Property)pI.next());
                if (!temp.showInGui()) continue;
                elements.add(temp);
            }
            if (!this.categoriesFirst) {
                while (ccI.hasNext()) {
                    temp = new BCConfigElement(this.modid, (ConfigCategory)ccI.next());
                    if (!temp.showInGui()) continue;
                    elements.add(temp);
                }
            }
            return elements;
        }
        return null;
    }

    public String getName() {
        return this.isProperty ? this.prop.getName() : this.category.getName();
    }

    public boolean isProperty() {
        return this.isProperty;
    }

    public Class<? extends GuiConfigEntries.IConfigEntry> getConfigEntryClass() {
        return this.isProperty ? this.prop.getConfigEntryClass() : this.category.getConfigEntryClass();
    }

    public Class<? extends GuiEditArrayEntries.IArrayEntry> getArrayEntryClass() {
        return this.isProperty ? this.prop.getArrayEntryClass() : null;
    }

    public String getQualifiedName() {
        return this.isProperty ? this.prop.getName() : this.category.getQualifiedName();
    }

    public ConfigGuiType getType() {
        return this.isProperty ? BCConfigElement.getType(this.prop) : ConfigGuiType.CONFIG_CATEGORY;
    }

    public static ConfigGuiType getType(Property prop) {
        return prop.getType() == Property.Type.BOOLEAN ? ConfigGuiType.BOOLEAN : (prop.getType() == Property.Type.DOUBLE ? ConfigGuiType.DOUBLE : (prop.getType() == Property.Type.INTEGER ? ConfigGuiType.INTEGER : (prop.getType() == Property.Type.COLOR ? ConfigGuiType.COLOR : (prop.getType() == Property.Type.MOD_ID ? ConfigGuiType.MOD_ID : ConfigGuiType.STRING))));
    }

    public boolean isList() {
        return this.isProperty && this.prop.isList();
    }

    public boolean isListLengthFixed() {
        return this.isProperty && this.prop.isListLengthFixed();
    }

    public int getMaxListLength() {
        return this.isProperty ? this.prop.getMaxListLength() : -1;
    }

    public String getComment() {
        return this.isProperty ? this.prop.getComment() : this.category.getComment();
    }

    public boolean isDefault() {
        return !this.isProperty || this.prop.isDefault();
    }

    public void setToDefault() {
        if (this.isProperty) {
            this.prop.setToDefault();
        }
    }

    public boolean requiresWorldRestart() {
        return this.isProperty ? this.prop.requiresWorldRestart() : this.category.requiresWorldRestart();
    }

    public boolean showInGui() {
        return this.isProperty ? this.prop.showInGui() : this.category.showInGui();
    }

    public boolean requiresMcRestart() {
        return this.isProperty ? this.prop.requiresMcRestart() : this.category.requiresMcRestart();
    }

    public String[] getValidValues() {
        return this.isProperty ? this.prop.getValidValues() : null;
    }

    public String getLanguageKey() {
        return this.isProperty ? this.prop.getLanguageKey() : this.category.getLanguagekey();
    }

    public Object getDefault() {
        return this.isProperty ? this.prop.getDefault() : null;
    }

    public Object[] getDefaults() {
        if (this.isProperty) {
            Object[] aVal = this.prop.getDefaults();
            if (this.type == Property.Type.BOOLEAN) {
                Object[] ba = new Boolean[aVal.length];
                for (int i = 0; i < aVal.length; ++i) {
                    ba[i] = Boolean.valueOf((String)aVal[i]);
                }
                return ba;
            }
            if (this.type == Property.Type.DOUBLE) {
                Object[] da = new Double[aVal.length];
                for (int i = 0; i < aVal.length; ++i) {
                    da[i] = Double.valueOf(((String)aVal[i]).toString());
                }
                return da;
            }
            if (this.type == Property.Type.INTEGER) {
                Object[] ia = new Integer[aVal.length];
                for (int i = 0; i < aVal.length; ++i) {
                    ia[i] = Integer.valueOf(((String)aVal[i]).toString());
                }
                return ia;
            }
            return aVal;
        }
        return null;
    }

    public Pattern getValidationPattern() {
        return this.isProperty ? this.prop.getValidationPattern() : null;
    }

    public Object get() {
        return this.isProperty ? this.prop.getString() : null;
    }

    public Object[] getList() {
        if (this.isProperty) {
            Object[] aVal = this.prop.getStringList();
            if (this.type == Property.Type.BOOLEAN) {
                Object[] ba = new Boolean[aVal.length];
                for (int i = 0; i < aVal.length; ++i) {
                    ba[i] = Boolean.valueOf((String)aVal[i]);
                }
                return ba;
            }
            if (this.type == Property.Type.DOUBLE) {
                Object[] da = new Double[aVal.length];
                for (int i = 0; i < aVal.length; ++i) {
                    da[i] = Double.valueOf(((String)aVal[i]).toString());
                }
                return da;
            }
            if (this.type == Property.Type.INTEGER) {
                Object[] ia = new Integer[aVal.length];
                for (int i = 0; i < aVal.length; ++i) {
                    ia[i] = Integer.valueOf(((String)aVal[i]).toString());
                }
                return ia;
            }
            return aVal;
        }
        return null;
    }

    public void set(Object value) {
        if (this.isProperty) {
            if (this.type == Property.Type.BOOLEAN) {
                this.prop.set(Boolean.parseBoolean(value.toString()));
            } else if (this.type == Property.Type.DOUBLE) {
                this.prop.set(Double.parseDouble(value.toString()));
            } else if (this.type == Property.Type.INTEGER) {
                this.prop.set(Integer.parseInt(value.toString()));
            } else {
                this.prop.set(value.toString());
            }
        }
    }

    public void set(Object[] aVal) {
        if (this.isProperty) {
            if (this.type == Property.Type.BOOLEAN) {
                boolean[] ba = new boolean[aVal.length];
                for (int i = 0; i < aVal.length; ++i) {
                    ba[i] = Boolean.valueOf(aVal[i].toString());
                }
                this.prop.set(ba);
            } else if (this.type == Property.Type.DOUBLE) {
                double[] da = new double[aVal.length];
                for (int i = 0; i < aVal.length; ++i) {
                    da[i] = Double.valueOf(aVal[i].toString());
                }
                this.prop.set(da);
            } else if (this.type == Property.Type.INTEGER) {
                int[] ia = new int[aVal.length];
                for (int i = 0; i < aVal.length; ++i) {
                    ia[i] = Integer.valueOf(aVal[i].toString());
                }
                this.prop.set(ia);
            } else {
                String[] is = new String[aVal.length];
                for (int i = 0; i < aVal.length; ++i) {
                    is[i] = aVal[i].toString();
                }
                this.prop.set(is);
            }
        }
    }

    public Object getMinValue() {
        return this.isProperty ? this.prop.getMinValue() : null;
    }

    public Object getMaxValue() {
        return this.isProperty ? this.prop.getMaxValue() : null;
    }
}

