/*
 * Decompiled with CFR 0.152.
 */
package wanion.avaritiaddons.block.infinitycompressor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.Loader;
import wanion.avaritiaddons.block.RecipeResultItemElement;
import wanion.avaritiaddons.block.infinitycompressor.CompressorRecipeField;
import wanion.avaritiaddons.block.infinitycompressor.TileEntityInfinityCompressor;
import wanion.lib.client.gui.ITooltipSupplier;
import wanion.lib.client.gui.LetterBoxElement;
import wanion.lib.client.gui.WElement;
import wanion.lib.client.gui.WGuiContainer;
import wanion.lib.client.gui.field.CheckBoxWElement;
import wanion.lib.client.gui.interaction.WInteraction;
import wanion.lib.common.WContainer;
import wanion.lib.common.control.redstone.RedstoneControl;
import wanion.lib.common.control.redstone.RedstoneControlWButton;
import wanion.lib.common.field.CheckBox;

public class GuiInfinityCompressor
extends WGuiContainer<TileEntityInfinityCompressor> {
    private static final ResourceLocation guiTexture = new ResourceLocation("avaritiaddons", "textures/gui/infinity_compressor.png");
    private static final boolean JEI_PRESENT = Loader.isModLoaded((String)"jei");

    public GuiInfinityCompressor(@Nonnull WContainer<TileEntityInfinityCompressor> wContainer) {
        super(wContainer, guiTexture, 176, 166);
        this.addElement(new RecipeResultItemElement(() -> ((TileEntityInfinityCompressor)this.getTile()).compressorRecipeField.getCompressorRecipeOutput(), this, this.getGuiLeft() + this.getXSize() / 2 - 8, this.getGuiTop() + 33).setTooltipSupplier(new SingularityTooltipSupplier()));
        LetterBoxElement showRecipesElement = new LetterBoxElement('R', (WGuiContainer)this, this.getGuiLeft() + this.getXSize() - 25, this.getGuiTop() + 7);
        if (!JEI_PRESENT) {
            ((LetterBoxElement)showRecipesElement.setDefaultForegroundCheck()).setTooltipSupplier((interaction, stackSupplier) -> Lists.newArrayList((Object[])new String[]{I18n.func_135052_a((String)"avaritiaddons.no.jei", (Object[])new Object[0])}));
        }
        this.addElement((WElement)showRecipesElement);
        this.addElement((WElement)new RedstoneControlWButton((RedstoneControl)this.getControl(RedstoneControl.class), (WGuiContainer)this, this.getGuiLeft() + this.getXSize() - 25, this.getGuiTop() + 29, true));
        this.addElement((WElement)new CheckBoxWElement((CheckBox)this.getField("avaritiaddons.compressor.trashcan"), (WGuiContainer)this, this.field_147003_i + this.getGuiLeft() + this.getXSize() - 25, this.getGuiTop() + 51));
    }

    private final class SingularityTooltipSupplier
    implements ITooltipSupplier {
        private SingularityTooltipSupplier() {
        }

        public List<String> getTooltip(@Nonnull WInteraction wInteraction, @Nonnull Supplier<ItemStack> supplier) {
            TileEntityInfinityCompressor tile = (TileEntityInfinityCompressor)GuiInfinityCompressor.this.getTile();
            CompressorRecipeField compressorRecipeField = tile.compressorRecipeField;
            ItemStack outputStack = compressorRecipeField.getCompressorRecipeOutput();
            ArrayList<String> tooltip = new ArrayList<String>();
            if (compressorRecipeField.isNull() || outputStack.func_190926_b()) {
                return tooltip;
            }
            tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"avaritiaddons.compressor.making", (Object[])new Object[0]));
            tooltip.add(outputStack.func_77953_t().field_77937_e + outputStack.func_82833_r());
            tooltip.add(compressorRecipeField.getProgress());
            tooltip.add("");
            tooltip.add(TextFormatting.GOLD + I18n.func_135052_a((String)"avaritiaddons.clear.recipe", (Object[])new Object[0]));
            tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"avaritiaddons.compressor.clear.note", (Object[])new Object[0]) + " " + TextFormatting.WHITE + I18n.func_135052_a((String)"avaritiaddons.compressor.clear.warning", (Object[])new Object[0]));
            return tooltip;
        }
    }
}

