/*
 * Decompiled with CFR 0.152.
 */
package wanion.avaritiaddons.block.chest.infinity;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import wanion.avaritiaddons.block.chest.TileEntityAvaritiaddonsChest;
import wanion.avaritiaddons.block.chest.infinity.InfinityMatching;
import wanion.avaritiaddons.proxy.ClientProxy;
import wanion.lib.common.matching.AbstractMatching;
import wanion.lib.common.matching.MatchingController;

public final class TileEntityInfinityChest
extends TileEntityAvaritiaddonsChest {
    private static final NonNullList<ItemStack> EMPTY_NON_NULL_LIST = NonNullList.func_191197_a((int)0, (Object)ItemStack.field_190927_a);
    private final List<InfinityMatching> infinityMatchingList = new ArrayList<InfinityMatching>();
    private final InfinityChestInvWrapper infinityChestInvWrapper;

    public TileEntityInfinityChest() {
        MatchingController matchingController = (MatchingController)this.getController(MatchingController.class);
        for (int i = 0; i < 243; ++i) {
            this.addInfinityMatching(matchingController, i);
        }
        this.infinityChestInvWrapper = new InfinityChestInvWrapper();
        this.addCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, this.infinityChestInvWrapper);
    }

    public InfinityMatching getInfinityMatching(int num) {
        return this.infinityMatchingList.get(num);
    }

    private void addInfinityMatching(@Nonnull MatchingController matchingController, int number) {
        InfinityMatching infinityMatching = new InfinityMatching(this, number);
        this.infinityMatchingList.add(infinityMatching);
        matchingController.add(new AbstractMatching[]{infinityMatching});
    }

    public InfinityChestInvWrapper getInfinityChestInvWrapper() {
        return this.infinityChestInvWrapper;
    }

    protected NonNullList<ItemStack> getItemStacks() {
        return EMPTY_NON_NULL_LIST;
    }

    public int func_70302_i_() {
        return 244;
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        return this.infinityChestInvWrapper.getStackInSlot(index);
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return this.infinityChestInvWrapper.extractItem(index, count, false);
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, @Nonnull ItemStack stack) {
        this.infinityChestInvWrapper.setStackInSlot(index, stack);
    }

    public int func_70297_j_() {
        return Integer.MAX_VALUE;
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        return this.infinityChestInvWrapper.isItemValid(index, stack);
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nonnull EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull EnumFacing direction) {
        return index != 243;
    }

    @Nonnull
    public String getDefaultName() {
        return "container.infinity_chest.name";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected ResourceLocation getTexture() {
        return ClientProxy.INFINITY_CHEST_ANIMATION.getCurrentFrame();
    }

    public class InfinityChestInvWrapper
    implements IItemHandlerModifiable {
        private InfinityChestInvWrapper() {
        }

        public int findSlotFor(@Nonnull ItemStack itemStack) {
            for (InfinityMatching infinityMatching : TileEntityInfinityChest.this.infinityMatchingList) {
                if (!infinityMatching.accepts(itemStack) || !infinityMatching.matches(itemStack)) continue;
                return infinityMatching.getNumber();
            }
            for (InfinityMatching infinityMatching : TileEntityInfinityChest.this.infinityMatchingList) {
                if (!infinityMatching.isEmpty()) continue;
                return infinityMatching.getNumber();
            }
            return -1;
        }

        public int findSlotFor(int slot, @Nonnull ItemStack itemStack) {
            return TileEntityInfinityChest.this.getInfinityMatching(slot).matches(itemStack) ? slot : this.findSlotFor(itemStack);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack itemStack) {
            if (slot == -1 || slot == 243) {
                return;
            }
            TileEntityInfinityChest.this.getInfinityMatching(this.findSlotFor(slot, itemStack)).insert(itemStack);
        }

        public int getSlots() {
            return 244;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (slot == -1 || slot == 243) {
                return ItemStack.field_190927_a;
            }
            return TileEntityInfinityChest.this.getInfinityMatching(slot).getStack();
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot == 243) {
                return stack;
            }
            InfinityMatching infinityMatching = (InfinityMatching)((Object)TileEntityInfinityChest.this.infinityMatchingList.get(slot));
            int n = slot = infinityMatching.isEmpty() || infinityMatching.matches(stack) ? slot : this.findSlotFor(stack);
            if (slot == -1) {
                return stack;
            }
            if (!simulate) {
                this.setStackInSlot(slot, stack);
            }
            return ItemStack.field_190927_a;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot == 243) {
                return ItemStack.field_190927_a;
            }
            return TileEntityInfinityChest.this.getInfinityMatching(slot).extract(amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return Integer.MAX_VALUE;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            InfinityMatching infinityMatching;
            if (slot == 243) {
                slot = this.findSlotFor(stack);
            }
            InfinityMatching infinityMatching2 = infinityMatching = slot != -1 ? (InfinityMatching)((Object)TileEntityInfinityChest.this.infinityMatchingList.get(slot)) : null;
            return infinityMatching != null ? infinityMatching.isEmpty() || infinityMatching.matches(stack) : this.findSlotFor(stack) != -1;
        }
    }
}

