/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.item.tools;

import codechicken.lib.util.ItemUtils;
import java.util.List;
import java.util.Set;
import morph.avaritia.Avaritia;
import morph.avaritia.entity.EntityImmortalItem;
import morph.avaritia.handler.AvaritiaEventHandler;
import morph.avaritia.init.ModItems;
import morph.avaritia.item.ItemMatterCluster;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHoeInfinity
extends ItemHoe {
    private static final Item.ToolMaterial TOOL_MATERIAL = EnumHelper.addToolMaterial((String)"INFINITY_HOE", (int)32, (int)9999, (float)9999.0f, (float)20.0f, (int)200);

    public ItemHoeInfinity() {
        super(TOOL_MATERIAL);
        this.func_77655_b("avaritia:infinity_hoe");
        this.setRegistryName("infinity_hoe");
        this.func_77637_a(Avaritia.tab);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos origin, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.attemptHoe(stack, player, world, origin, facing) && world.func_180495_p(origin).func_177230_c() != Blocks.field_150458_ak) {
            return EnumActionResult.FAIL;
        }
        if (player.func_70093_af()) {
            return EnumActionResult.FAIL;
        }
        int aoe_range = 4;
        AvaritiaEventHandler.enableItemCapture();
        for (BlockPos aoePos : BlockPos.func_177980_a((BlockPos)origin.func_177982_a(-aoe_range, 0, -aoe_range), (BlockPos)origin.func_177982_a(aoe_range, 0, aoe_range))) {
            boolean up2OK;
            BlockEvent.PlaceEvent event;
            boolean lowerBlockOk;
            if (aoePos.equals((Object)origin)) continue;
            boolean airOrReplaceable = world.func_175623_d(aoePos) || world.func_180495_p(aoePos).func_177230_c().func_176200_f((IBlockAccess)world, aoePos);
            boolean bl = lowerBlockOk = world.isSideSolid(aoePos.func_177977_b(), EnumFacing.UP) || world.func_180495_p(aoePos.func_177977_b()).func_177230_c() == Blocks.field_150458_ak;
            if (airOrReplaceable && lowerBlockOk && (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_70431_c(new ItemStack(Blocks.field_150346_d))) && !(event = ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)new BlockSnapshot(world, aoePos, Blocks.field_150346_d.func_176223_P()), (EnumFacing)EnumFacing.UP, (EnumHand)player.func_184600_cs())).isCanceled() && (player.field_71075_bZ.field_75098_d || this.consumeStack(new ItemStack(Blocks.field_150346_d), (IInventory)player.field_71071_by))) {
                world.func_175656_a(aoePos, Blocks.field_150346_d.func_176223_P());
            }
            boolean canDropAbove = world.func_180495_p(aoePos.func_177984_a()).func_177230_c() == Blocks.field_150346_d || world.func_180495_p(aoePos.func_177984_a()).func_177230_c() == Blocks.field_150349_c || world.func_180495_p(aoePos.func_177984_a()).func_177230_c() == Blocks.field_150458_ak;
            boolean canRemoveAbove = canDropAbove || world.func_180495_p(aoePos.func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, aoePos.func_177984_a());
            boolean bl2 = up2OK = world.func_175623_d(aoePos.func_177984_a().func_177984_a()) || world.func_180495_p(aoePos.func_177984_a().func_177984_a()).func_177230_c().func_176200_f((IBlockAccess)world, aoePos.func_177984_a().func_177984_a());
            if (!world.func_175623_d(aoePos.func_177984_a()) && canRemoveAbove && up2OK) {
                if (!world.field_72995_K && canDropAbove) {
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, new ItemStack(Blocks.field_150346_d)));
                }
                world.func_175698_g(aoePos.func_177984_a());
            }
            this.attemptHoe(stack, player, world, aoePos, facing);
        }
        AvaritiaEventHandler.stopItemCapture();
        Set<ItemStack> drops = AvaritiaEventHandler.getCapturedDrops();
        if (!world.field_72995_K) {
            List<ItemStack> clusters = ItemMatterCluster.makeClusters(drops);
            for (ItemStack cluster : clusters) {
                ItemUtils.dropItem((World)world, (BlockPos)origin.func_177984_a(), (ItemStack)cluster);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean consumeStack(ItemStack stack, IInventory inventory) {
        if (stack.func_190926_b()) {
            return false;
        }
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack s = inventory.func_70301_a(i);
            if (s.func_190926_b() || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)s) || stack.func_77952_i() != s.func_77952_i() || s.func_190916_E() < stack.func_190916_E()) continue;
            s.func_190918_g(stack.func_190916_E());
            inventory.func_70296_d();
            return true;
        }
        return false;
    }

    private boolean attemptHoe(ItemStack hoeStack, EntityPlayer player, World world, BlockPos pos, EnumFacing face) {
        if (!player.func_175151_a(pos, face, hoeStack)) {
            return false;
        }
        int hook = ForgeEventFactory.onHoeUse((ItemStack)hoeStack, (EntityPlayer)player, (World)world, (BlockPos)pos);
        if (hook != 0) {
            return hook > 0;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (face != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da) {
                this.func_185071_a(hoeStack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                return true;
            }
            if (block == Blocks.field_150346_d) {
                switch ((BlockDirt.DirtType)state.func_177229_b((IProperty)BlockDirt.field_176386_a)) {
                    case DIRT: {
                        this.func_185071_a(hoeStack, player, world, pos, Blocks.field_150458_ak.func_176223_P());
                        return true;
                    }
                    case COARSE_DIRT: {
                        this.func_185071_a(hoeStack, player, world, pos, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT));
                        return true;
                    }
                }
            }
        }
        return false;
    }

    protected void func_185071_a(ItemStack stack, EntityPlayer player, World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_184133_a(player, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos, state, 11);
        }
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return ModItems.COSMIC_RARITY;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityImmortalItem(world, location, itemstack);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return false;
    }
}

